#open "windows";;
#open "camlwin";;

#open "g_global";;
#open "g_button";;
#open "g_item";;








let unselect_all_items ItemVect =
  let length=vect_length ItemVect in
    if not length=0
    then
    (
      for i=0 to (length - 1) do
        match ItemVect.(i).it_state with
          Unselectable -> ()
        | _            -> ItemVect.(i).it_state <- Unselected
      done
    )
;;




let update_selected_item Menu =
  unselect_all_items Menu.mn_items;
  if not vect_length Menu.mn_items=0
  then
  (
    let Item=Menu.mn_items.(Menu.mn_nu_item) in
      if not Item.it_state=Unselectable
      then Item.it_state <- Selected
  )
;;




let rec gr_menu_width_loop ItemVect Pos Length =
  if Pos=Length
  then 0
  else max (fst (text_size ItemVect.(Pos).it_name))
           (gr_menu_width_loop ItemVect (Pos + 1) Length)
;;

let gr_menu_width ItemVect =
   gr_menu_width_loop ItemVect 0 (vect_length ItemVect);;




let std_draw_menu_items Menu =
  update_selected_item Menu;
  let menu_width=(gr_menu_width Menu.mn_items) + 2*long_space
  and text_height = line_height + 3*short_space
  and length=vect_length Menu.mn_items in
    let xleft  =Menu.mn_left
    and ytop   =Menu.mn_top
    and width  =menu_width + 4*short_space
    and height  =length * text_height + 4*short_space in
      if not length=0
      then
      (
        for i=0 to (length - 1) do
          draw_gr_item Menu.mn_items.(i)
                       {x=(xleft + 2*short_space); 
                        y=(ytop - i * text_height - 2*short_space)}
                       menu_width
        done
      )
;;


let std_draw_gr_menu Menu =
  let menu_width=(gr_menu_width Menu.mn_items) + 2*long_space
  and text_height = line_height + 3*short_space
  and length=vect_length Menu.mn_items in
    let xleft  =Menu.mn_left
    and ytop   =Menu.mn_top
    and width  =menu_width + 4*short_space
    and height  =length * text_height + 4*short_space in
      if not length=0
      then
      (
        if image_size Menu.mn_hide_area=(1, 1)
        then Menu.mn_hide_area <- get_image xleft (ytop-height-1) 
                                            (width+1) (height+2);
        set_color (backcolor ());
        fill_rect xleft (ytop-height) width height;
        draw_button xleft ytop width height Up;
        std_draw_menu_items Menu
      )
;;








let windows_draw_menu_items Menu =
  update_selected_item Menu;
  let menu_width=(gr_menu_width Menu.mn_items) + 2*long_space
  and text_height = line_height + 3*short_space
  and length=vect_length Menu.mn_items in
    let xleft  =Menu.mn_left
    and ytop   =Menu.mn_top
    and width  =menu_width + 4*short_space
    and height  =length * text_height + 4*short_space in
      if not length=0
      then
      (
        for i=0 to (length - 1) do
          draw_gr_item Menu.mn_items.(i)
                       {x=(xleft + 1); 
                        y=(ytop - i * text_height - 2*short_space)}
                       (width-2)
        done
      )
;;



let windows_draw_gr_menu Menu =
  let menu_width=(gr_menu_width Menu.mn_items) + 2*long_space
  and text_height = line_height + 3*short_space
  and length=vect_length Menu.mn_items in
    let xleft  =Menu.mn_left
    and ytop   =Menu.mn_top
    and width  =menu_width + 4*short_space
    and height  =length * text_height + 4*short_space in
      if not length=0
      then
      (
        if image_size Menu.mn_hide_area=(1, 1)
        then Menu.mn_hide_area <- get_image xleft (ytop-height-1) (width+1) (height+2);
        set_color white;
        fill_rect xleft (ytop-height) width height;
        set_color black;
        draw_rect xleft (ytop-height) width height;
        windows_draw_menu_items Menu
      )
;;






let next_draw_menu_items Menu =
  update_selected_item Menu;
  let menu_width=(gr_menu_width Menu.mn_items) + 2*short_space
  and text_height = line_height + 2*short_space + 1
  and length=vect_length Menu.mn_items in
    let xleft  = Menu.mn_left
    and ytop   = Menu.mn_top
    and width  = menu_width 
    and height  = length * text_height + 2 in
      if not length=0
      then
      (
        for i=0 to (length - 1) do
          draw_gr_item Menu.mn_items.(i)
                       {x=(xleft + 1); 
                        y=(ytop - i * text_height - 1)}
                       (width-2)
        done
      )
;;



let next_draw_gr_menu Menu =
  let menu_width= (gr_menu_width Menu.mn_items) + 2*short_space
  and text_height = line_height + 2*short_space + 1
  and length = vect_length Menu.mn_items 
  and imenu_width = (gr_menu_width Menu.mn_items) + 2*long_space
  and itext_height = line_height + 3*short_space in
    let xleft  = Menu.mn_left
    and ytop   = Menu.mn_top
    and width  = menu_width 
    and height = length * text_height + 2 
    and iheight = length * itext_height + 4*short_space in
      if not length=0
      then
      (
        if image_size Menu.mn_hide_area=(1, 1)
        then Menu.mn_hide_area <- get_image xleft (ytop-iheight-1) 
                                            (imenu_width+1) (iheight+2);
        set_color grey;
        fill_rect xleft (ytop-height) width height;
        set_color black;
        draw_rect xleft (ytop-height) width height;
        next_draw_menu_items Menu
      )
;;









let open_col_draw_menu_items Menu =
  update_selected_item Menu;
  let menu_width=(gr_menu_width Menu.mn_items) + 2*long_space
  and text_height = line_height + 3*short_space
  and length=vect_length Menu.mn_items in
    let xleft  =Menu.mn_left
    and ytop   =Menu.mn_top
    and width  =menu_width + 4*short_space
    and height  =length * text_height + 4*short_space in
      if not length=0
      then
      (
        for i=0 to (length - 1) do
          draw_gr_item Menu.mn_items.(i)
                       {x=(xleft + 2*short_space); 
                        y=(ytop - i * text_height - 2*short_space)}
                       menu_width
        done
      )
;;


let open_col_draw_gr_menu Menu =
  let menu_width=(gr_menu_width Menu.mn_items) + 2*long_space
  and text_height = line_height + 3*short_space
  and length=vect_length Menu.mn_items in
    let xleft  =Menu.mn_left
    and ytop   =Menu.mn_top
    and width  =menu_width + 4*short_space
    and height  =length * text_height + 4*short_space in
      if not length=0
      then
      (
        if image_size Menu.mn_hide_area=(1, 1)
        then Menu.mn_hide_area <- get_image xleft (ytop-height-1) 
                                            (width+1) (height+2);
        set_color (backcolor ());
        fill_rect xleft (ytop-height) width height;
        set_color black;
        std_col_draw_button xleft ytop width height Up;
        open_col_draw_menu_items Menu
      )
;;






let open_mono_draw_menu_items Menu =
  update_selected_item Menu;
  let menu_width=(gr_menu_width Menu.mn_items) + 2*long_space
  and text_height = line_height + 3*short_space
  and length=vect_length Menu.mn_items in
    let xleft  =Menu.mn_left
    and ytop   =Menu.mn_top
    and width  =menu_width + 4*short_space
    and height  =length * text_height + 4*short_space in
      if not length=0
      then
      (
        for i=0 to (length - 1) do
          draw_gr_item Menu.mn_items.(i)
                       {x=(xleft + 2*short_space); 
                        y=(ytop - i * text_height - 2*short_space)}
                       menu_width
        done
      )
;;




let open_mono_draw_gr_menu Menu =
  let menu_width=(gr_menu_width Menu.mn_items) + 2*long_space
  and text_height = line_height + 3*short_space
  and length=vect_length Menu.mn_items in
    let xleft  =Menu.mn_left
    and ytop   =Menu.mn_top
    and width  =menu_width + 4*short_space
    and height  =length * text_height + 4*short_space in
      if not length=0
      then
      (
        if image_size Menu.mn_hide_area=(1, 1)
        then Menu.mn_hide_area <- get_image xleft (ytop-height-1) 
                                            (width+3) (height+3);
        set_color (backcolor ());
        fill_rect xleft (ytop-height) width height;
        set_color black;
        draw_rect xleft (ytop-height) width height;
        moveto (xleft+2) (ytop-height-1);
        lineto (xleft+width+1) (ytop-height-1);
        lineto (xleft+width+1) (ytop-2);
        open_mono_draw_menu_items Menu
      )
;;




let draw_menu_items Menu =
  if Menu.mn_window.win_state=Created & Menu.mn_state=Visible
  then
  (
    set_draw_window Menu.mn_window.win_id;
    match (get_gr_look()) with
        Std_color       -> std_draw_menu_items Menu
      | Std_mono        -> std_draw_menu_items Menu
      | Open_look_color -> open_col_draw_menu_items Menu
      | Open_look_mono  -> open_mono_draw_menu_items Menu
      | Window_color    -> windows_draw_menu_items Menu
      | Next_color      -> next_draw_menu_items Menu
      | _               -> std_draw_menu_items Menu
  )
;;





let draw_gr_menu Menu =
  if Menu.mn_window.win_state=Created & Menu.mn_state=Visible
  then
  (
    set_draw_window Menu.mn_window.win_id;
    match (get_gr_look()) with
        Std_color       -> std_draw_gr_menu Menu
      | Std_mono        -> std_draw_gr_menu Menu
      | Open_look_color -> open_col_draw_gr_menu Menu
      | Open_look_mono  -> open_mono_draw_gr_menu Menu
      | Window_color    -> windows_draw_gr_menu Menu
      | Next_color      -> next_draw_gr_menu Menu
      | _               -> std_draw_gr_menu Menu
  )
;;






let erase_gr_menu Menu =
  get_move := false;
  set_draw_window Menu.mn_window.win_id;
  Menu.mn_state <- Unvisible;
  let menu_width=(gr_menu_width Menu.mn_items) + 2*long_space
  and text_height =line_height + 3*short_space in
    let xleft  =Menu.mn_left
    and ytop   =Menu.mn_top
    and height  =(vect_length Menu.mn_items) * text_height + 4*short_space in
      set_clip_area 0 0 (screen_width ()) (screen_height ());
      draw_image Menu.mn_hide_area xleft (ytop-height-1);
      Menu.mn_hide_area <- empty_image
;;




let which_item YMouse MenuTop NbItem=
  let text_height = match (get_gr_look()) with
                      Next_color -> line_height + 2*short_space + 1
                    | _          -> line_height + 3*short_space
  and delta =  match (get_gr_look()) with
                 Next_color -> 1
               | _          -> 2*short_space
  in
    min ((MenuTop - delta -YMouse) /text_height) NbItem
;;


let Button_alredy_released = ref false;;

let gr_open_menu Menu x y =
  Menu.mn_left <- x;
  Menu.mn_top  <- y;
  Menu.mn_state <- Visible;
  Menu.mn_nu_item <- 0;
  Button_alredy_released := false;
  get_move := true
;;



let gr_menu_callback Menu Event =
  let text_height = match (get_gr_look()) with
                      Next_color -> line_height + 2*short_space + 1
                    | _          -> line_height + 3*short_space
  and menu_width = (gr_menu_width Menu.mn_items) + 2*long_space
  and length = vect_length Menu.mn_items in
    let xleft  = Menu.mn_left
    and ytop   = Menu.mn_top
    and width  = menu_width + 4*short_space
    and height  = match (get_gr_look()) with
                    Next_color      -> length * text_height + 2
                  | _ -> length * text_height + 4*short_space
    and mouse_coord={x=Event.mouse_x; y=Event.mouse_y} in
      if (length=0 or Menu.mn_state=Unvisible)
      then false
      else
      (
        let Menu_area={x1=xleft;
                       y1=ytop - height;
                       x2=xleft + width;
                       y2=ytop} in
          match( inside mouse_coord Menu_area,
                 Event.id_event=Button_up,
                 Event.id_event=Button_down,
                 !Button_alredy_released,
                 Event.id_event=Mouse_motion
               ) with
            (false,false,false,_,_) -> (* mouse outside & undeal event *)
              false
          | (false,false,true,_,_)  -> (* mouse outside & button down *)
              erase_gr_menu Menu;
              Button_alredy_released := false;
              get_move := false;
              true
          | (false,true,false,false,_)  -> (* mouse outside & button up *)
              Button_alredy_released := true;
              get_move := false;
              true
          | (false,true,false,true,_)  -> (* mouse outside & button up *)
              erase_gr_menu Menu;
              Button_alredy_released := true;
              get_move := false;
              true
          | (false,true,true,_,_)   -> (* mouse outside & unpossible event *)
              false
          | (true,false,false,_,false)  -> (* mouse inside & undeal event *)
              false
          | (true,false,false,_,true)  -> (* mouse inside & undeal event *)
              let n=(length-1) in
                let nu_item=which_item Event.mouse_y
                                       Menu.mn_top
                                       n in
                  let select_item=Menu.mn_items.(nu_item) in
                        if not (select_item.it_state = Unselectable or
                           Menu.mn_nu_item = nu_item)
                        then
                        (
                          Menu.mn_nu_item <- nu_item;
(*                          draw_menu_items Menu *)
                          draw_gr_menu Menu
                        );
              true
          | (true,false,true,_,_)   -> (* mouse inside & button down *)
              let n=(length-1) in
                let nu_item=which_item Event.mouse_y
                                       Menu.mn_top
                                       n in
                  let select_item=Menu.mn_items.(nu_item) in
                        if not (select_item.it_state = Unselectable or
                               Menu.mn_nu_item = nu_item)
                        then
                        (
                          Menu.mn_nu_item <- nu_item;
(*                          draw_menu_items Menu *)
                          draw_gr_menu Menu
                        );
              true

          | (true,true,false,_,_)   -> (* mouse inside & button up *)
              let n=(length-1) in
                let nu_item=which_item Event.mouse_y
                                       Menu.mn_top
                                       n in
                  let select_item=Menu.mn_items.(nu_item) in
                        if not select_item.it_state=Unselectable
                        then
                        (
                          erase_gr_menu Menu;
                          select_item.it_callback select_item Event;
                          ()
                        )
                        else erase_gr_menu Menu;
              true
          | _   -> false
      )
;;




