#open "windows";;
#open "camlwin";;

#open "g_global";;
#open "g_menu";;
#open "g_item";;
#open "g_toolb";;
#open "g_mloop";;





let item1_callback Graph_obj Event=
  set_gr_look (Std_color);
  redraw_all ();
  true;;

let item1_look =  {
               it_window=std_win;
               it_state=Unselected;
               it_name="Caml color";
               it_callback= item1_callback
              };;


let item2_callback Graph_obj Event=
  set_gr_look (Std_mono);
  redraw_all ();
  true;;

let item2_look =  {
               it_window=std_win;
               it_state=Unselected;
               it_name="Caml mono";
               it_callback= item2_callback
              };;


let item3_callback Graph_obj Event=
  set_gr_look (Open_look_color);
  redraw_all ();
  true;;

let item3_look =  {
               it_window=std_win;
               it_state=Unselected;
               it_name="Open look color";
               it_callback= item3_callback
              };;

let item4_callback Graph_obj Event=
  set_gr_look (Open_look_mono);
  redraw_all ();
  true;;

let item4_look =  {
               it_window=std_win;
               it_state=Unselected;
               it_name="Open look mono";
               it_callback= item4_callback
              };;


let item5_callback Graph_obj Event=
  set_gr_look (Window_color);
  redraw_all ();
  true;;

let item5_look =  {
               it_window=std_win;
               it_state=Unselected;
               it_name="Windows";
               it_callback= item5_callback
              };;


let item6_callback Graph_obj Event=
  set_gr_look (Motif_color);
  redraw_all ();
  true;;

let item6_look =  {
               it_window=std_win;
               it_state=Unselected;
               it_name="Motif";
               it_callback= item6_callback
              };;


let item7_callback Graph_obj Event=
  set_gr_look (Next_color);
  redraw_all ();
  true;;

let item7_look =  {
               it_window=std_win;
               it_state=Unselected;
               it_name="Next Step";
               it_callback= item7_callback
              };;



let menu_look =   {
               mn_window=std_win;
               mn_left=0;
               mn_top=0;
               mn_state=Unvisible;
               mn_nu_item=0;
               mn_name="Look";
               mn_items=[|item1_look; item2_look; item3_look;
                          item4_look; item5_look; item6_look;
                          item7_look
                        |];
               mn_hide_area=empty_image
              };;



let make_menu_look Win =
  let ret_menu = {
                  mn_window=Win;
                  mn_left=0;
                  mn_top=0;
                  mn_state=Unvisible;
                  mn_nu_item=0;
                  mn_name="Look";
                  mn_items=[| |];
                  mn_hide_area=empty_image
                 } in
  let n=vect_length menu_look.mn_items in
    for i=0 to (n-1) do
    (
      let item={
                it_window=Win;
                it_state=Unselected;
                it_name=menu_look.mn_items.(i).it_name;
                it_callback= menu_look.mn_items.(i).it_callback
               } in
        ret_menu.mn_items <- concat_vect ret_menu.mn_items [| item |]
    )
    done;
  ret_menu
;;

