#open "sort";;

#open "windows";;
#open "camlwin";;

#open "g_global";;
#open "g_button";;
#open "g_scroll";;





let std_draw_gr_list List =
  let left = to_real_coord List.li_left
  and top  = to_real_coord List.li_top
  and width= to_real_coord List.li_width
  and height=to_real_coord List.li_height in

  let nb_items=(vect_length List.li_items)
  and scroll_length=(height - 2*short_space) in
    List.li_nu_item <- (min List.li_nu_item (nb_items-1));
    List.li_nu_item <- (max 0 List.li_nu_item);
    List.li_1st_item <- (min List.li_1st_item (nb_items-1));
    List.li_1st_item <- (max 0 List.li_1st_item);

    let dx=(scroll_width + 2*short_space)
    and dy=(line_height+ short_space) in
      let nb_display=(scroll_length / dy) in
        draw_button left top width height Down;
        draw_vscrollbar (left+short_space) (top-short_space)
                        scroll_length List.li_scroll;
        set_color white;
        fill_rect (left+dx)
                  (top - height + short_space)
                  (width - dx -short_space)
                  (height - 2*short_space);
        set_clip_area (left+dx)
                      (top - height + short_space)
                      (width - dx -short_space)
                      (height - 2*short_space);
        set_color black;
        let nu_screen=(List.li_nu_item - List.li_1st_item) in
          let y=(top - 2*short_space - (nu_screen + 1) * dy ) in
            draw_rect (left+dx)
                      y
                      (width - dx - short_space - 1)
                      (dy + short_space - 1);
            let nb_line=(min (nb_display + 1)
                             (nb_items - 1 - List.li_1st_item)) in
              for i=0 to nb_line do
              (
                moveto (left+dx+short_space)
                       (top - (i+1) * dy - short_space - 1);
                draw_string List.li_items.(i + List.li_1st_item)
              )
              done;
              set_clip_area 0 0 (screen_width ()) (screen_height ())
;;


let open_col_draw_gr_list List =
  let left = to_real_coord List.li_left
  and top  = to_real_coord List.li_top
  and width= to_real_coord List.li_width
  and height=to_real_coord List.li_height in

  let nb_items=vect_length List.li_items
  and scroll_length=height in
    List.li_nu_item <- min List.li_nu_item (nb_items-1);
    List.li_nu_item <- max 0 List.li_nu_item;
    List.li_1st_item <- min List.li_1st_item (nb_items-1);
    List.li_1st_item <- max 0 List.li_1st_item;

    let dx=scroll_width + 2*short_space
    and dy=line_height+ short_space in
      let nb_display=(scroll_length / dy) in
        draw_vscrollbar (left+short_space) top scroll_length
                        List.li_scroll;
        set_color (backcolor ());
        fill_rect (left+dx)
                  (top - height)
                  (width-dx-2*short_space)
                  height;
        std_col_draw_button (left+dx) top
                            (width-dx-2*short_space) height Up;
        set_clip_area (left+dx)
                      (top - height + short_space)
                      (width - dx -short_space)
                       (height - 2*short_space);
        set_color black;
        let nu_screen=(List.li_nu_item - List.li_1st_item) in
          let y=(top - 2*short_space - (nu_screen + 1) * dy ) in
            set_color darkgrey;
            fill_rect (left+dx+short_space)
                      (y-2)
                      (width - dx - 4*short_space - 1)
                      (dy + short_space - 1);
            std_col_draw_button (left+dx+short_space) (y+dy+short_space-2)
                                (width-dx-4*short_space-1) (dy+short_space-1)
                                Down;
            set_clip_area (left+dx+short_space)
                          (top - height + short_space-2)
                          (width - dx -4*short_space-1)
                          (height - 2*short_space);
            let nb_line=(min (nb_display + 1)
                             (nb_items - 1 - List.li_1st_item)) in
              for i=0 to nb_line do
              (
                moveto (left+dx+2*short_space)
                       (top - (i+1) * dy - short_space - 1);
                draw_string List.li_items.(i + List.li_1st_item)
              )
              done;
              set_clip_area 0 0 (screen_width ()) (screen_height ())
;;



let open_mono_draw_gr_list List =
  let left = to_real_coord List.li_left
  and top  = to_real_coord List.li_top
  and width= to_real_coord List.li_width
  and height=to_real_coord List.li_height in

  let nb_items=vect_length List.li_items
  and scroll_length=height - 2*short_space in
    List.li_nu_item <- min List.li_nu_item (nb_items-1);
    List.li_nu_item <- max 0 List.li_nu_item;
    List.li_1st_item <- min List.li_1st_item (nb_items-1);
    List.li_1st_item <- max 0 List.li_1st_item;

    let dx=scroll_width + 2*short_space
    and dy=line_height+ short_space in
      let nb_display=(scroll_length / dy) in
        draw_vscrollbar (left+short_space) (top-short_space) scroll_length
                        List.li_scroll;
        set_color white;
        fill_rect (left+dx)
                      (top - height + short_space)
                      (width - dx -short_space)
                      (height - 2*short_space);
        set_color black;
        draw_rect (left+dx)
                      (top - height + short_space)
                      (width - dx -short_space)
                      (height - 2*short_space);

        set_clip_area (left+dx)
                      (top - height + short_space)
                      (width - dx -short_space)
                       (height - 2*short_space);
        set_color black;
        let nu_screen=(List.li_nu_item - List.li_1st_item) in
          let y=(top - 2*short_space - (nu_screen + 1) * dy ) in
            draw_rect (left+dx)
                      y
                      (width - dx - short_space - 1)
                      (dy + short_space - 1);
            set_clip_area (left+dx+short_space)
                          (top - height + short_space-2)
                          (width - dx -4*short_space-1)
                          (height - 2*short_space);
            let nb_line=(min (nb_display + 1)
                             (nb_items - 1 - List.li_1st_item)) in
              for i=0 to nb_line do
              (
                moveto (left+dx+short_space)
                       (top - (i+1) * dy - short_space - 1);
                draw_string List.li_items.(i + List.li_1st_item)
              )
              done;
              set_clip_area 0 0 (screen_width ()) (screen_height ())
;;


let motif_draw_gr_list List =
  let left = to_real_coord List.li_left
  and top  = to_real_coord List.li_top
  and width= to_real_coord List.li_width
  and height=to_real_coord List.li_height in

  let nb_items=(vect_length List.li_items)
  and scroll_length=(height - 2*short_space) in
    List.li_nu_item <- (min List.li_nu_item (nb_items-1));
    List.li_nu_item <- (max 0 List.li_nu_item);
    List.li_1st_item <- (min List.li_1st_item (nb_items-1));
    List.li_1st_item <- (max 0 List.li_1st_item);

    let dx=(scroll_width + 2*short_space)
    and dy=(line_height+ short_space) in
      let nb_display=(scroll_length / dy) in
        draw_button left top width height Down;
        draw_vscrollbar (left+short_space) (top-short_space)
                        scroll_length List.li_scroll;
        set_clip_area (left+dx)
                      (top - height + short_space)
                      (width - dx -short_space)
                      (height - 2*short_space);
        set_color white;
        let nu_screen=(List.li_nu_item - List.li_1st_item) in
          let y=(top - 2*short_space - (nu_screen + 1) * dy ) in
            let nb_line=(min (nb_display + 1)
                             (nb_items - 1 - List.li_1st_item)) in
              for i=0 to nb_line do
              (
                moveto (left+dx+short_space)
                       (top - (i+1) * dy - short_space - 1);
                draw_string List.li_items.(i + List.li_1st_item)
              )
              done;
            set_color white;
            if nb_items > 0 
            then
            (
              fill_rect (left+dx)
                        y
                        (width - dx - short_space - 1)
                        (dy + short_space - 1);
              set_color black;
              moveto (left+dx+short_space)
                     (top - (nu_screen+1) * dy - short_space - 1);
              draw_string List.li_items.(List.li_nu_item)
           );
   set_clip_area 0 0 (screen_width ()) (screen_height ())
;;


let next_draw_gr_list List =
  let left = to_real_coord List.li_left
  and top  = to_real_coord List.li_top
  and width= to_real_coord List.li_width
  and height=to_real_coord List.li_height in

  let nb_items=(vect_length List.li_items)
  and scroll_length=(height - 2*short_space) in
    List.li_nu_item <- (min List.li_nu_item (nb_items-1));
    List.li_nu_item <- (max 0 List.li_nu_item);
    List.li_1st_item <- (min List.li_1st_item (nb_items-1));
    List.li_1st_item <- (max 0 List.li_1st_item);

    let dx=(scroll_width + 2*short_space)
    and dy=(line_height+ short_space) in
      let nb_display=(scroll_length / dy) in
        set_color black;
        draw_rect left (top-height) width height;
        draw_vscrollbar (left+short_space) (top-short_space)
                        scroll_length List.li_scroll;
        set_color (backcolor ());
        fill_rect (left+dx)
                  (top - height + short_space)
                  (width - dx -short_space)
                  (height - 2*short_space);
        set_clip_area (left+dx)
                      (top - height + short_space)
                      (width - dx -short_space)
                      (height - 2*short_space);
        set_color white;
        let nu_screen=(List.li_nu_item - List.li_1st_item) in
          let y=(top - 2*short_space - (nu_screen + 1) * dy ) in
            fill_rect (left+dx)
                      y
                      (width - dx - short_space - 1)
                      (dy + short_space - 1);
            set_color black;
            let nb_line=(min (nb_display + 1)
                             (nb_items - 1 - List.li_1st_item)) in
              for i=0 to nb_line do
              (
                moveto (left+dx+short_space)
                       (top - (i+1) * dy - short_space - 1);
                draw_string List.li_items.(i + List.li_1st_item)
              )
              done;
              set_clip_area 0 0 (screen_width ()) (screen_height ())
;;






let draw_gr_list List =
  if List.li_window.win_state=Created
  then
  (
    set_draw_window List.li_window.win_id;
    match (get_gr_look()) with
        Std_color       -> std_draw_gr_list List
      | Std_mono        -> std_draw_gr_list List
      | Open_look_color -> open_col_draw_gr_list List
      | Open_look_mono  -> open_mono_draw_gr_list List
      | Motif_color     -> motif_draw_gr_list List
      | Next_color      -> next_draw_gr_list List
      | _               -> std_draw_gr_list List
  )
;;







let gr_list_selected List y =
  let top  = to_real_coord List.li_top in

    let dy=(line_height+ short_space) in
      let n=(max 0 ((top - 2*short_space - y) / dy)) in
       List.li_1st_item + n
;;





let gr_list_callback List Event =
  let left = to_real_coord List.li_left
  and top  = to_real_coord List.li_top
  and width= to_real_coord List.li_width
  and height=to_real_coord List.li_height in

  let nb_items=(vect_length List.li_items)
  and scroll_length=(height - 2*short_space) in
    let dy=(line_height+ short_space) in
      let nb_display=(scroll_length / dy) in
        let scroll_delta=nb_display*(scroll_course scroll_length) /
                           (max 1 (nb_items - 1)) in
        let scrollbar={
                       sb_window=List.li_window;
                       sb_left=(left + short_space);
                       sb_top=(top - short_space);
                       sb_length=scroll_length;
                       sb_pos=List.li_scroll;
                       sb_dir=Vertical;
                       sb_delta=scroll_delta;
                       sb_callback= do_nothing
                       } in

        if (gr_vscrollbar_callback scrollbar Event)
        then
        (
          List.li_scroll <- scrollbar.sb_pos;
          List.li_1st_item <- ((scrollbar.sb_pos * (nb_items - nb_display)) /
                               (scroll_course scroll_length));
          draw_gr_list List;
          true
        )
        else
        (
          if Event.id_event=Button_up
          then
          (
            let mouse_coord={x=Event.mouse_x; y=Event.mouse_y}
            and List_area={x1=left+scroll_width + 2*short_space;
                           y1=top-height;
                           x2=left+width;
                           y2=top} in
              if inside mouse_coord List_area & not nb_items = 0
              then
              (
                List.li_nu_item <- gr_list_selected List Event.mouse_y;
                draw_gr_list List;
                List.li_callback List Event;
                true
              )
              else false
          )
          else false
        )
;;


let add_item List Item Pos =
  let len=(vect_length List.li_items)
  and postemp=(max 0 Pos) in
    let pos=(min postemp len) in
      if len=0
      then
      (
        List.li_items <- [| Item |];
        List.li_nu_item <- 0
      )
      else
      (
        let b=sub_vect List.li_items 0 pos
        and e=sub_vect List.li_items pos (len-pos) in
          List.li_items <- concat_vect b (concat_vect [| Item |] e);
          List.li_nu_item <- pos
      )
;;


let del_item List Pos =
  let len=(vect_length List.li_items)
  and postemp=(max 0 Pos) in
    let pos=(min postemp (len-1)) in
      if not len=0
      then
      (
        let b=sub_vect List.li_items 0 pos
        and e=sub_vect List.li_items (pos+1) (len-pos-1) in
          List.li_items <- concat_vect b e;
          List.li_nu_item <- pos
      )
;;



let list_sort List =
  List.li_items <-
    (vect_of_list (sort lt_string (list_of_vect List.li_items)));;



let save_gr_list List Channel =
  save_lines Channel List.li_items;;

let load_gr_list List Channel =
  List.li_items <- load_lines Channel;
  List.li_nu_item <- 0;
  List.li_1st_item <- 0;
  List.li_scroll <- 0
;;

