#open "windows";;
#open "camlwin";;

#open "g_global";;
#open "g_button";;




let std_draw_gr_item Item Coord Width =
  let Button_state =match Item.it_state with
                      Selected     -> Down
                    | Unselected   -> Up
                    | Unselectable -> Unused  in
    draw_button Coord.x Coord.y
                Width (line_height + 2*short_space) Button_state;
    moveto (Coord.x+short_space) (Coord.y-line_height-short_space);
    set_color black;
    draw_string Item.it_name
;;


let windows_draw_gr_item Item Coord Width =
  (
    match Item.it_state with
      Selected     -> set_color winblue;
                      let height  = (line_height + 2*short_space) in
                        fill_rect Coord.x (Coord.y-height)
                                  Width height;
                      set_color white
    | Unselected   -> set_color black
    | Unselectable -> set_color darkgrey
  );
    moveto (Coord.x+short_space) (Coord.y-line_height-short_space);
    draw_string Item.it_name
;;


let open_col_draw_gr_item Item Coord Width =
  if Item.it_state=Selected 
  then draw_button Coord.x Coord.y Width 
                   (line_height+2*short_space) Unused;
    set_color black;
    moveto (Coord.x+short_space) (Coord.y-line_height-short_space);
    draw_string Item.it_name
;;

let open_mono_draw_gr_item Item Coord Width =
  (
    match Item.it_state with
      Selected     ->
        let delta = 5
        and height = line_height+2*short_space in
          let x1= Coord.x+delta
          and y1= Coord.y-delta
          and x2= Coord.x+Width-delta
          and y2= Coord.y-delta
          and x3= Coord.x+delta
          and y3= Coord.y-height+delta
          and x4= Coord.x+Width-delta
          and y4= Coord.y-height+delta in
            set_color black;
            fill_arc x3 y3 delta delta 180 270;
            fill_arc x4 y4 delta delta 270 360;
            fill_arc x2 y2 delta delta 0 90;
            fill_arc x1 y1 delta delta 90 180;
            fill_rect (x3-delta) (y3+1) (x2-x3+2*delta+1) (y2-y3);
            fill_rect x1 (y3-delta) (x2-x3) (y2-y3+2*delta+1);
            set_color white
    | Unselected   ->
        set_color black
    | Unselectable ->
        set_color black
  );
  moveto (Coord.x+short_space) (Coord.y-line_height-short_space);
  draw_string Item.it_name
;;

let motif_draw_gr_item Item Coord Width =
  if Item.it_state = Selected
  then draw_button Coord.x Coord.y
                Width (line_height + 2*short_space) Up;
  

    moveto (Coord.x+short_space) (Coord.y-line_height-short_space);
    if Item.it_state = Unselectable 
    then set_color grey
    else set_color black;
    draw_string Item.it_name
;;








let draw_gr_item Item Coord Width =
  match (get_gr_look()) with
      Open_look_color -> open_col_draw_gr_item Item Coord Width
    | Open_look_mono  -> open_mono_draw_gr_item Item Coord Width
    | Window_color    -> windows_draw_gr_item Item Coord Width
    | Motif_color     -> motif_draw_gr_item Item Coord Width
    | _               -> std_draw_gr_item Item Coord Width
;;



let gr_item_callback Item Event =
   true ;;

