#open "sys";;
#open "windows";;
#open "camlwin";;

#open "g_global";;
#open "g_button";;
#open "g_string";;
#open "g_prompt";;
#open "g_mloop";;





let gr_input_height = 40;;
let gr_input_width = 100;;


let gr_input_window_def =
{
  win_id = undef_window;
  win_top = (screen_height() + (to_real_coord gr_input_height))/2;
  win_left = (screen_width() - (to_real_coord gr_input_width))/2;
  win_width = gr_input_width;
  win_height = gr_input_height;
  win_name = "Input Value"; 
  win_state = Destroyed
};;

let gr_input_OK =
{
  bt_window=gr_input_window_def;
  bt_left=((gr_input_width-25)/2);
  bt_top=20;
  bt_width=25;
  bt_height=15;
  bt_name=string_type "Ok";
  bt_state=Up;
  bt_callback= do_nothing
};;

let gr_input_text =
{
  st_window=gr_input_window_def;
  st_left= 5;
  st_top=30;
  st_width=90;
  st_cursor=0;
  st_1st_char=0;
  st_name="";
  st_type=Gr_string;
  st_state=Edited;
  st_callback= do_nothing
};;

let gr_input_prompt=
{
  pt_window=gr_input_window_def;
  pt_left=5;
  pt_top=37;
  pt_name="Name:"
};;

let gr_input_window =
{
  win_def=gr_input_window_def;
  win_objects=[ g_button gr_input_OK;
                g_string gr_input_text;
                g_prompt gr_input_prompt
              ];
  time_callback = do_nothing;
  resize_callback = do_nothing;
  help_file = "";
  miscellaneous = [| |]
};;




let rec gr_close_input Obj_graph Event =
  erase_window gr_input_window.win_def
;;

gr_input_OK.bt_callback <- gr_close_input;;
gr_input_text.st_callback <- gr_close_input;;


(***************************************************************************)
(*                                                                         *)
(* gr_input_string: string -> string -> string;;                           *)
(*                                                                         *)
(***************************************************************************)
let input_string Prompt Name =
  gr_input_prompt.pt_name <- Prompt;
  gr_input_text.st_state <- Edited;
  gr_input_text.st_type <- Gr_string;
  gr_input_text.st_name <- Name;
  gr_input_text.st_1st_char <- 0;
  gr_input_text.st_cursor <- 0;

  block_loop gr_input_window;
  gr_input_text.st_name
;;


(***************************************************************************)
(*                                                                         *)
(* gr_input_natural: string -> int -> int;;                                *)
(*                                                                         *)
(***************************************************************************)
let input_natural Prompt n =
  gr_input_prompt.pt_name <- Prompt;
  gr_input_text.st_state <- Edited;
  gr_input_text.st_type <- Gr_natural;
  gr_input_text.st_name <- (string_of_int n);
  gr_input_text.st_1st_char <- 0;
  gr_input_text.st_cursor <- 0;

  block_loop gr_input_window;
  int_of_string gr_input_text.st_name
;;


(***************************************************************************)
(*                                                                         *)
(* gr_input_int: string -> int -> int;;                                    *)
(*                                                                         *)
(***************************************************************************)
let input_int Prompt n =
  gr_input_prompt.pt_name <- Prompt;
  gr_input_text.st_state <- Edited;
  gr_input_text.st_type <- Gr_int;
  gr_input_text.st_name <- (string_of_int n);
  gr_input_text.st_1st_char <- 0;
  gr_input_text.st_cursor <- 0;

  block_loop gr_input_window;
  int_of_string gr_input_text.st_name
;;


(***************************************************************************)
(*                                                                         *)
(* gr_input_hexa: string -> int -> int;;                                   *)
(*                                                                         *)
(***************************************************************************)
let input_hexa Prompt n =
  gr_input_prompt.pt_name <- Prompt;
  gr_input_text.st_state <- Edited;
  gr_input_text.st_type <- Gr_int;
  gr_input_text.st_name <- (string_of_int n);
  gr_input_text.st_1st_char <- 0;
  gr_input_text.st_cursor <- 0;

  block_loop gr_input_window;
  int_of_string gr_input_text.st_name
;;


(***************************************************************************)
(*                                                                         *)
(* gr_input_float: string -> float -> float;;                              *)
(*                                                                         *)
(***************************************************************************)
let input_float Prompt n =
  gr_input_prompt.pt_name <- Prompt;
  gr_input_text.st_state <- Edited;
  gr_input_text.st_type <- Gr_float;
  gr_input_text.st_name <- (string_of_float n);
  gr_input_text.st_1st_char <- 0;
  gr_input_text.st_cursor <- 0;

  block_loop gr_input_window;
  float_of_string gr_input_text.st_name
;;


(***************************************************************************)
(*                                                                         *)
(* gr_input_password: string -> string -> string;;                         *)
(*                                                                         *)
(***************************************************************************)
let input_password Prompt Name =
  gr_input_prompt.pt_name <- Prompt;
  gr_input_text.st_state <- Edited;
  gr_input_text.st_type <- Gr_password;
  gr_input_text.st_name <- Name;
  gr_input_text.st_1st_char <- 0;
  gr_input_text.st_cursor <- 0;

  block_loop gr_input_window;
  gr_input_text.st_name
;;



(***************************************************************************)
(*                                                                         *)
(* gr_input_filename: string -> string -> string;;                         *)
(*                                                                         *)
(***************************************************************************)
let input_filename Prompt Name =
  let valid=ref false in
  while not !valid do
  (
    gr_input_prompt.pt_name <- Prompt;
    gr_input_text.st_state <- Edited;
    gr_input_text.st_type <- Gr_string;
    gr_input_text.st_name <- Name;
    gr_input_text.st_1st_char <- 0;
    gr_input_text.st_cursor <- 0;

    block_loop gr_input_window;
    try
    (
      let file=open_out gr_input_text.st_name in
        close_out file;
        valid := true;
        remove gr_input_text.st_name
    )
    with Sys_error _ -> valid := false
  )
  done;
  gr_input_text.st_name
;;

