#open "windows";;
#open "camlwin";;






(****************************************************************************)
(*                                                                          *)
(*    html_save : HTML_type list -> out_channel -> unit                     *)
(*                                                                          *)
(****************************************************************************)
let html_save Html_ml Channel=
  let rec save_html_loop Html_ml indent = 
    match Html_ml with
      []   -> ()
    | a::b ->( match a with
                   HtmlText str -> 
                      output_string Channel str;
                      save_html_loop b indent 

                 | ANCHOR Anchor ->
                      output_string Channel ("<A " ^ 
                                              (match Anchor.AnchorType with
                                                 HREF-> "HREF"
                                               | _   -> "NAME"
                                              ) ^
                                             " = \"" ^ Anchor.AnchorFile ^
                                             "\">" ^ Anchor.AnchorName ^
                                             "</A>");
                      save_html_loop b indent

                 | LineBreak ->
                      output_string Channel "<P>\n";
                      output_string Channel indent;
                      save_html_loop b indent 

                 | STRONG HtmlList ->
                      output_string Channel "<STRONG>";
                      save_html_loop HtmlList indent;
                      output_string Channel "</STRONG>";
                      save_html_loop b indent

                 | Ignore str -> save_html_loop b indent

                 | H1 HtmlList -> 
                      output_string Channel "\n\n<H1>";
                      save_html_loop HtmlList indent;
                      output_string Channel "</H1>\n";
                      save_html_loop b ""

                 | H2 HtmlList -> 
                      output_string Channel "\n\n<H2>";
                      save_html_loop HtmlList indent;
                      output_string Channel "</H2>\n";
                      save_html_loop b ""

                 | H3 HtmlList -> 
                      output_string Channel "\n\n<H3>";
                      save_html_loop HtmlList indent;
                      output_string Channel "</H3>\n";
                      save_html_loop b ""

                 | H4 HtmlList -> 
                      output_string Channel "\n\n<H4>";
                      save_html_loop HtmlList indent;
                      output_string Channel "</H4>\n";
                      save_html_loop b ""

                 | H5 HtmlList -> 
                      output_string Channel "\n\n<H5>";
                      save_html_loop HtmlList indent;
                      output_string Channel "</H5>\n";
                      save_html_loop b ""

                 | H6 HtmlList -> 
                      output_string Channel "\n\n<H6>";
                      save_html_loop HtmlList indent;
                      output_string Channel "</H6>\n";
                      save_html_loop b ""

                 | UList HtmlList -> 
                      output_string Channel ("\n"^indent);
                      output_string Channel "<UL>\n";
                      save_html_loop HtmlList (indent^"  ");
                      output_string Channel ("\n" ^ indent ^ "</UL>\n");
                      save_html_loop b indent

                 | OList HtmlList -> 
                      output_string Channel ("\n"^indent);
                      output_string Channel "<OL>\n";
                      save_html_loop HtmlList (indent^"  ");
                      output_string Channel ("\n" ^ indent ^ "</OL>\n");
                      save_html_loop b indent

                 | HLine    -> 
                      output_string Channel ("\n<HR>\n");
                      save_html_loop b ""

                 | PRE HtmlList ->
                      output_string Channel ("\n<PRE>\n");
                      save_html_loop HtmlList "";
                      output_string Channel ("\n</PRE>\n");
                      save_html_loop b ""

                 | BLOCKQUOTE HtmlList -> 
                      output_string Channel ("\n<BLOCKQUOTE>\n");
                      save_html_loop HtmlList "  ";
                      output_string Channel ("\n</BLOCKQUOTE>\n");
                      save_html_loop b ""

                 | CITE HtmlList -> 
                      output_string Channel ("<CITE>");
                      save_html_loop HtmlList indent;
                      output_string Channel ("</CITE>");
                      save_html_loop b indent

                 | KBD HtmlList -> 
                      output_string Channel ("<KBD>");
                      save_html_loop HtmlList indent;
                      output_string Channel ("</KBD>");
                      save_html_loop b indent

                 | CODE HtmlList ->
                      output_string Channel ("<CODE>");
                      save_html_loop HtmlList indent;
                      output_string Channel ("</CODE>");
                      save_html_loop b indent
       
                 | DFN HtmlList ->
                      output_string Channel ("<DFN>");
                      save_html_loop HtmlList indent;
                      output_string Channel ("</DFN>");
                      save_html_loop b indent

                 | EM HtmlList ->
                      output_string Channel ("<EM>");
                      save_html_loop HtmlList indent;
                      output_string Channel ("</EM>");
                      save_html_loop b indent

                 | VAR HtmlList ->
                      output_string Channel ("<VAR>");
                      save_html_loop HtmlList indent;
                      output_string Channel ("</VAR>");
                      save_html_loop b indent

                 | ADDRESS HtmlList ->
                      output_string Channel ("\n<ADDRESS>\n");
                      save_html_loop HtmlList indent;
                      output_string Channel ("\n</ADDRESS>\n");
                      save_html_loop b indent

                 | SAMP HtmlList ->
                      output_string Channel ("<SAMP>");
                      save_html_loop HtmlList indent;
                      output_string Channel ("</SAMP>");
                      save_html_loop b indent

                 | DList HtmlList ->
                      output_string Channel ("\n<DL>");
                      save_html_loop HtmlList "";
                      output_string Channel ("\n</DL>\n");
                      save_html_loop b ""

                 | DT HtmlList ->
                      output_string Channel ("\n<DT>");
                      save_html_loop HtmlList "  ";
                      save_html_loop b ""

                 | DD HtmlList ->
                      output_string Channel ("\n  <DD>");
                      save_html_loop HtmlList "    ";
                      save_html_loop b ""

                 | LI HtmlList ->
                      output_string Channel ("\n" ^ indent ^ "<LI>");
                      save_html_loop HtmlList indent;
                      save_html_loop b indent

                 | BOLD HtmlList  ->
                      output_string Channel ("<B>");
                      save_html_loop HtmlList indent;
                      output_string Channel ("</B>");
                      save_html_loop b indent

                 | ITALIC HtmlList ->
                      output_string Channel ("<I>");
                      save_html_loop HtmlList indent;
                      output_string Channel ("</I>");
                      save_html_loop b indent

                 | TT   HtmlList ->
                      output_string Channel ("<TT>");
                      save_html_loop HtmlList indent;
                      output_string Channel ("</TT>");
                      save_html_loop b indent

                 | IMG  img  -> 
                      output_string Channel ("<IMG SRC=\"" ^ 
                                               img.ImageFile ^ "\"");
                      if not img.ImageAlt = ""
                      then output_string Channel (" ALT=\"" ^ 
                                               img.ImageAlt ^ "\"");
                      output_string Channel (" ALIGN=" ^ 
                                              (match img.ImageAlign with
                                                 AlignTop -> "TOP"
                                               | AlignMiddle -> "MIDDLE"
                                               | AlignBottom -> "BOTTOM"
                                              ) ^
                                             ">");
                      save_html_loop b indent 

	  )
    in
      save_html_loop Html_ml ""
;;






(****************************************************************************)
(*                                                                          *)
(*    save_HTML_type_list : string -> HTML_type list -> out_channel -> unit *)
(*                                                                          *)
(****************************************************************************)
let save_HTML_type_list Name Html_ml Channel=
  let rec save_html_loop Html_ml indent begin_lst = 
    match Html_ml with
      []   -> output_string Channel "]\n"
    | a::b ->( match a with
                   HtmlText str -> 
                      if not begin_lst then output_string Channel ";";
                      output_string Channel (" HtmlText \"" ^ 
                          (string_for_read str) ^ "\"");
                      save_html_loop b indent false

                 | ANCHOR Anchor ->
                      if not begin_lst then output_string Channel ";";
                      output_string Channel (" ANCHOR { AnchorType = " ^ 
                                              (match Anchor.AnchorType with
                                                 HREF-> "HREF"
                                               | _   -> "NAME"
                                              ) ^
                                             "; AnchorFile = \"" ^ 
                                             Anchor.AnchorFile ^
                                             "\"; AnchorName = \"" ^ 
                                             Anchor.AnchorName ^
                                             "\" }");
                      save_html_loop b indent false

                 | LineBreak ->
                      if not begin_lst then output_string Channel ";";
                      output_string Channel " LineBreak\n";
                      output_string Channel indent;
                      save_html_loop b indent false

                 | STRONG HtmlList ->
                      if not begin_lst then output_string Channel ";";
                      output_string Channel " STRONG [";
                      save_html_loop HtmlList indent true;
                      save_html_loop b indent false

                 | Ignore str -> save_html_loop b indent begin_lst

                 | H1 HtmlList -> 
                      if not begin_lst then output_string Channel ";";
                      output_string Channel "\nH1 [";
                      save_html_loop HtmlList indent true;
                      output_string Channel "\n";
                      save_html_loop b "" false

                 | H2 HtmlList -> 
                      if not begin_lst then output_string Channel ";";
                      output_string Channel "\nH2 [";
                      save_html_loop HtmlList indent true;
                      output_string Channel "\n";
                      save_html_loop b "" false

                 | H3 HtmlList -> 
                      if not begin_lst then output_string Channel ";";
                      output_string Channel "\nH3 [";
                      save_html_loop HtmlList indent true;
                      output_string Channel "\n";
                      save_html_loop b "" false

                 | H4 HtmlList -> 
                      if not begin_lst then output_string Channel ";";
                      output_string Channel "\nH4 [";
                      save_html_loop HtmlList indent true;
                      output_string Channel "\n";
                      save_html_loop b "" false

                 | H5 HtmlList -> 
                      if not begin_lst then output_string Channel ";";
                      output_string Channel "\nH5 [";
                      save_html_loop HtmlList indent true;
                      output_string Channel "\n";
                      save_html_loop b "" false

                 | H6 HtmlList -> 
                      if not begin_lst then output_string Channel ";";
                      output_string Channel "\nH6 [";
                      save_html_loop HtmlList indent true;
                      output_string Channel "\n";
                      save_html_loop b "" false

                 | UList HtmlList -> 
                      if not begin_lst then output_string Channel ";";
                      output_string Channel ("\n"^indent);
                      output_string Channel "UList [\n";
                      save_html_loop HtmlList indent true;
                      output_string Channel "\n";
                      save_html_loop b indent false

                 | OList HtmlList -> 
                      if not begin_lst then output_string Channel ";";
                      output_string Channel ("\n"^indent);
                      output_string Channel "OList [\n";
                      save_html_loop HtmlList indent true;
                      output_string Channel "\n";
                      save_html_loop b indent false

                 | HLine    -> 
                      if not begin_lst then output_string Channel ";";
                      output_string Channel ("\nHLine");
                      save_html_loop b "" false

                 | PRE HtmlList ->
                      if not begin_lst then output_string Channel ";";
                      output_string Channel ("\nPRE [\n");
                      save_html_loop HtmlList "  " true;
                      output_string Channel ("\n");
                      save_html_loop b "" false

                 | BLOCKQUOTE HtmlList -> 
                      if not begin_lst then output_string Channel ";";
                      output_string Channel ("\nBLOCKQUOTE [\n");
                      save_html_loop HtmlList "  " true;
                      output_string Channel ("\n");
                      save_html_loop b "" false

                 | CITE HtmlList -> 
                      if not begin_lst then output_string Channel ";";
                      output_string Channel (" CITE [");
                      save_html_loop HtmlList indent true;
                      save_html_loop b indent false

                 | KBD HtmlList -> 
                      if not begin_lst then output_string Channel ";";
                      output_string Channel (" KBD [");
                      save_html_loop HtmlList indent true;
                      save_html_loop b indent false

                 | CODE HtmlList ->
                      if not begin_lst then output_string Channel ";";
                      output_string Channel (" CODE [");
                      save_html_loop HtmlList indent true;
                      save_html_loop b indent false
       
                 | DFN HtmlList ->
                      if not begin_lst then output_string Channel ";";
                      output_string Channel (" DFN [");
                      save_html_loop HtmlList indent true;
                      save_html_loop b indent false

                 | EM HtmlList ->
                      if not begin_lst then output_string Channel ";";
                      output_string Channel (" EM [");
                      save_html_loop HtmlList indent true;
                      save_html_loop b indent false

                 | VAR HtmlList ->
                      if not begin_lst then output_string Channel ";";
                      output_string Channel (" VAR [");
                      save_html_loop HtmlList indent true;
                      save_html_loop b indent false

                 | ADDRESS HtmlList ->
                      if not begin_lst then output_string Channel ";";
                      output_string Channel ("\nADDRESS [\n");
                      save_html_loop HtmlList indent true;
                      output_string Channel ("\n");
                      save_html_loop b "" false

                 | SAMP HtmlList ->
                      if not begin_lst then output_string Channel ";";
                      output_string Channel (" SAMP [");
                      save_html_loop HtmlList indent true;
                      save_html_loop b indent false

                 | DList HtmlList ->
                      if not begin_lst then output_string Channel ";";
                      output_string Channel "\nDList [\n";
                      save_html_loop HtmlList indent true;
                      output_string Channel "\n";
                      save_html_loop b indent false

                 | DT HtmlList ->
                      if not begin_lst then output_string Channel ";";
                      output_string Channel ("DT [");
                      save_html_loop HtmlList "  " true;
                      save_html_loop b "" false

                 | DD HtmlList ->
                      if not begin_lst then output_string Channel ";";
                      output_string Channel ("\n  DD [");
                      save_html_loop HtmlList "    " true;
                      save_html_loop b "" false

                 | LI HtmlList ->
                      if not begin_lst then output_string Channel ";";
                      output_string Channel ("LI [");
                      save_html_loop HtmlList "  " true;
                      save_html_loop b "" false

                 | BOLD HtmlList  ->
                      if not begin_lst then output_string Channel ";";
                      output_string Channel (" BOLD [");
                      save_html_loop HtmlList indent true;
                      save_html_loop b indent false

                 | ITALIC HtmlList ->
                      if not begin_lst then output_string Channel ";";
                      output_string Channel (" ITALIC [");
                      save_html_loop HtmlList indent true;
                      save_html_loop b indent false

                 | TT   HtmlList ->
                      if not begin_lst then output_string Channel ";";
                      output_string Channel (" TT [");
                      save_html_loop HtmlList indent true;
                      save_html_loop b indent false

                 | IMG  img  -> 
                      if not begin_lst then output_string Channel ";";
                      output_string Channel (" IMG { ImageFile = \"" ^
                                             img.ImageFile ^  
                                             "\"; ImageAlt = \"" ^
                                              img.ImageAlt ^
                                             "\"; ImageAlign = " ^ 
                                              (match img.ImageAlign with
                                                 AlignTop -> "AlignTop"
                                               | AlignMiddle -> "AlignMiddle"
                                               | AlignBottom -> "AlignBottom"
                                              ) ^
                                             " }");
                      save_html_loop b indent begin_lst

	  )
    in
      output_string Channel ("#open \"camlwin\";;\n\nlet " ^ Name ^ " =\n[ ");
      save_html_loop Html_ml "" true;
      output_string Channel ";;\n"
;;



