#open "windows";;
#open "camlwin";;
#open "g_global";;
#open "g_button";;
#open "g_scroll";;
#open "g_html_i";;



let debug = false;;



let html_indent = 25;;
let default_size = Size4_font;;
let Preformated = ref false;;







let rec search_space String pos =
  if pos < 0
  then -1
  else 
  (
    let a = nth_char String pos in
       if a = `\n`
       then  max 1 pos
       else if a = ` ` 
            then pos
            else search_space String (pos - 1)
  )
;;



let rec search_break String x Width =
  let len = string_length String in
   let rec break_loop pos  =
      match (pos = len) with
        true      -> len
      | false     -> 
           if nth_char String pos = `\n`
           then pos
           else
           (
             let str = sub_string String 0 pos in
               match (fst (text_size str) + x > Width, !Preformated) with
                 (_, true)  -> break_loop (pos + 1)
               | (false, _) -> break_loop (pos + 1)
               | (true, _)  -> max 0 (pos - 1)
           )
   in
     break_loop 0 
;;




let html_ft_type = ref Default_font;;
let html_ft_att  = ref Normal_font;;
let html_ft_size = ref default_size;;
let old_ft_type = ref Default_font;;
let old_ft_att  = ref Normal_font;;
let old_ft_size = ref default_size;;

let html_color = ref black;;

let html_font ft_type ft_att ft_size =
  set_font ft_type ft_att ft_size;
  old_ft_type := !html_ft_type;
  old_ft_att  := !html_ft_att;
  old_ft_size := !html_ft_size;
  html_ft_type := ft_type;
  html_ft_att  := ft_att;
  html_ft_size := ft_size
;;


let restore_font () =
  html_ft_type := !old_ft_type;
  html_ft_att  := !old_ft_att;
  html_ft_size := !old_ft_size;
  set_font !html_ft_type !html_ft_att !html_ft_size
;;






let html_draw_string String Width x Indent =
  let last = ref 0 
  and line_too_long = ref false in
  let rec draw_string_loop String x =
    let add_part pos len =
      line_too_long := false;
      if len = 0
      then []
      else 
      (
        let fst_str = sub_string String 0 pos 
        and snd_str = sub_string String (pos + 1)
                                 (len - pos - 1) in
              if debug 
              then 
              (
                print_string ("  add=" ^ fst_str);
                print_newline ()
              );

              {
               f_type = !html_ft_type;
               f_att  = !html_ft_att;
               f_size = !html_ft_size;
               f_color = !html_color;
               f_string = fst_str
              }
              :: draw_string_loop snd_str Indent 
       )
    in
    let pos = search_break String x (Width - Indent)
    and len = string_length String 
    and line_height = snd (text_size String) in
      if debug
      then
      (
         print_string "html_draw_string:\n";
         print_string "  pos=";
         print_int pos; 
         print_string "; len=";
         print_int len;
         print_string "; Width=";
         print_int Width;
         print_string "; x=";
         print_int x;
         print_string "; Indent=";
         print_int Indent;
         if !Preformated then print_string "; Preformated";
         print_string ("\n  String=" ^ String);
         print_newline ()
      );
      (
      match (!Preformated, pos = len) with
        (_, true) -> if debug 
                     then 
                     (
                       print_string "  return all";
                       print_newline ()
                     );
                     last :=x+(fst (text_size String));
                     [ {
                         f_type = !html_ft_type;
                         f_att  = !html_ft_att;
                         f_size = !html_ft_size;
                         f_color = !html_color;
                         f_string = String
                       } ]
      | (true, _)  -> add_part pos len
      | (_, false) -> 
           let cut_pos = if nth_char String (min (pos+1) (len-1)) = `\n`
                         then pos
                         else search_space String pos in
              if debug 
              then 
              (
                print_string "  cut_pos=";
                print_int cut_pos;
                print_newline ()
              );
          if cut_pos > 0
          then add_part cut_pos len
        else  
        (
           if not !line_too_long
           then 
           (
              line_too_long := true;
              {
               f_type = !html_ft_type;
               f_att  = !html_ft_att;
               f_size = !html_ft_size;
               f_color = !html_color;
               f_string = ""
              }
              ::draw_string_loop String Indent 
           )
           else 
           (
             if debug 
             then 
             (
               print_string "  too long, return all";
               print_newline ()
             );
               last :=x+(fst (text_size String));
             [ {
               f_type = !html_ft_type;
               f_att  = !html_ft_att;
               f_size = !html_ft_size;
               f_color = !html_color;
               f_string = String
              } ]
           )
        )
      )
  in
    let res = draw_string_loop String x in
      (!last, res)
;;





let HtmlList_to_Formated  Html width =
  let Result = ref [|{l_indent = 0; l_line = false; l_content = []} |]
  and AnchorList = ref [ ({ AnchorType =NAME; AnchorName ="";
                            AnchorFile=""}, 0) ]
  and len = ref 1 in
    AnchorList := [];
  let rec add_lines List indent = 
    match List with
      []   -> len := vect_length !Result
    | x::y -> Result := concat_vect !Result 
                                [| {l_indent = indent; 
                                    l_line = false; 
                                    l_content = [x]} |];
              add_lines y indent 
  and line_break Indent =
    Result := concat_vect !Result [|{l_indent = Indent; 
                                     l_line = false; 
                                     l_content = []}|];
    len := !len + 1
  in
  let rec html_draw_vect Html_ml x indent =
      match Html_ml with
        []   -> x
      | a::b ->
         let add_title HtmlList =
            line_break 0;
            html_draw_vect HtmlList 0 0;
            line_break 0;
            html_font Proportional_font Normal_font default_size;
            html_draw_vect b 0 0
         and add_peace HtmlList dx new_indent =
            let pos = html_draw_vect HtmlList dx new_indent in
              html_font Proportional_font Normal_font default_size;
              html_draw_vect b pos new_indent
         and add_string str dx =
            let res = html_draw_string str width dx indent 
            and last = !Result.(!len-1) in
              last.l_content <- last.l_content @ [(hd (snd res))];
              add_lines (tl (snd res)) indent;
              fst res
         in
         ( match a with
             HtmlText str -> 
                let pos = add_string str x in
                  html_draw_vect b pos indent 

           | ANCHOR Anchor ->
                AnchorList := !AnchorList @ [ (Anchor, !len-1)];
                if Anchor.AnchorType=HREF
                then
                (
                  html_font !html_ft_type Underline !html_ft_size;
                  if is_color_look ()
                  then html_color := blue;
                  let pos = add_string Anchor.AnchorName x in
                    restore_font ();
                    html_color := black;
                    html_draw_vect b pos indent
                )
                else
                (
                  if is_color_look ()
                  then html_color := white;
                  let pos = add_string Anchor.AnchorName x in
                    html_color := black;
                    html_draw_vect b pos indent
                )

           | LineBreak ->
                line_break 0;
                html_draw_vect b indent indent
           | Ignore str -> html_draw_vect b x indent
           | H1 HtmlList -> 
                html_font Proportional_font Normal_font Size1_font;
                add_title HtmlList
           | H2 HtmlList -> 
                html_font Proportional_font Normal_font Size2_font;
                add_title HtmlList
           | H3 HtmlList -> 
                html_font Proportional_font Normal_font Size3_font;
                add_title HtmlList
           | H4 HtmlList -> 
                html_font Proportional_font Normal_font Size4_font;
                add_title HtmlList
           | H5 HtmlList -> 
                html_font Proportional_font Normal_font Size5_font;
                add_title HtmlList
           | H6 HtmlList -> 
                html_font Proportional_font Normal_font Size6_font;
                add_title HtmlList
           | HLine    -> 
                line_break 0;
                !Result.(!len-1).l_line <- true;
                html_draw_vect b 0 0
           | STRONG HtmlList -> 
                html_font Proportional_font Bold default_size;
                add_peace HtmlList x indent
           | PRE HtmlList ->
                Preformated := true;
                html_font Fixed_font Normal_font default_size;
                let pos = html_draw_vect HtmlList x indent in
                  html_font Proportional_font Normal_font default_size;
                  Preformated := false;
                  html_draw_vect b pos indent
           | BLOCKQUOTE HtmlList -> 
                line_break html_indent;
                add_peace HtmlList html_indent html_indent
           | CITE HtmlList -> 
                html_font Proportional_font Italic default_size;
                add_peace HtmlList x indent
           | KBD HtmlList -> 
                html_font Fixed_font Normal_font default_size;
                add_peace HtmlList x indent
           | CODE HtmlList ->
                html_font Fixed_font Normal_font default_size;
                add_peace HtmlList x indent
           | DFN HtmlList ->
                html_font Proportional_font Italic default_size;
                add_peace HtmlList x indent
           | EM HtmlList ->
                html_font Proportional_font Italic default_size;
                add_peace HtmlList x indent
           | VAR HtmlList ->
                html_font Proportional_font Italic default_size;
                add_peace HtmlList x indent
           | ADDRESS HtmlList ->
                html_font Proportional_font Italic default_size;
                line_break 0;
                add_peace HtmlList 0 0
           | SAMP HtmlList ->
                html_font Proportional_font Normal_font default_size;
                add_peace HtmlList x indent
           | BOLD HtmlList  ->
                html_font !html_ft_type Bold !html_ft_size;
                let pos = html_draw_vect HtmlList x indent in
                   restore_font ();
                   html_draw_vect b pos indent
           | ITALIC HtmlList ->
                html_font !html_ft_type Italic !html_ft_size;
                let pos = html_draw_vect HtmlList x indent in
                   restore_font ();
                   html_draw_vect b pos indent
           | TT   HtmlList ->
                html_font Fixed_font !html_ft_att !html_ft_size;
                let pos = html_draw_vect HtmlList x indent in
                   restore_font ();
                   html_draw_vect b pos indent
           | LI HtmlList ->
                line_break indent;
                let len = fst (text_size "* ") in
                  let pos1 = add_string "* " (indent+len) in
                    let pos2 = html_draw_vect HtmlList pos1 indent in
                      html_draw_vect b pos2 indent
           | DT HtmlList ->
                line_break 0;
                add_peace HtmlList 0 0
           | DD HtmlList ->
                line_break html_indent;
                add_peace HtmlList html_indent html_indent
           | UList HtmlList -> 
                html_draw_vect HtmlList (indent+html_indent)
                               (indent+html_indent);
                line_break 0;
                html_draw_vect b 0 indent
           | OList HtmlList -> 
                html_draw_vect HtmlList (indent+html_indent) 
                               (indent+html_indent);
                line_break 0;
                html_draw_vect b 0 indent
           | DList HtmlList ->
                html_draw_vect HtmlList (indent+html_indent) 
                               (indent+html_indent);
                line_break 0;
                html_draw_vect b 0 indent
           | IMG  img  -> html_draw_vect b indent indent
	  )
    in
      html_font Proportional_font Normal_font default_size;
      html_draw_vect Html 0 0;
      set_color black;
      set_font Default_font Normal_font Size1_font;
  (!Result, !AnchorList)
;;










let rec html_anchor Html_ml  = 
  match Html_ml with
    []   -> []
  | x::y ->match x with
             ANCHOR Anchor -> Anchor :: (html_anchor y)
           | HtmlText str -> html_anchor y 
           | LineBreak    -> html_anchor y 
           | STRONG HtmlList -> (html_anchor HtmlList) @ (html_anchor y) 
           | Ignore str   -> html_anchor y 
           | H1 HtmlList  -> (html_anchor HtmlList) @ (html_anchor y) 
           | H2 HtmlList  -> (html_anchor HtmlList) @ (html_anchor y) 
           | H3 HtmlList  -> (html_anchor HtmlList) @ (html_anchor y) 
           | H4 HtmlList  -> (html_anchor HtmlList) @ (html_anchor y) 
           | H5 HtmlList  -> (html_anchor HtmlList) @ (html_anchor y) 
           | H6 HtmlList  -> (html_anchor HtmlList) @ (html_anchor y) 
           | UList HtmlList -> (html_anchor HtmlList) @ (html_anchor y)
           | OList HtmlList -> (html_anchor HtmlList) @ (html_anchor y)
           | HLine           -> html_anchor y 
           | PRE HtmlList    -> (html_anchor HtmlList) @ (html_anchor y) 
           | BLOCKQUOTE HtmlList ->(html_anchor HtmlList) @ (html_anchor y)  
           | CITE HtmlList   -> (html_anchor HtmlList) @ (html_anchor y) 
           | KBD HtmlList    -> (html_anchor HtmlList) @ (html_anchor y) 
           | CODE HtmlList   -> (html_anchor HtmlList) @ (html_anchor y) 
           | DFN HtmlList    -> (html_anchor HtmlList) @ (html_anchor y) 
           | EM HtmlList     -> (html_anchor HtmlList) @ (html_anchor y) 
           | VAR HtmlList    -> (html_anchor HtmlList) @ (html_anchor y) 
           | ADDRESS HtmlList -> (html_anchor HtmlList) @ (html_anchor y) 
           | SAMP HtmlList   -> (html_anchor HtmlList) @ (html_anchor y) 
           | DList HtmlList -> (html_anchor HtmlList) @ (html_anchor y)
           | LI HtmlList     -> (html_anchor HtmlList) @ (html_anchor y) 
           | DT HtmlList     -> (html_anchor HtmlList) @ (html_anchor y) 
           | DD HtmlList     -> (html_anchor HtmlList) @ (html_anchor y) 
           | BOLD HtmlList   -> (html_anchor HtmlList) @ (html_anchor y) 
           | ITALIC HtmlList -> (html_anchor HtmlList) @ (html_anchor y) 
           | TT   HtmlList   -> (html_anchor HtmlList) @ (html_anchor y) 
           | IMG  img        -> html_anchor y
;;
