#open "sys";;
#open "windows";;
#open "camlwin";;

#open "g_global";;
#open "g_config";;
#open "g_button";;
#open "g_string";;
#open "g_prompt";;
#open "g_extext";;






let gr_helpw_height = 130;;
let gr_helpw_width = 200;;


let gr_helpw_window_def = 
{
  win_id = undef_window;
  win_top = (screen_height() + (to_real_coord gr_helpw_height))/2;
  win_left = (screen_width() - (to_real_coord gr_helpw_width))/2;
  win_width = gr_helpw_width;
  win_height = gr_helpw_height;
  win_name = "Help";
  win_state = Destroyed
};;

let gr_helpw_OK =
{
  bt_window=gr_helpw_window_def;
  bt_left=(3*(gr_helpw_width-3*25)/4)+2*25;
  bt_top=15;
  bt_width=25;
  bt_height=12;
  bt_name=string_type "Ok";
  bt_state=Up;
  bt_callback= do_nothing
};;

let gr_helpw_Index =
{
  bt_window=gr_helpw_window_def;
  bt_left=(2*(gr_helpw_width-3*25)/4)+25;
  bt_top=15;
  bt_width=25;
  bt_height=12;
  bt_name=string_type "Index";
  bt_state=Up;
  bt_callback= do_nothing
};;

let gr_helpw_Back =
{
  bt_window=gr_helpw_window_def;
  bt_left=(1*(gr_helpw_width-3*25)/4)+0*25;
  bt_top=15;
  bt_width=25;
  bt_height=12;
  bt_name=string_type "Back";
  bt_state=Up;
  bt_callback= do_nothing
};;

let gr_helpw_help = 
{ extx_window = gr_helpw_window_def;
  extx_name = "Help";
  extx_left = 5;
  extx_top = gr_helpw_height - 10;
  extx_width = gr_helpw_width - 10;
  extx_height = gr_helpw_height - 27;
  extx_scroll = 0;
  extx_anchors = [];
  extx_content = [| |];
  extx_callback = extext_empty_callback
};;



let gr_helpw_prompt=
{
  pt_window=gr_helpw_window_def;
  pt_left=5;
  pt_top=gr_helpw_height - 2;
  pt_name="Name:"
};;



let gr_helpw_window = 
{
  win_def=gr_helpw_window_def;
  win_objects=[g_button gr_helpw_OK;
               g_button gr_helpw_Index;
               g_button gr_helpw_Back;
               g_extext gr_helpw_help;
               g_prompt gr_helpw_prompt
              ];
  time_callback = do_nothing;
  resize_callback = do_nothing;
  help_file = "";
  miscellaneous = [| |]
};;


let help_list = ref [""];;
help_list := [];;
let help_index = ref "";;


let help_path = try
               getenv "CAMLHELP"
            with Not_found -> "."
;;


let add_help_list Id =
  if fst Id = ""
  then Id
  else 
  (
    let name = help_path ^ gr_directory_separator ^ (fst Id) in
    if debug
    then
    (
      print_string ("try add to help_list: " ^ name ^ "\n");
      print_string ("      last help_list: " ^ (hd !help_list));
      print_newline ()
    );
    if not name = hd !help_list
    then help_list := name :: !help_list;
    (name, snd Id)
  )
;;

gr_helpw_help.extx_callback <- add_help_list;;


let BackCallback Obj Event =
  if not tl !help_list = []
  then
  (
    let name = hd (tl !help_list) in
    (
      try
        extext_load gr_helpw_help name;
        gr_helpw_help.extx_scroll <- 0;
        draw_gr_extext gr_helpw_help;
        help_list := tl !help_list;
        ()
       with _ ->  ()
    )
  );
  true
;;

gr_helpw_Back.bt_callback <- BackCallback;;


let IndexCallback Obj Event =
  (
  try
    extext_load gr_helpw_help !help_index;
    gr_helpw_help.extx_scroll <- 0;
    draw_gr_extext gr_helpw_help;
    ()
  with _ ->  ()
  );
  true
;;

gr_helpw_Index.bt_callback <- IndexCallback;;

