#open "windows";;
#open "camlwin";;

#open "g_global";;
#open "g_button";;





let std_draw_gr_helpbar Help =
  let height=line_height + 2*short_space + 2*long_space in
    set_color (backcolor());
    fill_rect long_space long_space
                ((to_real_coord Help.hl_window.win_width)-2*long_space)
                (height-2*long_space);
    draw_button 0 height
                ((to_real_coord Help.hl_window.win_width)-1)
                height
                Up;
    draw_button long_space (height-long_space)
                ((to_real_coord Help.hl_window.win_width)-2*long_space)
                (height-2*long_space)
                Down;
    set_color black;
    moveto (long_space+short_space)
           (long_space+short_space);
    draw_string Help.hl_help
;;


let open_col_draw_gr_helpbar Help =
  let height=line_height + 2*short_space + 2*long_space in
    std_col_draw_button 0 height
                ((to_real_coord Help.hl_window.win_width)-1)
                height
                Up;
    set_color darkgrey;
    fill_rect long_space long_space
                ((to_real_coord Help.hl_window.win_width)-2*long_space)
                (height-2*long_space);
    std_col_draw_button long_space (height-long_space)
                ((to_real_coord Help.hl_window.win_width)-2*long_space)
                (height-2*long_space)
                Down;

    set_color black;
    moveto (long_space+short_space)
           (long_space+short_space);
    draw_string Help.hl_help
;;


let open_mono_draw_gr_helpbar Help =
  let height=line_height + 2*short_space + 2*long_space in
    set_color black;
    draw_rect 0 0
                ((to_real_coord Help.hl_window.win_width)-1)
                height;
    draw_button long_space (height-long_space)
                ((to_real_coord Help.hl_window.win_width)-2*long_space)
                (height-2*long_space)
                Up;
    set_color black;
    moveto (long_space+short_space)
           (long_space+short_space);
    draw_string Help.hl_help
;;




let draw_gr_helpbar Help =
  if Help.hl_window.win_state=Created
  then
  (
    set_draw_window Help.hl_window.win_id;
    match (get_gr_look()) with
        Open_look_color -> open_col_draw_gr_helpbar Help
      | Open_look_mono  -> open_mono_draw_gr_helpbar Help
      | _               -> std_draw_gr_helpbar Help
  )
;;


