#open "windows";;
#open "camlwin";;

#open "g_global";;
#open "g_button";;
#open "g_radio";;



let rec max_length_loop List Pos Length =
  if Pos=Length
  then 0
  else max (fst (text_size List.(Pos))) (max_length_loop List (Pos+1) Length)
;;

let max_length List =
  max_length_loop List 0 (vect_length List);;



let next_draw_radio left top btwidth name state =
  let ray = (line_height + 2*short_space)/2 in
    set_color black;
    draw_arc (left+ray) (top-ray) ray ray 80 190;
    set_color nextgrey;
    draw_arc (left+ray) (top-ray) (ray+1) (ray+1) 55 215;
    if state
    then 
    (
      set_color white;
      fill_arc (left+ray) (top-ray) (ray -3) (ray -3) 0 360
    )
    else
    (
      set_color (backcolor ());
      fill_arc (left+ray) (top-ray) (ray -3) (ray -3) 0 360
    );
    set_color white;
    draw_arc (left+ray) (top-ray) ray ray 235 395;

    set_color black;
    moveto (left+2*ray+short_space) (top-short_space-line_height);
    draw_string name
;;



let rec draw_gr_grprad_loop Grprad Left Top Pos Width Height =
  let nb_button = vect_length Grprad.ga_name
  and deltax = Width+Grprad.ga_delta
  and deltay = Height+Grprad.ga_delta in
  if not Pos=nb_button
  then
  (
    let nb_h = max 1 ((Grprad.ga_width-Grprad.ga_delta)/deltax)
    and nb_v = max 1 ((Grprad.ga_height-Grprad.ga_delta)/deltay)
    and state=(if Grprad.ga_radio=Pos
               then true
               else false) in
      if get_gr_look () = Next_color
      then next_draw_radio (to_real_coord Left)
                 (to_real_coord Top)
                 ((to_real_coord Width)-line_height-2*short_space)
                 Grprad.ga_name.(Pos)
                 state
      else draw_radio (to_real_coord Left)
                 (to_real_coord Top)
                 ((to_real_coord Width)-line_height-2*short_space)
                 Grprad.ga_name.(Pos)
                 state;
      match (Pos+1) mod nb_v with
        0 -> draw_gr_grprad_loop Grprad
                                     (Left+deltax)
                                     (Grprad.ga_top-Grprad.ga_delta)
                                     (Pos + 1)
                                     Width
                                     Height

      | _ -> draw_gr_grprad_loop Grprad
                                     Left
                                     (Top-deltay)
                                     (Pos + 1)
                                     Width
                                     Height
  )
;;


let draw_unfilled_gr_grprad Grprad =
  if Grprad.ga_window.win_state=Created
  then
  (
    let Height=to_win_coord (line_height+2*short_space)
    and Width =to_win_coord ((max_length Grprad.ga_name) + 4*short_space + line_height) in
      draw_gr_grprad_loop Grprad
                          (Grprad.ga_delta+Grprad.ga_left)
                          (Grprad.ga_top-Grprad.ga_delta)
                          0
                          Width
                          Height
  )
;;

let std_draw_gr_grprad Grprad =
  draw_gr_button {
                  bt_window=Grprad.ga_window;
                  bt_left=Grprad.ga_left;
                  bt_top=Grprad.ga_top;
                  bt_width=Grprad.ga_width;
                  bt_height=Grprad.ga_height;
                  bt_name=string_type "";
                  bt_state=Down;
                  bt_callback= do_nothing
              };
  draw_unfilled_gr_grprad Grprad
;;


let open_col_draw_gr_grprad Grprad =
  let left  = to_real_coord Grprad.ga_left
  and top   = to_real_coord Grprad.ga_top
  and width = to_real_coord Grprad.ga_width
  and height= to_real_coord Grprad.ga_height in
    std_col_draw_button left top width height Down;
  draw_unfilled_gr_grprad Grprad
;;



let open_mono_draw_gr_grprad Grprad =
  let left  = to_real_coord Grprad.ga_left
  and top   = to_real_coord Grprad.ga_top
  and width = to_real_coord Grprad.ga_width
  and height= to_real_coord Grprad.ga_height in
    set_color black;
    draw_rect left (top-height) width height;
  draw_unfilled_gr_grprad Grprad
;;


let next_draw_gr_grprad Grprad =
  let left  = to_real_coord Grprad.ga_left
  and top   = to_real_coord Grprad.ga_top
  and width = to_real_coord Grprad.ga_width
  and height= to_real_coord Grprad.ga_height in
    std_col_draw_button left top width height Down;
  draw_unfilled_gr_grprad Grprad
;;



let draw_gr_grprad Grprad =
  if Grprad.ga_window.win_state=Created
  then
  (
    set_draw_window Grprad.ga_window.win_id;
      match (get_gr_look()) with
        Open_look_color -> open_col_draw_gr_grprad Grprad
      | Open_look_mono  -> open_mono_draw_gr_grprad Grprad
      | Next_color      -> next_draw_gr_grprad Grprad
      | _               -> std_draw_gr_grprad Grprad
  )
;;













let gr_grprad_callback Grprad Event =
  if Event.id_event=Button_down
  then
  (
    let Width =(max_length Grprad.ga_name)+4*short_space+line_height in
      let nb_button=vect_length Grprad.ga_name
          and deltax=to_win_coord (Width)+Grprad.ga_delta
          and deltay=to_win_coord (line_height+2*short_space)+Grprad.ga_delta
       in
        let nb_h=max 1 ((Grprad.ga_width-Grprad.ga_delta)/deltax)
        and nb_v=max 1 ((Grprad.ga_height-Grprad.ga_delta)/deltay) in
    let mouse_coord={x=Event.mouse_x; y=Event.mouse_y} and
        Group_area={x1=to_real_coord (Grprad.ga_left+Grprad.ga_delta);
                    y1=to_real_coord (Grprad.ga_top-Grprad.ga_delta-nb_v*deltay);
                    x2=to_real_coord (Grprad.ga_left+(nb_h+1)*deltax+Grprad.ga_delta);
                    y2=to_real_coord (Grprad.ga_top-Grprad.ga_delta)} in
      if inside mouse_coord Group_area
      then
      (
        let line = ((to_win_coord Event.mouse_x) -
                    (Grprad.ga_left+Grprad.ga_delta))/deltax
        and row  = (Grprad.ga_top-Grprad.ga_delta-
                    (to_win_coord Event.mouse_y))/deltay in
          let n=line*nb_v+row in
            if n<nb_button
            then
            (
              Grprad.ga_radio <- n;
              draw_unfilled_gr_grprad Grprad;
              Grprad.ga_callback Grprad Event
            )
            else false
      )
      else false
  )
  else false
;;

