#open "windows";;
#open "camlwin";;

#open "g_global";;
#open "g_button";;







let rec draw_gr_grpbut_loop Grpbut Left Top Pos =
  let nb_button=(vect_length Grpbut.gb_name)
  and deltax=Grpbut.gb_btwidth+Grpbut.gb_delta
  and deltay=Grpbut.gb_btheight+Grpbut.gb_delta in
  if not Pos=nb_button
  then
  (
    let nb_h=(Grpbut.gb_width/deltax)
    and nb_v=(Grpbut.gb_height/deltay) in
    let state=(if Grpbut.gb_button=Pos
               then Down
               else Up) in
      draw_gr_button {
                  bt_window=Grpbut.gb_window;
                  bt_left=Left;
                  bt_top=Top;
                  bt_width=Grpbut.gb_btwidth;
                  bt_height=Grpbut.gb_btheight;
                  bt_name=Grpbut.gb_name.(Pos);
                  bt_state=state;
                  bt_callback= do_nothing
              };
      match (Grpbut.gb_dir=Horizontal,
             ((Pos+1) mod nb_h)=0,
             ((Pos+1) mod nb_v)=0) with
        (true, false, _)  -> draw_gr_grpbut_loop Grpbut
                                                 (Left+deltax)
                                                 Top
                                                 (Pos + 1)
      | (true, true, _)   -> draw_gr_grpbut_loop Grpbut
                                                 (Grpbut.gb_delta+Grpbut.gb_left)
                                                 (Top-deltay)
                                                 (Pos + 1)
      | (false, _, false) -> draw_gr_grpbut_loop Grpbut
                                                 Left
                                                 (Top-deltay)
                                                 (Pos + 1)
      | (false, _, true)  -> draw_gr_grpbut_loop Grpbut
                                                 (Left+deltax)
                                                 (Grpbut.gb_top-Grpbut.gb_delta)
                                                 (Pos + 1)
  )
;;



let std_draw_gr_grpbut Grpbut =
  draw_gr_button {
                  bt_window=Grpbut.gb_window;
                  bt_left=Grpbut.gb_left;
                  bt_top=Grpbut.gb_top;
                  bt_width=Grpbut.gb_width;
                  bt_height=Grpbut.gb_height;
                  bt_name=string_type "";
                  bt_state=Down;
                  bt_callback= do_nothing
              };
  draw_gr_grpbut_loop Grpbut
                      (Grpbut.gb_delta+Grpbut.gb_left)
                      (Grpbut.gb_top-Grpbut.gb_delta)
                      0
;;


let open_col_draw_gr_grpbut Grpbut =
  let left  = to_real_coord Grpbut.gb_left
  and top   = to_real_coord Grpbut.gb_top
  and width = to_real_coord Grpbut.gb_width
  and height= to_real_coord Grpbut.gb_height in
    std_col_draw_button left top width height Down;
  draw_gr_grpbut_loop Grpbut
                      (Grpbut.gb_delta+Grpbut.gb_left)
                      (Grpbut.gb_top-Grpbut.gb_delta)
                      0
;;


let open_mono_draw_gr_grpbut Grpbut =
  let left  = to_real_coord Grpbut.gb_left
  and top   = to_real_coord Grpbut.gb_top
  and width = to_real_coord Grpbut.gb_width
  and height= to_real_coord Grpbut.gb_height in
    set_color black;
    draw_rect left (top-height) width height;
    draw_gr_grpbut_loop Grpbut
                        (Grpbut.gb_delta+Grpbut.gb_left)
                        (Grpbut.gb_top-Grpbut.gb_delta)
                        0
;;


let next_draw_gr_grpbut Grpbut =
  let left  = to_real_coord Grpbut.gb_left
  and top   = to_real_coord Grpbut.gb_top
  and width = to_real_coord Grpbut.gb_width
  and height= to_real_coord Grpbut.gb_height in
    std_col_draw_button left top width height Down;
  draw_gr_grpbut_loop Grpbut
                      (Grpbut.gb_delta+Grpbut.gb_left)
                      (Grpbut.gb_top-Grpbut.gb_delta)
                      0
;;




let draw_gr_grpbut Grpbut =
  if Grpbut.gb_window.win_state=Created
  then
  (
    set_draw_window Grpbut.gb_window.win_id;
    match (get_gr_look()) with
      Open_look_color -> open_col_draw_gr_grpbut Grpbut
    | Open_look_mono  -> open_mono_draw_gr_grpbut Grpbut
    | Next_color      -> next_draw_gr_grpbut Grpbut
    | _               -> std_draw_gr_grpbut Grpbut
  )
;;




let rec draw_unfilled_gr_grpbut_loop Grpbut Left Top Pos =
  let nb_button=(vect_length Grpbut.gb_name)
  and deltax=(Grpbut.gb_btwidth+Grpbut.gb_delta)
  and deltay=(Grpbut.gb_btheight+Grpbut.gb_delta) in
  if not Pos=nb_button
  then
  (
    let nb_h=(Grpbut.gb_width/deltax)
    and nb_v=(Grpbut.gb_height/deltay) in
    let state=(if Grpbut.gb_button=Pos
               then Down
               else Up) in
      draw_unfilled_gr_button {
                  bt_window=Grpbut.gb_window;
                  bt_left=Left;
                  bt_top=Top;
                  bt_width=Grpbut.gb_btwidth;
                  bt_height=Grpbut.gb_btheight;
                  bt_name=string_type"";
                  bt_state=state;
                  bt_callback= do_nothing
              };
      match (Grpbut.gb_dir=Horizontal,
             ((Pos+1) mod nb_h)=0,
             ((Pos+1) mod nb_v)=0) with
        (true, false, _)  -> draw_unfilled_gr_grpbut_loop Grpbut
                                                 (Left+deltax)
                                                 Top
                                                 (Pos + 1)
      | (true, true, _)   -> draw_unfilled_gr_grpbut_loop Grpbut
                                                 (Grpbut.gb_delta+Grpbut.gb_left)
                                                 (Top-deltay)
                                                 (Pos + 1)
      | (false, _, false) -> draw_unfilled_gr_grpbut_loop Grpbut
                                                 Left
                                                 (Top-deltay)
                                                 (Pos + 1)
      | (false, _, true)  -> draw_unfilled_gr_grpbut_loop Grpbut
                                                 (Left+deltax)
                                                 (Grpbut.gb_top-
                                                  Grpbut.gb_delta)
                                                 (Pos + 1)
  )
;;


let draw_unfilled_gr_grpbut Grpbut =
  if Grpbut.gb_window.win_state=Created
  then
  (
    set_draw_window Grpbut.gb_window.win_id;
    match (get_gr_look()) with
      Open_look_color ->
        draw_gr_grpbut_loop Grpbut
                            (Grpbut.gb_delta+Grpbut.gb_left)
                            (Grpbut.gb_top-Grpbut.gb_delta)
                            0
    | Open_look_mono ->
        draw_gr_grpbut_loop Grpbut
                            (Grpbut.gb_delta+Grpbut.gb_left)
                            (Grpbut.gb_top-Grpbut.gb_delta)
                            0
    | Motif_color    ->
        draw_gr_grpbut_loop Grpbut
                            (Grpbut.gb_delta+Grpbut.gb_left)
                            (Grpbut.gb_top-Grpbut.gb_delta)
                            0
    | Next_color     ->
        draw_gr_grpbut_loop Grpbut
                            (Grpbut.gb_delta+Grpbut.gb_left)
                            (Grpbut.gb_top-Grpbut.gb_delta)
                            0
    | _               ->
        draw_unfilled_gr_grpbut_loop Grpbut
                                     (Grpbut.gb_left+Grpbut.gb_delta)
                                     (Grpbut.gb_top-Grpbut.gb_delta)
                                     0
  )
;;










let gr_grpbut_callback Grpbut Event =
  if Event.id_event=Button_down
  then
  (
      let nb_button=vect_length Grpbut.gb_name
          and deltax=Grpbut.gb_btwidth+Grpbut.gb_delta
          and deltay=Grpbut.gb_btheight+Grpbut.gb_delta in
        let nb_h=Grpbut.gb_width/deltax
        and nb_v=Grpbut.gb_height/deltay in
    let mouse_coord={x=Event.mouse_x; y=Event.mouse_y} and
        Group_area={x1=to_real_coord (Grpbut.gb_left+Grpbut.gb_delta);
                    y1=to_real_coord (Grpbut.gb_top-Grpbut.gb_delta-nb_v*deltay);
                    x2=to_real_coord (Grpbut.gb_left+nb_h*deltax);
                    y2=to_real_coord (Grpbut.gb_top-Grpbut.gb_delta)
                   } in
      if inside mouse_coord Group_area
      then
      (
        let line=(Event.mouse_x-to_real_coord (Grpbut.gb_left+Grpbut.gb_delta))/to_real_coord (deltax)
        and row =(to_real_coord (Grpbut.gb_top-Grpbut.gb_delta)-Event.mouse_y)/to_real_coord (deltay) in
          let n= match Grpbut.gb_dir with
                    Horizontal -> row*nb_h+line
                  | _          -> line*nb_v+row
                 in
            if n<nb_button
            then
            (
              Grpbut.gb_button <- n;
              draw_unfilled_gr_grpbut Grpbut;
              Grpbut.gb_callback Grpbut Event
            )
            else false
      )
      else false
  )
  else false
;;

