#open "windows";;
#open "camlwin";;

#open "g_global";;





let draw_gr_line Line =
  if Line.ln_window.win_state=Created
  then
  (
    set_draw_window Line.ln_window.win_id;
    if not (Line.ln_color=transp)
    then
      set_color Line.ln_color;
      moveto (to_real_coord (fst Line.ln_point1))
             (to_real_coord (snd Line.ln_point1));
      lineto (to_real_coord (fst Line.ln_point2))
             (to_real_coord (snd Line.ln_point2))
  )
;;


let draw_gr_ellipse Ellipse =
  if Ellipse.el_window.win_state=Created
  then
  (
    set_draw_window Ellipse.el_window.win_id;
    if not (Ellipse.el_color=transp)
    then
    (
      set_color Ellipse.el_color;
      if Ellipse.el_filled
      then fill_ellipse (to_real_coord (fst Ellipse.el_center))
                        (to_real_coord (snd Ellipse.el_center))
                        (to_real_coord Ellipse.el_xray)
                        (to_real_coord Ellipse.el_yray)
      else draw_ellipse (to_real_coord (fst Ellipse.el_center))
                        (to_real_coord (snd Ellipse.el_center))
                        (to_real_coord Ellipse.el_xray)
                        (to_real_coord Ellipse.el_yray)
    )
  )
;;


let draw_gr_rectangle Rectangle =
  if Rectangle.re_window.win_state=Created
  then
  (
    set_draw_window Rectangle.re_window.win_id;
    if not (Rectangle.re_color=transp)
    then
    (
      set_color Rectangle.re_color;
      if Rectangle.re_filled
      then fill_rect (to_real_coord (fst Rectangle.re_point))
                     (to_real_coord (snd Rectangle.re_point))
                     (to_real_coord Rectangle.re_width)
                     (to_real_coord Rectangle.re_height)
      else draw_rect (to_real_coord (fst Rectangle.re_point))
                     (to_real_coord (snd Rectangle.re_point))
                     (to_real_coord Rectangle.re_width)
                     (to_real_coord Rectangle.re_height)
    )
  )
;;


