#open "windows";;
#open "camlwin";;

#open "g_global";;
#open "g_graph";;
#open "g_exprpt";;
#open "g_mloop";;
#open "g_warn";;




let FontWin_def = 
{
  win_left     = 10;
  win_top      = 497;
  win_width    = 140;
  win_height   = 110;
  win_id       = undef_window;
  win_name     = "Font window";
  win_state    = Destroyed
};;

let sfont_draw = 
{
  re_window   = FontWin_def;
  re_filled   = true;
  re_color    = white;
  re_point    = (4, 16);
  re_width    = 82;
  re_height   = 16
};;

let sfont_text =
{ 
  expt_window = FontWin_def;
  expt_left   = 6;
  expt_top    = 25;
  expt_name   = { f_type   = Default_font;
                  f_att    = Normal_font;
                  f_size   = Size3_font;
                  f_color  = black;
                  f_string = "Word test"
                }
};;

let sfont_pt_type = 
{
  pt_window   = FontWin_def;
  pt_left     = 4;
  pt_top      = 95;
  pt_name     = "Font type:"
};;

let sfont_att = 
{
  ga_window   = FontWin_def;
  ga_left     = 48;
  ga_top      = 90;
  ga_width    = 36;
  ga_height   = 54;
  ga_delta    = 5;
  ga_radio    = 0;
  ga_name     = [|
                 "Normal";
                 "Italic";
                 "Bold";
                 "Underline"
                |];
  ga_callback = do_nothing
};;

let sfont_type = 
{
  ga_window   = FontWin_def;
  ga_left     = 4;
  ga_top      = 90;
  ga_width    = 40;
  ga_height   = 54;
  ga_delta    = 5;
  ga_radio    = 0;
  ga_name     = [|
                 "Default";
                 "Fixed";
                 "Proportional"
                |];
  ga_callback = do_nothing
};;

let sfont_size = 
{
  ga_window   = FontWin_def;
  ga_left     = 89;
  ga_top      = 90;
  ga_width    = 44;
  ga_height   = 74;
  ga_delta    = 5;
  ga_radio    = 0;
  ga_name     = [|
                 "Size 1";
                 "Size 2";
                 "Size 3";
                 "Size 4";
                 "Size 5";
                 "Size 6"
                |];
  ga_callback = do_nothing
};;

let sfont_pt_att = 
{
  pt_window   = FontWin_def;
  pt_left     = 48;
  pt_top      = 95;
  pt_name     = "Attribute"
};;

let sfont_pt_size = 
{
  pt_window   = FontWin_def;
  pt_left     = 89;
  pt_top      = 95;
  pt_name     = "Size:"
};;

let sfont_pt_title = 
{
  expt_window = FontWin_def;
  expt_left   = 42;
  expt_top    = 106;
  expt_name   = { f_type   = Proportional_font;
                  f_att    = Italic;
                  f_size   = Size1_font;
                  f_color  = black;
                  f_string = "Select a font"
                }
};;

let sfont_ok = 
{
  bt_window   = FontWin_def;
  bt_left     = 4;
  bt_top      = 12;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Ok";
  bt_callback = do_nothing
};;

let sfont_cancel = 
{
  bt_window   = FontWin_def;
  bt_left     = 40;
  bt_top      = 12;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Cancel";
  bt_callback = do_nothing
};;

let FontWin = 
{
  win_def      = FontWin_def;
  win_objects  = [
                  g_rectangle sfont_draw;
                  g_exprompt  sfont_text;
                  g_prompt    sfont_pt_type;
                  g_grprad    sfont_att;
                  g_grprad    sfont_type;
                  g_grprad    sfont_size;
                  g_prompt    sfont_pt_att;
                  g_prompt    sfont_pt_size;
                  g_exprompt  sfont_pt_title;
                  g_button    sfont_ok;
                  g_button    sfont_cancel
                 ];
  time_callback  = do_nothing;
  resize_callback  = do_nothing;
  help_file = "";
  miscellaneous = [| |]
};;






let ChangeFontCallback Obj Event =
  let fstr = sfont_text.expt_name in
  fstr.f_type <- ( match sfont_type.ga_radio with
                     0 -> Default_font
                   | 1 -> Fixed_font
                   | _ -> Proportional_font
                 );
   fstr.f_att <- ( match sfont_att.ga_radio with
                      0 -> Normal_font
                    | 1 -> Italic
                    | 2 -> Bold
                    | _ -> Underline
                 );
  fstr.f_size <- ( match sfont_size.ga_radio with
                     0 -> Size1_font
                   | 1 -> Size2_font
                   | 2 -> Size3_font
                   | 3 -> Size4_font
                   | 4 -> Size5_font
                   | _ -> Size6_font
                 );
  draw_gr_rectangle sfont_draw;
  (
  try
    set_clip_area (to_real_coord (fst sfont_draw.re_point)) 
                  (to_real_coord (snd sfont_draw.re_point))
                  (to_real_coord sfont_draw.re_width) 
                  (to_real_coord sfont_draw.re_height);
    draw_gr_exprompt sfont_text;
    set_clip_area 0 0 (screen_width ()) (screen_height ())
  with _ ->  create_warning 
               "Can't load this font." 
               [| { warn_name="Ok"; warn_callback =close_warning }|];
             sfont_text.expt_name.f_type <- Default_font;
             sfont_type.ga_radio <- 0
  );
  true
;;



let font_save = {f_type=Default_font; 
                 f_att=Normal_font; 
                 f_size=Size4_font;
                 f_color=black;
                 f_string=""
                };;

let OkCallback Obj Event =
  erase_window FontWin.win_def;
  true
;;


let CancelCallback Obj Event =
  let fStr = sfont_text.expt_name in
    fStr.f_type <- font_save.f_type;
    fStr.f_att  <- font_save.f_att;
    fStr.f_size <- font_save.f_size;
    fStr.f_color <- font_save.f_color;
  erase_window FontWin.win_def;
  true
;;



sfont_ok.bt_callback <- OkCallback;;
sfont_cancel.bt_callback <- CancelCallback;;
sfont_type.ga_callback <- ChangeFontCallback;;
sfont_att.ga_callback <- ChangeFontCallback;;
sfont_size.ga_callback <- ChangeFontCallback;;


let select_font fStr =
  let Draw = sfont_text.expt_name in
  Draw.f_type <- fStr.f_type;
  Draw.f_att  <- fStr.f_att;
  Draw.f_size <- fStr.f_size;
  Draw.f_color <- fStr.f_color;
  Draw.f_string <- fStr.f_string;
  font_save.f_type <- fStr.f_type;
  font_save.f_att  <- fStr.f_att;
  font_save.f_size <- fStr.f_size;
  font_save.f_color <- fStr.f_color;
  block_loop FontWin;
  sfont_text.expt_name
;;
  