#open "windows";;
#open "camlwin";;

#open "g_global";;
#open "g_text";;
#open "g_mloop";;
#open "g_warn";;


let search_win_def =
{
  win_left     = 20;
  win_top      = 220;
  win_width    = 150;
  win_height   = 100;
  win_id       = undef_window;
  win_name     = "Search";
  win_state    = Destroyed
};;

let search_prompt2 =
{
  pt_window   = search_win_def;
  pt_left     = 5;
  pt_top      = 67;
  pt_name     = "Search type:"
};;

let search_cancel =
{
  bt_window   = search_win_def;
  bt_left     = 87;
  bt_top      = 25;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Cancel";
  bt_callback = do_nothing
};;

let search_ok =
{
  bt_window   = search_win_def;
  bt_left     = 37;
  bt_top      = 25;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Ok";
  bt_callback = do_nothing
};;

let search_help =
{
  hl_window   = search_win_def;
  hl_help     = "Type string to search, then press Ok"
};;

let search_type =
{
  ga_window   = search_win_def;
  ga_left     = 5;
  ga_top      = 60;
  ga_width    = 65;
  ga_height   = 27;
  ga_delta    = 5;
  ga_radio    = 1;
  ga_name     = [|
                 "From cursor";
                 "Entire scope"
                |];
  ga_callback = do_nothing
};;

let search_zone =
{
  ga_window   = search_win_def;
  ga_left     = 75;
  ga_top      = 60;
  ga_width    = 70;
  ga_height   = 27;
  ga_delta    = 5;
  ga_radio    = 0;
  ga_name     = [|
                 "Selected area";
                 "Full text"
                |];
  ga_callback = do_nothing
};;

let search_title =
{
  pt_window   = search_win_def;
  pt_left     = 61;
  pt_top      = 96;
  pt_name     = "Find"
};;

let search_text =
{
  st_window   = search_win_def;
  st_left     = 60;
  st_top      = 84;
  st_width    = 85;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = do_nothing
};;

let search_prompt =
{
  pt_window   = search_win_def;
  pt_left     = 5;
  pt_top      = 82;
  pt_name     = "Text to find:"
};;

let search_win =
{
  win_def      = search_win_def;
  win_objects  = [
                  g_prompt    search_prompt2;
                  g_button    search_cancel;
                  g_button    search_ok;
                  g_helpbar   search_help;
                  g_grprad    search_type;
                  g_grprad    search_zone;
                  g_prompt    search_title;
                  g_string    search_text;
                  g_prompt    search_prompt
                 ];
  time_callback = do_nothing;
  resize_callback = do_nothing;
  help_file = "";
  miscellaneous = [| |]
};;


let really_search = ref false;;


let CloseSearchWin Obj Event =
  erase_window search_win.win_def;
  really_search := false;
  true
;;

let SearchThenClose Obj Event =
  erase_window search_win.win_def;
  really_search := true;
  true
;;


search_cancel.bt_callback <- CloseSearchWin;;
search_ok.bt_callback     <- SearchThenClose;;
search_text.st_callback   <- SearchThenClose;;



let find_in_text Text x y =
  search_win.win_def.win_left <- x;
  search_win.win_def.win_top  <- y;
  block_loop search_win;
  if !really_search
  then
  (
    let searchfrom= match (search_zone.ga_radio,search_type.ga_radio) with
                (0,_) -> FullSelected
              | (_,0) -> FromCursor
              | _     -> FullText
     in
      let pos=search_string Text search_text.st_name searchfrom in
        if not (fst pos)=(-1)
        then goto_text Text pos
        else create_warning ("Text \"" ^ search_text.st_name ^ "\" not found!")
                            [| {warn_name="Ok"; warn_callback=close_warning} |]
  )
;;






let replace_win_def =
{
  win_left     = 20;
  win_top      = 220;
  win_width    = 150;
  win_height   = 100;
  win_id       = undef_window;
  win_name     = "Replace";
  win_state    = Destroyed
};;

let replace_type =
{
  ga_window   = replace_win_def;
  ga_left     = 5;
  ga_top      = 60;
  ga_width    = 65;
  ga_height   = 27;
  ga_delta    = 5;
  ga_radio    = 0;
  ga_name     = [|
                 "From cursor";
                 "Entire scope"
                |];
  ga_callback = do_nothing
};;

let replace_zone =
{
  ga_window   = replace_win_def;
  ga_left     = 75;
  ga_top      = 60;
  ga_width    = 70;
  ga_height   = 27;
  ga_delta    = 5;
  ga_radio    = 0;
  ga_name     = [|
                 "Selected area";
                 "Full text"
                |];
  ga_callback = do_nothing
};;

let replace_title =
{
  pt_window   = replace_win_def;
  pt_left     = 56;
  pt_top      = 97;
  pt_name     = "Replace"
};;

let replace_prompt1 =
{
  pt_window   = replace_win_def;
  pt_left     = 5;
  pt_top      = 85;
  pt_name     = "Text to Find:"
};;

let replace_tofind =
{
  st_window   = replace_win_def;
  st_left     = 62;
  st_top      = 87;
  st_width    = 75;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = do_nothing
};;

let replace_with =
{
  st_window   = replace_win_def;
  st_left     = 62;
  st_top      = 75;
  st_width    = 75;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = do_nothing
};;

let replace_help =
{
  hl_window   = replace_win_def;
  hl_help     = "Type both text, then press Ok"
};;

let replace_cancel =
{
  bt_window   = replace_win_def;
  bt_left     = 87;
  bt_top      = 25;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Cancel";
  bt_callback = do_nothing
};;

let replace_ok =
{
  bt_window   = replace_win_def;
  bt_left     = 42;
  bt_top      = 25;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Ok";
  bt_callback = do_nothing
};;

let replace_tprompt2 =
{
  pt_window   = replace_win_def;
  pt_left     = 5;
  pt_top      = 72;
  pt_name     = "Replaced with:"
};;

let replace_win =
{
  win_def      = replace_win_def;
  win_objects  = [
                  g_grprad    replace_type;
                  g_grprad    replace_zone;
                  g_prompt    replace_title;
                  g_prompt    replace_prompt1;
                  g_string    replace_tofind;
                  g_string    replace_with;
                  g_helpbar   replace_help;
                  g_button    replace_cancel;
                  g_button    replace_ok;
                  g_prompt    replace_tprompt2
                 ];
  time_callback = do_nothing;
  resize_callback = do_nothing;
  help_file = "";
  miscellaneous = [| |]
};;


let really_replace = ref false;;


let CloseReplaceWin Obj Event =
  erase_window replace_win.win_def;
  really_replace := false;
  true
;;

let ReplaceThenClose Obj Event =
  erase_window replace_win.win_def;
  really_replace := true;
  true
;;


replace_cancel.bt_callback <- CloseReplaceWin;;
replace_ok.bt_callback     <- ReplaceThenClose;;
replace_with.st_callback   <- ReplaceThenClose;;



let replace_in_text Text x y =
  replace_win.win_def.win_left <- x;
  replace_win.win_def.win_top  <- y;
  block_loop replace_win;
  if !really_replace
  then
  (
    let replacefrom= match (replace_zone.ga_radio,replace_type.ga_radio) with
                (0,_) -> FullSelected
              | (_,0) -> FromCursor
              | _     -> FullText
     in
      let found=replace_string Text
                             replace_tofind.st_name
                             replace_with.st_name
                             replacefrom in
        if found
        then goto_text Text (Text.tx_cursor, Text.tx_line)
        else create_warning ("Text \"" ^ replace_tofind.st_name ^ "\" not found!")
                            [| {warn_name="Ok"; warn_callback=close_warning} |]
  )
;;

