#open "sys";;

#open "windows";;
#open "camlwin";;

#open "g_global";;
#open "g_button";;
#open "g_string";;
#open "g_mloop";;
#open "g_prompt";;
#open "g_list";;
#open "g_text";;
#open "g_filter";;



let gr_file_width = 155;;
let gr_file_height = 125;;


let gr_file_def =
{
  win_left     = (screen_width() - (to_real_coord gr_file_width))/2;
  win_top      = (screen_height() + (to_real_coord gr_file_height))/2;
  win_width    = gr_file_width;
  win_height   = gr_file_height;
  win_id       = undef_window;
  win_name     = "Select a File";
  win_state    = Destroyed
};;

let file_prompt1 =
{
  pt_window   = gr_file_def;
  pt_left     = 4;
  pt_top      = 100;
  pt_name     = "Current directory:"
};;

let file_current =
{
  st_window   = gr_file_def;
  st_left     = 3;
  st_top      = 95;
  st_width    = 100;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = do_nothing
};;

let file_ok =
{
  bt_window   = gr_file_def;
  bt_left     = 116;
  bt_top      = 116;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Ok";
  bt_callback = do_nothing
};;

let file_cancel =
{
  bt_window   = gr_file_def;
  bt_left     = 116;
  bt_top      = 98;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Cancel";
  bt_callback = do_nothing
};;

let file_prompt5 =
{
  pt_window   = gr_file_def;
  pt_left     = 4;
  pt_top      = 120;
  pt_name     = "File:"
};;

let file_prompt9 =
{
  pt_window   = gr_file_def;
  pt_left     = 76;
  pt_top      = 81;
  pt_name     = "Files:"
};;

let file_prompt8 =
{
  pt_window   = gr_file_def;
  pt_left     = 3;
  pt_top      = 20;
  pt_name     = "filter:"
};;

let file_prompt7 =
{
  pt_window   = gr_file_def;
  pt_left     = 4;
  pt_top      = 82;
  pt_name     = "Directories:"
};;

let file_filter =
{
  st_window   = gr_file_def;
  st_left     = 41;
  st_top      = 22;
  st_width    = 75;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "*.*";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = do_nothing
};;

let helpbar =
{
  hl_window   = gr_file_def;
  hl_help     = "Press Ok when choosen"
};;

let file_list =
{
  li_window   = gr_file_def;
  li_left     = 76;
  li_top      = 76;
  li_width    = 60;
  li_height   = 50;
  li_nu_item  = 0;
  li_1st_item = 0;
  li_scroll   = 0;
  li_items    = [| |];
  li_callback = do_nothing
};;

let file_file =
{
  st_window   = gr_file_def;
  st_left     = 4;
  st_top      = 115;
  st_width    = 100;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = do_nothing
};;


let file_directory =
{
  li_window   = gr_file_def;
  li_left     = 4;
  li_top      = 76;
  li_width    = 60;
  li_height   = 50;
  li_nu_item  = 0;
  li_1st_item = 0;
  li_scroll   = 0;
  li_items    = [| |];
  li_callback = do_nothing
};;

let gr_file =
{
  win_def      = gr_file_def;
  win_objects  = [
                  g_prompt file_prompt1;
                  g_string file_current;
                  g_button file_ok;
                  g_button file_cancel;
                  g_prompt file_prompt9;
                  g_prompt file_prompt8;
                  g_prompt file_prompt7;
                  g_string file_filter;
                  g_prompt file_prompt5;
                  g_helpbar helpbar;
                  g_list file_list;
                  g_list file_directory;
                  g_string file_file
                 ];
  time_callback = do_nothing;
  resize_callback = do_nothing;
  help_file = "";
  miscellaneous = [| |]
};;

let dir = ref "";;


let rec gr_init_file_loop String Pos Len=
  let n=(string_length String) in
    if Pos<Len-1
    then
      (
        let d=(nth_char String Pos)
        and p=ref Pos in
            while( not nth_char String !p=`\n`) do (p:= !p +1) done;
          let line=sub_string String (Pos+2) (!p-Pos-2) in
            if d=`d`
            then add_item file_directory line 0
            else
              if filter line file_filter.st_name
              then add_item file_list line 0;
            gr_init_file_loop String (!p+1) Len
      )
;;


let gr_init_file () =
  dir := "";
  let dir=read_dir() in
    file_directory.li_items <- [| |];
    file_list.li_items <- [| |];
    gr_init_file_loop dir 0 (string_length dir);
    list_sort file_directory;
    list_sort file_list;
    file_list.li_scroll <- 0;
    file_list.li_nu_item <- 0;
    file_list.li_1st_item <- 0;
    file_directory.li_scroll <- 0;
    file_directory.li_nu_item <- 0;
    file_directory.li_1st_item <- 0;

    file_current.st_name <- current_dir()
;;


let SelectDir List Event =
  if !dir = ""
  then dir := List.li_items.(List.li_nu_item)
  else if !dir = List.li_items.(List.li_nu_item)
       then
       (
         change_dir List.li_items.(List.li_nu_item);
         gr_init_file ();
         draw_gr_list file_directory;
         draw_gr_list file_list;
         file_file.st_name <- file_filter.st_name;
         file_file.st_cursor <- 0;
         file_file.st_1st_char <- 0;
         draw_gr_string file_file;
         file_current.st_name <- current_dir();
         draw_gr_string file_current
       )
       else dir := List.li_items.(List.li_nu_item);
  true
;;


let FileSelected Button Event =
  if file_file.st_name=file_filter.st_name
  then false
  else erase_window gr_file.win_def
;;





let SelectFile List Event =
  dir := "";
  if (vect_length List.li_items)>0
  then
    (
      let selected=List.li_items.(List.li_nu_item) in
        if selected=file_file.st_name
        then (FileSelected file_ok Event; () )
        else
        (
          file_file.st_name <- selected;
          file_file.st_cursor <- 0;
          file_file.st_1st_char <- 0;
          draw_gr_string file_file
        )
    );
  true
;;



let CancelSelect Button Event =
  file_file.st_name <- "";
  erase_window gr_file.win_def
;;

let ChangeFilter Obj Event =
  gr_init_file ();
  draw_gr_list file_directory;
  draw_gr_list file_list;
  file_file.st_name <- file_filter.st_name;
  file_file.st_cursor <- 0;
  file_file.st_1st_char <- 0;
  draw_gr_string file_file;
  file_current.st_name <- current_dir();
  draw_gr_string file_current;
  true
;; 



let select_file Filter =
  file_list.li_callback <- SelectFile;
  file_directory.li_callback <- SelectDir;
  file_ok.bt_callback <- FileSelected;
  file_cancel.bt_callback <- CancelSelect;
  file_filter.st_name <- Filter;
  file_filter.st_callback <- ChangeFilter;
  gr_init_file ();
  file_filter.st_cursor <- 0;
  file_filter.st_1st_char <- 0;
  file_file.st_name <- file_filter.st_name;
  file_file.st_cursor <- 0;
  file_file.st_1st_char <- 0;
  file_current.st_cursor <- 0;
  file_current.st_1st_char <- 0;

  block_loop gr_file;

  file_file.st_name
;;





let without_suffix String =
  let rec without_suffix_loop Pos Len =
    if Pos=Len
    then String
    else if (nth_char String Pos)=`.`
         then (sub_string String 0 Pos)
         else without_suffix_loop (Pos+1) Len
  in
    without_suffix_loop 0 (string_length String)
;;






let suffix_only String =
  let rec suffix_only_loop Pos Len =
    if Pos=Len
    then ""
    else if (nth_char String Pos)=`.`
         then (sub_string String (Pos+1) (Len-Pos-1))
         else suffix_only_loop (Pos+1) Len
  in
    suffix_only_loop 0 (string_length String)
;;



