#open "sys";;


#open "windows";;
#open "camlwin";;
#open "g_global";;
#open "g_button";;
#open "g_scroll";;
#open "g_html_i";;
#open "g_html_d";;


let debug = false;;


let line_delta_mul = 13;;
let line_delta_div = 10;;
let delta_0 = 5;;


let without_suffix String =
  let rec without_suffix_loop Pos Len =
    if Pos=Len
    then String
    else if (nth_char String Pos)=`.`
         then (sub_string String 0 Pos)
         else without_suffix_loop (Pos+1) Len
  in
    without_suffix_loop 0 (string_length String)
;;







let extext_first_line exText =
  let Height  = to_real_coord exText.extx_height 
  and pos = exText.extx_scroll
  and nb_line = vect_length exText.extx_content in
    pos * nb_line / (scroll_course Height)
;;

let extext_update_scroll exText nu_line =
  let Height  = to_real_coord exText.extx_height 
  and pos = exText.extx_scroll
  and nb_line = vect_length exText.extx_content in
    exText.extx_scroll <- nu_line * (scroll_course Height) / nb_line 
;;




let ex_next_line y =
  let line_height = snd (text_size "Ap") in
    y - (line_delta_mul*line_height/line_delta_div)
;;



let draw_formated_str fstring =
  set_font fstring.f_type fstring.f_att fstring.f_size;
  if is_color_look () 
  then set_color fstring.f_color
  else set_color black;
  draw_string fstring.f_string
;;


let extext_width exText =
  let Width  = to_real_coord exText.extx_width 
  and dx=(scroll_width + 2*short_space) in
    Width - dx - delta_0
;;

let draw_gr_extext exText =
  if exText.extx_window.win_state = Created
  then
  (
    set_draw_window exText.extx_window.win_id;
    let Left   = to_real_coord exText.extx_left
    and Top    = to_real_coord exText.extx_top
    and Width  = to_real_coord exText.extx_width
    and Height = to_real_coord exText.extx_height 
    and len = vect_length exText.extx_content in
      let y = ref Top in
      let rec draw_fstringlist fList =
           match fList with
             []   -> ()
           | a::b -> draw_formated_str a;
                     draw_fstringlist b
      in  
        let dx=(scroll_width + 2*short_space) in
          set_color (backcolor ());
          fill_rect Left (Top - Height) Width Height;
          set_color black;
          std_col_draw_button Left Top (Width - dx ) Height Down;
          draw_vscrollbar (Left+Width-dx+short_space) Top
                          Height  exText.extx_scroll;
          set_clip_area Left (Top - Height) (Width - dx - 1) (Height - 1);

          let i =ref (extext_first_line exText) in
            while(!i < len & !y >Top-Height)
            do
            (
              moveto (exText.extx_content.(!i).l_indent + delta_0 + Left) !y;
              if exText.extx_content.(!i).l_line
              then 
              (
                let x = delta_0 + Left in
                  if is_color_look ()
                  then
                  (
                    moveto x !y;
                    set_color black;
                    lineto (x+Width-2*delta_0) !y;
                    moveto x (!y-1);
                    set_color white;
                    lineto (x+Width-2*delta_0) (!y-1)
                  )
                  else
                  (
                    moveto x !y;
                    set_color black;
                    lineto (x+Width-2*delta_0) !y
                  );
                y := !y - 2*delta_0;
                y := ex_next_line !y;
                moveto (exText.extx_content.(!i).l_indent + delta_0 + Left)
                       !y
              );
              draw_fstringlist exText.extx_content.(!i).l_content;
              y := ex_next_line !y;
              i := !i + 1
            )
            done;

        set_color black;
        set_font Default_font Normal_font Size1_font;
        set_clip_area 0 0 (screen_width ()) (screen_height ());
        gr_flush ()
  )
;;



let extext_load_html exText FileName =
  if debug
  then 
  (
    print_string ("extext_load_html: " ^ FileName);
    print_newline ()
  );
  let file = open_in  FileName in
    let html = html_interpreter file in
      let f_lines = HtmlList_to_Formated html (extext_width exText) in
        exText.extx_anchors <- snd f_lines;
        exText.extx_content <- fst f_lines;
        exText.extx_name <- FileName;
  close_in file;
  html
;;


let extext_load_hlp exText FileName =
  if debug
  then 
  (
    print_string ("extext_load_hlp: " ^ FileName);
    print_newline ()
  );
  let file = open_in_bin ((without_suffix FileName)^".hlp") in
    exText.extx_anchors <- (input_value file : (AnchorType * int) list);
    exText.extx_content <- (input_value file : Formated_line vect);
    exText.extx_name <- FileName;
    exText.extx_scroll <- 0;
  close_in file
;;




(****************************************************************************)
(*                                                                          *)
(****************************************************************************)
let file_exist FileName =
  try
  (
    let obj=open_in FileName in
      close_in obj;
    true
  )
  with Sys_error v -> false
;;




(****************************************************************************)
(*                                                                          *)
(****************************************************************************)
let earlier FileName1 FileName2 =
  let time1=file_modif FileName1
  and time2=file_modif FileName2 in
    time1.s_1_1_1970 < time2.s_1_1_1970
;;



let extext_load exText FileName =
  exText.extx_scroll <- 0;
  let file = without_suffix FileName in
    match (file_exist (file ^".hlp"), file_exist (file ^".html")) with
      (true, true) -> if earlier  (file ^".hlp") (file ^".html")
                      then extext_load_html exText (file ^ ".html") 
                      else
                      (
                        extext_load_hlp exText (file ^ ".hlp");
                        []
                      )
    | (true, false) -> extext_load_hlp exText (file ^ ".hlp");
                       []
    | (false, true) -> extext_load_html exText (file ^ ".html") 
    | (false, false) -> []
;;


let extext_save exText FileName =
  let file = open_out_bin ((without_suffix FileName)^".hlp") in
    output_value file exText.extx_anchors;
    output_value file exText.extx_content;
  close_out file
;;






let extext_goto_anchor exText Label =
  if debug
  then 
  (
    print_string ("extext_goto_anchor: " ^ Label);
    print_newline ()
  );
  let rec goto_loop List =
    match List with
      []   -> exText.extx_scroll <- 0
    | x::y -> let anchor = fst x in
              if anchor.AnchorType = NAME
              then if anchor.AnchorFile = Label
                   then extext_update_scroll exText (max 0 ((snd x)-1))
                   else goto_loop y
              else goto_loop y
  in
    if Label=""
    then exText.extx_scroll <- 0
    else goto_loop exText.extx_anchors;
    draw_gr_extext exText
;;











let search_diese Str =
  let len = string_length Str in
    let rec sloop pos =
      if pos = len
      then -1
      else if nth_char Str pos =`#`
           then pos
           else sloop (pos+1)
    in
     let pos = sloop 0 in
       if pos = -1
       then (Str,"")
       else let fst_str = sub_string Str 0 pos 
            and snd_str = sub_string Str (pos+1) (len-pos-1) in
              (fst_str, snd_str)
;;




let goto_anchor exText nuLine nuAnchor =
  let rec search_anchor List =
    match List with
     [] -> { AnchorType=NAME; AnchorFile=""; AnchorName=""}
    | x::y -> if snd x = nuLine
              then fst x
              else search_anchor y
  in
    let anchor = search_anchor exText.extx_anchors in
     let res = search_diese anchor.AnchorFile in
       if debug
       then 
       (
         print_string ("extext_anchor: file=" ^ (fst res) ^ 
                       "; anchor=" ^ (snd res));
         print_newline ()
       );
       let res = exText.extx_callback res in
         if fst res = ""
         then extext_goto_anchor exText (snd res)
         else ( extext_load exText (fst res); ());
         extext_goto_anchor exText (snd res)
;;




let callback_extext exText Mouse_x Mouse_y =
  let Left   = to_real_coord exText.extx_left
  and Top    = to_real_coord exText.extx_top
  and Width  = to_real_coord exText.extx_width
  and Height = to_real_coord exText.extx_height 
  and len = vect_length exText.extx_content 
  and i =ref (extext_first_line exText) in
    let y = ref Top in
    let rec draw_formated_str fstring =
      set_font fstring.f_type fstring.f_att fstring.f_size
    and draw_fstringlist fList =
           match fList with
             []   -> ()
           | a::b -> draw_formated_str a;
                     draw_fstringlist b
    and x_pos flist old_x = 
           match flist with
             []   -> ()
           | a::b -> draw_formated_str a;
                     let dx = fst (text_size a.f_string) in
                       if old_x < Mouse_x & Mouse_x < old_x + dx
                       then 
                       (
                         if debug
                         then
                         (
                           print_string ("found on:"^a.f_string);
                           print_newline ()
                         );
                          if a.f_att = Underline
                          then goto_anchor exText !i 0     
                       )
                       else x_pos b (old_x + dx)
    in  
      let dx=(scroll_width + 2*short_space) in
            while(!i < len & !y >Top-Height)
            do
            (
              if exText.extx_content.(!i).l_line
              then 
              (
                 y := !y - 2*delta_0;
                 y := ex_next_line !y
              );
              draw_fstringlist exText.extx_content.(!i).l_content;
              let bottom = !y 
              and top = !y + (fst (text_size "Ap")) in
                if Mouse_y < top & Mouse_y > bottom
                then
                (
                  x_pos exText.extx_content.(!i).l_content 
                        (exText.extx_content.(!i).l_indent + delta_0 + Left);
                  y := Top-Height
                )
                else y := ex_next_line !y;
              i := !i + 1
            )
            done
;;


let gr_extext_callback exText Event =
  let Left   = to_real_coord exText.extx_left
  and Top    = to_real_coord exText.extx_top
  and Width  = to_real_coord exText.extx_width
  and Height = to_real_coord exText.extx_height 
  and dx=(scroll_width + 2*short_space) 
  and len = vect_length exText.extx_content in
    let nb_line = Height / line_height in
    let scrollbar={
                     sb_window = exText.extx_window;
                     sb_left = Left + Width + short_space - dx;
                     sb_top = Top;
                     sb_length = Height;
                     sb_pos = exText.extx_scroll;
                     sb_dir = Vertical;
                     sb_delta = 10;
                     sb_callback = do_nothing
                   } in
      if gr_vscrollbar_callback scrollbar Event
      then
      (
        exText.extx_scroll <- scrollbar.sb_pos;
        draw_gr_extext exText;
        true
      )
      else if Event.id_event = Button_down
           then
           (
             let mouse_coord={x=Event.mouse_x; y=Event.mouse_y}
             and List_area={x1=Left;
                            y1=Top-Height;
                            x2=Left+Width-dx;
                            y2=Top} in
              if (inside mouse_coord List_area )
              then
              (
                callback_extext exText Event.mouse_x Event.mouse_y;
                set_color black;
                set_font Default_font Normal_font Size1_font;
                true
              )
              else false
           )
           else false
;;



let extext_empty_callback x =
  x
;;





