#open "windows";;
#open "camlwin";;

#open "g_global";;
#open "g_button";;
#open "g_text";;
#open "g_prompt";;
#open "g_mloop";;





let gr_edit_height = 75;;
let gr_edit_width = 200;;


let gr_edit_window_def = 
{
  win_id = undef_window;
  win_top = (screen_height() + (to_real_coord gr_edit_height))/2;
  win_left = (screen_width() - (to_real_coord gr_edit_width))/2;
  win_width = gr_edit_width;
  win_height = gr_edit_height;
  win_name = "Edit";
  win_state=Destroyed
};;

let gr_edit_OK =
{
  bt_window=gr_edit_window_def;
  bt_left=((gr_edit_width-25)/2);
  bt_top=15;
  bt_width=25;
  bt_height=12;
  bt_name=string_type "Ok";
  bt_state=Up;
  bt_callback= do_nothing
};;


let gr_edit_text = make_text
{
  t_window=gr_edit_window_def;
  t_left= 5;
  t_top=gr_edit_height - 10;
  t_width=gr_edit_width - 10;
  t_height=gr_edit_height - 27;
  t_name=lines_of_string "";
  t_state=Edited;
  t_scroll=Dscroll
};;


let gr_edit_prompt=
{
  pt_window=gr_edit_window_def;
  pt_left=5;
  pt_top=gr_edit_height - 2;
  pt_name="Name:"
};;



let gr_edit_window = 
{
  win_def=gr_edit_window_def;
  win_objects=[g_button gr_edit_OK;
               g_text   gr_edit_text;
               g_prompt gr_edit_prompt
              ];
  time_callback = do_nothing;
  resize_callback = do_nothing;
  help_file = "";
  miscellaneous = [| |]
};;




let rec gr_close_edit Obj_graph Event =
  erase_window gr_edit_window.win_def
;;


gr_edit_OK.bt_callback <- gr_close_edit;;


(***************************************************************************)
(*                                                                         *)
(* gr_edit_string: string -> string -> string;;                           *)
(*                                                                         *)
(***************************************************************************)
let rec edit Prompt Name =
  gr_edit_prompt.pt_name <- Prompt;
  gr_init_text gr_edit_text;
  gr_edit_text.tx_state <- Edited;
  gr_edit_text.tx_name <- lines_of_string Name;
  gr_edit_text.tx_line <- ((vect_length gr_edit_text.tx_name) - 1);
  gr_edit_text.tx_cursor <- string_length gr_edit_text.tx_name.(gr_edit_text.tx_line);
  block_loop gr_edit_window;
  string_of_lines gr_edit_text.tx_name
;;


