#open "windows";;
#open "camlwin";;
#open "g_global";;

(*
type event_type =
    Button_down			(* A mouse button is pressed *)
  | Button_up			(* A mouse button is released *)
  | Key_pressed			(* A key is pressed *)
  | Mouse_motion		(* The mouse is moved *)
  | Poll			(* Don't wait; return immediately *)
  | Redraw
;;

type event =
  { win     : int;
    id_event: int;
    mouse_x : int;		(* X coordinate of the mouse *)
    mouse_y : int;		(* Y coordinate of the mouse *)
    button  : bool;		(* true if a mouse button is pressed *)
    key     : int }		(* the character for the key pressed *)
;;
*)

let debug_channel=  ref std_out;;

let Channel () = !debug_channel;;
let init_debug () = debug_channel := (open_out "msg.ml");;


let output_event Event =
  output_string (Channel ())";\n  id_event = ";
  output_string (Channel ())(match Event.id_event with
                           Button_down  -> "Button_down"
                         | Button_up    -> "Button_up"
                         | Key_pressed  -> "Key_pressed"
                         | Mouse_motion -> "Mouse_motion"
                         | Poll         -> "Poll"
                         | Redraw       -> "Redraw"
                         | Close        -> "Close"
                         | Size         -> "Size"
                         | Time         -> "Time"
                        );
  output_string (Channel ())";\n  mouse_x = ";
  output_string (Channel ())(string_of_int Event.mouse_x);
  output_string (Channel ())";\n  mouse_y = ";
  output_string (Channel ())(string_of_int Event.mouse_y);
  output_string (Channel ())";\n  button = ";
  output_string (Channel ())(match Event.button with
                           true -> "true"
                         | _ -> "false"
                        );
  output_string (Channel ())";\n  key = ";
  output_string (Channel ())(string_of_int Event.key);
  if Event.key >= 0x20 & Event.key<0x7f
  then output_string (Channel ())("  (* " ^
                                  (char_for_read (char_of_int Event.key)) ^
                                  " *)");
  output_string (Channel ())";\n};;\n";
  flush (Channel ())
;;


let output_action Obj Result =
  (
    match Obj with
      g_user   User     -> output_string (Channel ()) ("g_user      " )
    | g_extext ExText   -> output_string (Channel ()) ("g_extext    " )
    | g_area   Area     -> output_string (Channel ()) ("g_area      " )
    | g_text   Text     -> output_string (Channel ()) ("g_text      " )
    | g_list   List     -> output_string (Channel ()) ("g_list      " )
    | g_item   Item     -> output_string (Channel ()) ("g_item      " )
    | g_menu   Menu     -> output_string (Channel ()) ("g_menu      " )
    | g_line   Line     -> output_string (Channel ()) ("g_line      " )
    | g_radio  Radio    -> output_string (Channel ()) ("g_radio     " )
    | g_shell  Shell    -> output_string (Channel ()) ("g_shell     " )
    | g_prompt Prompt   -> output_string (Channel ()) ("g_prompt    " )
    | g_bitmap Bitmap   -> output_string (Channel ()) ("g_bitmap    " )
    | g_button Button   -> output_string (Channel ()) ("g_button    " )
    | g_string String   -> output_string (Channel ()) ("g_string    " )
    | g_grpbut Grpbut   -> output_string (Channel ()) ("g_grpbut    " )
    | g_grprad Grprad   -> output_string (Channel ()) ("g_grprad    " )
    | g_toolbar Toolb   -> output_string (Channel ()) ("g_toolbar   " )
    | g_helpbar Helpb   -> output_string (Channel ()) ("g_helpbar   " )
    | g_ellipse Ellip   -> output_string (Channel ()) ("g_ellipse   " )
    | g_exprompt ExPt   -> output_string (Channel ()) ("g_exprompt  " )
    | g_scrollbar Scrol -> output_string (Channel ()) ("g_scrollbar " )
    | g_rectangle Rect  -> output_string (Channel ()) ("g_rectangle " )
  );

  output_string (Channel ())(match Result with
                               true -> "true\n"
                             | _ -> "false\n"
                            );
  flush (Channel ())
;;


