#open "windows";;
#open "camlwin";;

let gr_operating_system = host_system ();;

let gr_directory_separator = 
  match gr_operating_system with
    Unix -> "/"
  | _    -> "\\"
;;

let gr_screen_col = screen_color ();;


let gr_program_extention = 
  match gr_operating_system with
    Unix -> ""
  | _    -> ".exe"
;;

let gr_link_cmd OutputName ObjNames= 
  match gr_operating_system with 
    Unix -> "camlc -custom -o " ^ OutputName ^ 
            " unix.zo windows.zo camlwin.zo " ^ ObjNames ^ 
            " -lunix -lwin -lX11"
  | _    -> "camlc -o " ^ OutputName ^ 
            " camlwin.zo " ^ ObjNames
;;

let gr_compile_cmd FileName = "camlc -c " ^ FileName;;

let gr_caml_cmd = 
  match gr_operating_system with 
    Unix -> "camllight"
  | _    -> "caml"
;;

