#open "windows";;
#open "camlwin";;

#open "g_global";;
#open "g_scroll";;
#open "g_graph";;
#open "g_minput";;
#open "g_mloop";;



let ColorWin_def = 
{
  win_left     = 10;
  win_top      = 335;
  win_width    = 149;
  win_height   = 100;
  win_id       = undef_window;
  win_name     = "Design window";
  win_state    = Destroyed
};;

let colors_title = 
{
  expt_window = ColorWin_def;
  expt_left   = 64;
  expt_top    = 93;
  expt_name   = { f_type=Proportional_font; f_att =Italic; f_size =Size1_font; f_color =black; f_string = "Colors"}
};;

let color_blue =
{
  sb_window   = ColorWin_def;
  sb_left     = 132;
  sb_top      = 72;
  sb_length   = 50;
  sb_pos      = 0;
  sb_delta    = 10;
  sb_dir      = Vertical;
  sb_callback = do_nothing
};;

let color_green =
{
  sb_window   = ColorWin_def;
  sb_left     = 112;
  sb_top      = 72;
  sb_length   = 50;
  sb_pos      = 0;
  sb_delta    = 10;
  sb_dir      = Vertical;
  sb_callback = do_nothing
};;

let color_red =
{
  sb_window   = ColorWin_def;
  sb_left     = 89;
  sb_top      = 72;
  sb_length   = 50;
  sb_pos      = 0;
  sb_delta    = 10;
  sb_dir      = Vertical;
  sb_callback = do_nothing
};;

let color_pt_min = 
{
  pt_window   = ColorWin_def;
  pt_left     = 82;
  pt_top      = 72;
  pt_name     = "0%"
};;

let color_pt_max = 
{
  pt_window   = ColorWin_def;
  pt_left     = 77;
  pt_top      = 26;
  pt_name     = "100%"
};;

let color_pt_blue = 
{
  pt_window   = ColorWin_def;
  pt_left     = 129;
  pt_top      = 77;
  pt_name     = "Blue:"
};;

let color_pt_red = 
{
  pt_window   = ColorWin_def;
  pt_left     = 88;
  pt_top      = 77;
  pt_name     = "Red:"
};;

let color_pt_green = 
{
  pt_window   = ColorWin_def;
  pt_left     = 108;
  pt_top      = 77;
  pt_name     = "Green:"
};;

let color_bt_black = 
{
  bt_window   = ColorWin_def;
  bt_left     = 5;
  bt_top      = 72;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = bitmap_type (make_image (make_matrix 16 32 black));
  bt_callback = do_nothing
};;

let color_bt_white = 
{
  bt_window   = ColorWin_def;
  bt_left     = 40;
  bt_top      = 72;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = bitmap_type (make_image (make_matrix 16 32 white));
  bt_callback = do_nothing
};;

let color_bt_red = 
{
  bt_window   = ColorWin_def;
  bt_left     = 5;
  bt_top      = 56;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = bitmap_type (make_image (make_matrix 16 32 red));
  bt_callback = do_nothing
};;

let color_bt_yellow = 
{
  bt_window   = ColorWin_def;
  bt_left     = 40;
  bt_top      = 56;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = bitmap_type (make_image (make_matrix 16 32 yellow));
  bt_callback = do_nothing
};;

let color_bt_green = 
{
  bt_window   = ColorWin_def;
  bt_left     = 5;
  bt_top      = 40;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = bitmap_type (make_image (make_matrix 16 32 green));
  bt_callback = do_nothing
};;

let color_bt_cyan = 
{
  bt_window   = ColorWin_def;
  bt_left     = 40;
  bt_top      = 40;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = bitmap_type (make_image (make_matrix 16 32 cyan));
  bt_callback = do_nothing
};;

let color_bt_blue = 
{
  bt_window   = ColorWin_def;
  bt_left     = 5;
  bt_top      = 24;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = bitmap_type (make_image (make_matrix 16 32 blue));
  bt_callback = do_nothing
};;

let color_bt_magenta = 
{
  bt_window   = ColorWin_def;
  bt_left     = 40;
  bt_top      = 24;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = bitmap_type (make_image (make_matrix 16 32 magenta));
  bt_callback = do_nothing
};;

let color_close = 
{
  bt_window   = ColorWin_def;
  bt_left     = 112;
  bt_top      = 12;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Close";
  bt_callback = do_nothing
};;

let color_show = 
{
  re_window   = ColorWin_def;
  re_filled   = true;
  re_color    = black;
  re_point    = (24, 80);
  re_width    = 20;
  re_height   = 10
};;

let ColorWin = 
{
  win_def      = ColorWin_def;
  win_objects  = [
                  g_exprompt  colors_title;
                  g_scrollbar color_blue;
                  g_scrollbar color_green;
                  g_scrollbar color_red;
                  g_prompt    color_pt_blue;
                  g_prompt    color_pt_red;
                  g_prompt    color_pt_green;
                  g_prompt    color_pt_min;
                  g_prompt    color_pt_max;
                  g_button    color_bt_black;
                  g_button    color_bt_white;
                  g_button    color_bt_red;
                  g_button    color_bt_magenta;
                  g_button    color_bt_green;
                  g_button    color_bt_yellow;
                  g_button    color_bt_blue;
                  g_button    color_bt_cyan;
                  g_button    color_close;
                  g_rectangle color_show
                 ];
  time_callback  = do_nothing;
  resize_callback  = do_nothing;
  help_file = "";
  miscellaneous = [| |]
};;





let CloseWindow Obj Event =
  erase_window Obj.bt_window;
  true
;;

color_close.bt_callback <- CloseWindow;;




let ScrollCallback Obj Event =
  let len  = scroll_course (to_real_coord  color_red.sb_length) in
    let sred = color_red.sb_pos * 0xff / len
    and sgreen = color_green.sb_pos * 0xff / len
    and sblue = color_blue.sb_pos * 0xff / len in
      color_show.re_color <- rgb sred sgreen sblue;
      draw_gr_rectangle color_show;
  true
;;



color_red.sb_callback <- ScrollCallback;;
color_green.sb_callback <- ScrollCallback;;
color_blue.sb_callback <- ScrollCallback;;



let UpdateScroll () =
  let col = color_show.re_color in
    let sred = col lsr 16 
    and sgreen = (col lsr 8) land 0xff
    and sblue  = col land 0xff 
    and len = scroll_course (to_real_coord  color_red.sb_length) in
      color_red.sb_pos <- sred * len / 0xff;
      draw_gr_scrollbar color_red;
      color_green.sb_pos <- sgreen * len / 0xff;
      draw_gr_scrollbar color_green;
      color_blue.sb_pos <- sblue * len / 0xff;
      draw_gr_scrollbar color_blue
;;




let ButtonColor Obj Event =
  let img = image_of_melted Obj.bt_name in
    color_show.re_color <- pixel_image img 0 0;
    draw_gr_rectangle color_show;
    UpdateScroll ();
  true
;;

color_bt_black.bt_callback <- ButtonColor;;
color_bt_white.bt_callback <- ButtonColor;;
color_bt_red.bt_callback <- ButtonColor;;
color_bt_cyan.bt_callback <- ButtonColor;;
color_bt_blue.bt_callback <- ButtonColor;;
color_bt_yellow.bt_callback <- ButtonColor;;
color_bt_magenta.bt_callback <- ButtonColor;;
color_bt_green.bt_callback <- ButtonColor;;



let select_color col =
  color_show.re_color <- col;
  UpdateScroll ();
  
  block_loop ColorWin;

  color_show.re_color
;;