#open "windows";;
#open "camlwin";;

#open "g_global";;
#open "g_bitmap";;

let open_mono_draw_button left top width height state =
  let delta= match (width>20, height>20) with
               (true, true)   -> 10
             | (true, false)  -> height/2
             | (false, true)  -> width/2
             | (false, false) -> max (width/2) (height/2)
           in
    let x1= left+delta
    and y1= top-delta
    and x2= left+width-delta
    and y2= top-delta
    and x3= left+delta
    and y3= top-height+delta
    and x4= left+width-delta
    and y4= top-height+delta in
      set_color white;
      fill_arc x3 y3 delta delta 180 270;
      fill_arc x4 y4 delta delta 270 360;
      fill_arc x2 y2 delta delta 0 90;
      fill_arc x1 y1 delta delta 90 180;
      fill_rect (x3-delta) (y3+1) (x2-x3+2*delta+1) (y2-y3);
      fill_rect x1 (y3-delta) (x2-x3) (y2-y3+2*delta+1);

      set_color black;
      draw_arc x3 y3 delta delta 180 270;
      moveto x3 (top-height);
      lineto x4 (top-height);
      draw_arc x4 y4 delta delta 270 360;
      moveto (left+width) y4;
      lineto (left+width) y2;
      draw_arc x2 y2 delta delta 0 90;
      moveto x2 top;
      lineto x1 top;
      draw_arc x1 y1 delta delta 90 180;
      moveto left y1;
      lineto left y3;
      moveto (x3-1) (top-height-1);
      lineto x4 (top-height-1);
      draw_arc x4 y4 (delta+1) (delta+1) 270 360;
      moveto (left+width+1) y4;
      lineto (left+width+1) y2;

      match state with
        Up     ->
            ()
      | Down   ->
            let delta=delta-2 in
            fill_arc x3 y3 delta delta 180 270;
            fill_arc x4 y4 delta delta 270 360;
            fill_arc x2 y2 delta delta 0 90;
            fill_arc x1 y1 delta delta 90 180;
            fill_rect (x3-delta) (y3+1) (x2-x3+2*delta+1) (y2-y3);
            fill_rect x1 (y3-delta) (x2-x3) (y2-y3+2*delta+1)

      | Unused ->
            draw_arc x3 y3 delta delta 225 270;
            moveto x3 (top-height);
            lineto x4 (top-height);
            draw_arc x4 y4 delta delta 270 360;
            moveto (left+width) y4;
            lineto (left+width) y2;
            draw_arc x2 y2 delta delta 0 45;
            draw_arc x2 y2 delta delta 45 90;
            moveto x2 top;
            lineto x1 top;
            draw_arc x1 y1 delta delta 90 180;
            moveto left y1;
            lineto left y3;
            draw_arc x3 y3 delta delta 180 225
;;




let open_col_draw_button left top width height state =
    let delta=
          ( match (width>20, height>20) with
              (true, true)   -> 10
            | (true, false)  -> (height/2)
            | (false, true)  -> (width/2)
            | (false, false) -> (max (width/2)
                                     (height/2))
          ) in
      let x1= (left+delta)
      and y1= (top-delta)
      and x2= (left+width-delta)
      and y2= (top-delta)
      and x3= (left+delta)
      and y3= (top-height+delta)
      and x4= (left+width-delta)
      and y4= (top-height+delta) in
        match state with
          Up     ->
            set_color (backcolor ());
            fill_arc x3 y3 delta delta 180 270;
            fill_arc x4 y4 delta delta 270 360;
            fill_arc x2 y2 delta delta 0 90;
            fill_arc x1 y1 delta delta 90 180;
            fill_rect left y3 width (y1-y3);
            fill_rect x1 (top-height) (x2-x1) height;
            set_color black;
            draw_arc x3 y3 delta delta 225 270;
            moveto x3 (top-height);
            lineto x4 (top-height);
            draw_arc x4 y4 delta delta 270 360;
            moveto (left+width) y4;
            lineto (left+width) y2;
            draw_arc x2 y2 delta delta 0 45;
            set_color white;
            draw_arc x2 y2 delta delta 45 90;
            moveto x2 top;
            lineto x1 top;
            draw_arc x1 y1 delta delta 90 180;
            moveto left y1;
            lineto left y3;
            draw_arc x3 y3 delta delta 180 225

        | Down   ->
            set_color darkgrey;
            fill_arc x3 y3 delta delta 180 270;
            fill_arc x4 y4 delta delta 270 360;
            fill_arc x2 y2 delta delta 0 90;
            fill_arc x1 y1 delta delta 90 180;
            fill_rect left y3 width (y1-y3);
            fill_rect x1 (top-height) (x2-x1) height;
            set_color black;
            draw_arc x2 y2 delta delta 45 90;
            moveto x2 top;
            lineto x1 top;
            draw_arc x1 y1 delta delta 90 180;
            moveto left y1;
            lineto left y3;
            draw_arc x3 y3 delta delta 180 225;
            set_color white;
            draw_arc x3 y3 delta delta 225 270;
            moveto x3 (top-height);
            lineto x4 (top-height);
            draw_arc x4 y4 delta delta 270 360;
            moveto (left+width) y4;
            lineto (left+width) y2;
            draw_arc x2 y2 delta delta 0 45

        | Unused ->
            set_color black;
            draw_arc x3 y3 delta delta 225 270;
            moveto x3 (top-height);
            lineto x4 (top-height);
            draw_arc x4 y4 delta delta 270 360;
            moveto (left+width) y4;
            lineto (left+width) y2;
            draw_arc x2 y2 delta delta 0 45;
            draw_arc x2 y2 delta delta 45 90;
            moveto x2 top;
            lineto x1 top;
            draw_arc x1 y1 delta delta 90 180;
            moveto left y1;
            lineto left y3;
            draw_arc x3 y3 delta delta 180 225
;;




let motif_draw_button left top width height state =
  match state with
    Up  ->      set_color grey;
                moveto (left+width) top;
                lineto left top;
                lineto left (top-height);
                moveto (left+width-1) (top-1);
                lineto (left+1) (top-1);
                lineto (left+1) (top-height+1);
                set_color black;
                moveto left (top-height);
                lineto (left+width) (top-height);
                lineto (left+width) top;
                moveto (left+1) (top-height+1);
                lineto (left+width-1) (top-height+1);
                lineto (left+width-1) (top-1);
                set_color motifblue;
                fill_rect (left+2) (top-height+2) (width-3) (height-3)

    | Down ->   set_color black;
                moveto (left+width) top;
                lineto left top;
                lineto left (top-height);
                moveto (left+width-1) (top-1);
                lineto (left+1) (top-1);
                lineto (left+1) (top-height+1);
                set_color grey;
                moveto left (top-height);
                lineto (left+width) (top-height);
                lineto (left+width) top;
                moveto (left+1) (top-height+1);
                lineto (left+width-1) (top-height+1);
                lineto (left+width-1) (top-1);
                set_color darkblue;
                fill_rect (left+2) (top-height+2) (width-3) (height-3)

    | Unused -> set_color white;
                moveto (left+width) top;
                lineto left top;
                lineto left (top-height);
                lineto (left+width) (top-height);
                lineto (left+width) top
;;


let next_draw_button left top width height state =
  match state with
    Up  ->      set_color white;
                moveto (left+width) top;
                lineto left top;
                lineto left (top-height);
                set_color black;
                moveto left (top-height);
                lineto (left+width) (top-height);
                lineto (left+width) top;
                set_color nextgrey; 
                moveto (left+1) (top-height+1);
                lineto (left+width-1) (top-height+1);
                lineto (left+width-1) (top-1);
                set_color (backcolor ());
                fill_rect (left+2) (top-height+2) (width-4) (height-3)

    | Down ->   set_color black;
                moveto (left+width) top;
                lineto left top;
                lineto left (top-height);
                set_color grey;
                moveto left (top-height);
                lineto (left+width) (top-height);
                lineto (left+width) top;
                moveto (left+1) (top-height+1);
                lineto (left+width-1) (top-height+1);
                lineto (left+width-1) (top-1);
                set_color white;
                fill_rect (left+2) (top-height+2) (width-4) (height-3)

    | Unused -> set_color white;
                moveto (left+width) top;
                lineto left top;
                lineto left (top-height);
                lineto (left+width) (top-height);
                lineto (left+width) top
;;



let std_col_draw_button left top width height state =
  match state with
    Up  ->      set_color white;
                moveto (left+width) top;
                lineto left top;
                lineto left (top-height);
                set_color black;
                lineto (left+width) (top-height);
                lineto (left+width) top

    | Down ->   set_color black;
                moveto (left+width) top;
                lineto left top;
                lineto left (top-height);
                set_color white;
                lineto (left+width) (top-height);
                lineto (left+width) top

    | Unused -> set_color white;
                moveto (left+width) top;
                lineto left top;
                lineto left (top-height);
                lineto (left+width) (top-height);
                lineto (left+width) top
;;





let std_mono_draw_button left top width height state =
  set_color white;
  draw_rect (left+1) (top-height+1) (width-2) (height-2);
  set_color black;
  draw_rect left (top-height) width height;
  draw_rect (left+2) (top-height+2) (width-4) (height-4);
  set_color black;

  match state with
    Up  ->      moveto left (top-height+1);
                lineto (left+width-1) (top-height+1);
                lineto (left+width-1) (top-1);
                plot   (left+1) (top-1)

    | Down ->   moveto (left+width) (top-1);
                lineto (left+1) (top-1);
                lineto (left+1) (top-height);
                plot   (left+width-1) (top-height+1)

    | Unused -> ()
;;


let windows_draw_button left top width height state =
  set_color black;
  draw_rect left (top-height) width height;
  let left = left + 1
  and top  = top - 1
  and width = width - 2
  and height = height - 2 in
  match state with
    Up  ->      set_color white;
                moveto (left+width) top;
                lineto left top;
                lineto left (top-height);
                set_color darkgrey;
                lineto (left+width) (top-height);
                lineto (left+width) top

    | Down ->   set_color darkgrey;
                moveto (left+width) top;
                lineto left top;
                lineto left (top-height);
                set_color white;
                lineto (left+width) (top-height);
                lineto (left+width) top

    | Unused -> set_color white;
                moveto (left+width) top;
                lineto left top;
                lineto left (top-height);
                lineto (left+width) (top-height);
                lineto (left+width) top
;;





(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let draw_button left top width height state =
  match (get_gr_look()) with
      Std_color       -> std_col_draw_button left top width height state
    | Std_mono        -> std_mono_draw_button left top width height state
    | Open_look_color -> open_col_draw_button left top width height state
    | Open_look_mono  -> open_mono_draw_button left top width height state
    | Window_color    -> windows_draw_button left top width height state
    | Motif_color     -> motif_draw_button left top width height state
    | Next_color      -> next_draw_button left top width height state
    | _               -> std_col_draw_button left top width height state
;;





(*****************************************************************************)
(*  Draw the content (image or text) of the button Button                    *)
(*****************************************************************************)
let draw_gr_button_content Button =
  let width =to_real_coord Button.bt_width
  and height=to_real_coord Button.bt_height
  and top   =to_real_coord Button.bt_top
  and left  =to_real_coord Button.bt_left in
  match Button.bt_name with
    string_type str ->
      let x = fst (text_size str)
      and y = line_height in
        moveto (left+(width-x)/2) (top-(height+y)/2);
        draw_string str

  | bitmap_type img ->
      let Bitmap={ bm_window=Button.bt_window;
                   bm_left=0;
                   bm_top=0;
                   bm_bitmap=img;
                   bm_callback=do_nothing
                 }
      and Area={ x1=left;
                 y1=top-height;
                 x2=left+width;
                 y2=top
               } in
        draw_center_gr_bitmap Bitmap Area

  | int_type n ->
      let str=string_of_int n in
        let x = fst (text_size str)
        and y = line_height in
          moveto (left+(width-x)/2) (top- (height+y)/2);
          draw_string str

  | float_type a ->
      let str=string_of_float a in
        let x = fst (text_size str)
        and y = line_height in
          moveto (left+(width-x)/2) (top- (height+y)/2);
          draw_string str

  | bool_type b ->
      let str=match b with
                true  -> "true"
              | false -> "false" in
        let x = fst (text_size str)
        and y = line_height in
          moveto (left+(width-x)/2) (top- (height+y)/2);
          draw_string str
;;


(*****************************************************************************)
(*  Draw the button itself when the look is Open look                        *)
(*****************************************************************************)
let open_mono_draw_unfilled_gr_button Button =
  set_draw_window Button.bt_window.win_id;
  let width =to_real_coord Button.bt_width
  and height=to_real_coord Button.bt_height
  and top   =to_real_coord Button.bt_top
  and left  =to_real_coord Button.bt_left in
    open_mono_draw_button left top width height Button.bt_state;
    if Button.bt_state=Down then set_color white else set_color black;
    draw_gr_button_content Button
;;


(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let open_col_draw_unfilled_gr_button Button =
  set_draw_window Button.bt_window.win_id;
  let width =to_real_coord Button.bt_width
  and height=to_real_coord Button.bt_height
  and top   =to_real_coord Button.bt_top
  and left  =to_real_coord Button.bt_left in
    open_col_draw_button left top width height Button.bt_state;
    set_color black;
    draw_gr_button_content Button
;;



(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let motif_draw_unfilled_gr_button Button =
  set_draw_window Button.bt_window.win_id;
  let width =to_real_coord Button.bt_width
  and height=to_real_coord Button.bt_height
  and top   =to_real_coord Button.bt_top
  and left  =to_real_coord Button.bt_left in
    motif_draw_button left top width height Button.bt_state;
    set_color white;
    draw_gr_button_content Button
;;



(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let next_draw_unfilled_gr_button Button =
  set_draw_window Button.bt_window.win_id;
  let width =to_real_coord Button.bt_width
  and height=to_real_coord Button.bt_height
  and top   =to_real_coord Button.bt_top
  and left  =to_real_coord Button.bt_left in
    next_draw_button left top width height Button.bt_state;
    set_color black;
    draw_gr_button_content Button
;;

(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let std_col_draw_unfilled_gr_button Button =
  set_draw_window Button.bt_window.win_id;
  let width =to_real_coord Button.bt_width
  and height=to_real_coord Button.bt_height
  and top   =to_real_coord Button.bt_top
  and left  =to_real_coord Button.bt_left in
    std_col_draw_button left top width height Button.bt_state
;;


(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let std_mono_draw_unfilled_gr_button Button =
  set_draw_window Button.bt_window.win_id;
  let width =to_real_coord Button.bt_width
  and height=to_real_coord Button.bt_height
  and top   =to_real_coord Button.bt_top
  and left  =to_real_coord Button.bt_left in
    std_mono_draw_button left top width height Button.bt_state
;;


(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let windows_draw_unfilled_gr_button Button =
  set_draw_window Button.bt_window.win_id;
  let width =to_real_coord Button.bt_width
  and height=to_real_coord Button.bt_height
  and top   =to_real_coord Button.bt_top
  and left  =to_real_coord Button.bt_left in
    windows_draw_button left top width height Button.bt_state
;;






(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let draw_unfilled_gr_button Button =
  if Button.bt_window.win_state=Created
  then
  (
    match (get_gr_look()) with
        Std_color       -> std_col_draw_unfilled_gr_button Button
      | Std_mono        -> std_mono_draw_unfilled_gr_button Button
      | Open_look_color -> open_col_draw_unfilled_gr_button Button
      | Open_look_mono  -> open_mono_draw_unfilled_gr_button Button
      | Window_color    -> windows_draw_unfilled_gr_button Button
      | Motif_color     -> motif_draw_unfilled_gr_button Button
      | Next_color      -> next_draw_unfilled_gr_button Button
      | _               -> std_col_draw_unfilled_gr_button Button
  )
;;


(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let draw_gr_button Button =
  if Button.bt_window.win_state=Created
  then
  (
    set_draw_window Button.bt_window.win_id;
    let width =to_real_coord Button.bt_width
    and height=to_real_coord Button.bt_height
    and top   =to_real_coord Button.bt_top
    and left  =to_real_coord Button.bt_left in

      match (get_gr_look()) with
        Open_look_color -> open_col_draw_unfilled_gr_button Button
      | Open_look_mono  -> open_mono_draw_unfilled_gr_button Button
      | Motif_color     -> motif_draw_unfilled_gr_button Button
      | Next_color      -> next_draw_unfilled_gr_button Button
      | _               ->
          set_color (backcolor ());
          fill_rect left (top - height) width height;
          draw_unfilled_gr_button Button;
          set_color black;
          draw_gr_button_content Button
  )
;;









(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let gr_button_callback Button Event =
  let width =to_real_coord Button.bt_width
  and height=to_real_coord Button.bt_height
  and top   =to_real_coord Button.bt_top
  and left  =to_real_coord Button.bt_left in

  if (Event.id_event=Button_up) or (Event.id_event=Button_down)
  then (
    let mouse_coord={x=Event.mouse_x; y=Event.mouse_y} and
        Button_area={x1=left;
                      y1=top-height;
                      x2=left+width;
                      y2=top} in
      match (( inside mouse_coord Button_area ),
             Event.button,
             Button.bt_state) with
          (false, false, Down) -> ( Button.bt_state <- Up;
                                    draw_unfilled_gr_button Button;
                                    true
                                  )
        | (true, true, Up)     -> ( Button.bt_state <- Down;
                                    draw_unfilled_gr_button Button;
                                    true
                                  )
        | (true, false, Down)  -> ( Button.bt_state <- Up;
                                    draw_unfilled_gr_button Button;
                                    Button.bt_callback Button Event
                                  )
        | ( _ , _ , _ )        -> false
                           )
  else false;;

