#open "windows";;
#open "camlwin";;

#open "g_global";;





let icon_size = 32;;


let draw_gr_bitmap Bitmap =
  if Bitmap.bm_window.win_state=Created
  then
  (
    set_draw_window Bitmap.bm_window.win_id;
    let height =snd (image_size Bitmap.bm_bitmap) in
      draw_image Bitmap.bm_bitmap
                 (to_real_coord Bitmap.bm_left)
                 (to_real_coord (Bitmap.bm_top)-height)
  )
;;


let draw_center_gr_bitmap Bitmap Area =
  set_draw_window Bitmap.bm_window.win_id;
  let width  =fst (image_size Bitmap.bm_bitmap)
  and height =snd (image_size Bitmap.bm_bitmap) in
    let v_space=(((abs ( Area.y1 - Area.y2)) - height) /2)
    and h_space=(((abs ( Area.x1 - Area.x2)) - width) /2)
    and top=max Area.y1 Area.y2
    and left=min Area.x1 Area.x2 in
      draw_image Bitmap.bm_bitmap
               (left + h_space)
               (top - v_space - height)
;;


let gr_bitmap_callback Bitmap Event =
  let width  =fst (image_size Bitmap.bm_bitmap)
  and height =snd (image_size Bitmap.bm_bitmap)
  and left   =to_real_coord Bitmap.bm_left
  and top    =to_real_coord Bitmap.bm_top in
    let mouse_coord={x=Event.mouse_x; y=Event.mouse_y}
    and Bitmap_area={x1=left;
                     y1=top-height;
                     x2=left+width;
                     y2=top} in
      if (inside mouse_coord Bitmap_area )
      then Bitmap.bm_callback Bitmap Event
      else false;;



