#open "windows";;
#open "camlwin";;

#open "g_global";;




let rec draw_gr_area Area =
  if Area.ar_window.win_state=Created
  then
  (
    set_draw_window Area.ar_window.win_id;
    let Left = to_real_coord Area.ar_left
    and Top = to_real_coord Area.ar_top
    and Width = to_real_coord Area.ar_width
    and Height = to_real_coord Area.ar_height in
      if is_color_look ()
      then
      (
        set_color black;
        moveto Left Top;
        lineto (Left+Width) Top;
        lineto (Left+Width) (Top-Height);
        set_color white;
        lineto Left (Top-Height);
        lineto Left Top;

        set_color white;
        moveto (Left+1) (Top-1);
        lineto (Left+Width-2) (Top-1);
        lineto (Left+Width-2) (Top-Height+2);
        set_color black;
        lineto (Left+1) (Top-Height+2);
        lineto (Left+1) (Top-1)
      )
      else
      (
        set_color black;
        moveto Left Top;
        lineto (Left+Width) Top;
        lineto (Left+Width) (Top-Height);
        lineto Left (Top-Height);
        lineto Left Top
      );
      set_color (backcolor ());
      let size = (text_size Area.ar_name) in
        fill_rect (Left +5) (Top-(snd size)/2)
                  ((fst size)+10) (snd size);
        set_color black;
        moveto (Left+10) (Top-(snd size)/2);
        draw_string Area.ar_name
  )
;;
