#open "windows";;
#open "camlwin";;

#open "globdraw";;



let FuncWin_def =
{
  win_left     = 360;
  win_top      = 400;
  win_width    = 100;
  win_height   = 100;
  win_id       = gr_undef_window;
  win_name     = "Function list";
  win_state    = Destroyed
};;

let func_prompt =
{
  pt_window   = FuncWin_def;
  pt_left     = 23;
  pt_top      = 96;
  pt_name     = "Functions list"
};;

let func_close =
{
  bt_window   = FuncWin_def;
  bt_left     = 35;
  bt_top      = 14;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Close";
  bt_callback = gr_do_nothing
};;

let func_del =
{
  bt_window   = FuncWin_def;
  bt_left     = 3;
  bt_top      = 68;
  bt_width    = 20;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Del";
  bt_callback = gr_do_nothing
};;

let func_cfg =
{
  bt_window   = FuncWin_def;
  bt_left     = 3;
  bt_top      = 48;
  bt_width    = 20;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Edit";
  bt_callback = gr_do_nothing
};;

let func_list =
{
  li_window   = FuncWin_def;
  li_left     = 32;
  li_top      = 86;
  li_width    = 60;
  li_height   = 65;
  li_nu_item  = 0;
  li_1st_item = 0;
  li_scroll   = 0;
  li_items    = [| |];
  li_callback = gr_do_nothing
};;

let FuncWin =
{
  win_def      = FuncWin_def;
  win_objects  = [
                  g_prompt func_prompt;
                  g_button func_close;
                  g_button func_del;
                  g_button func_cfg;
                  g_list func_list
                 ];
  time_callback = gr_do_nothing;
  resize_callback = gr_do_nothing;
  help_file = "";
  miscellaneous = [| |]
};;



let CloseFunc Obj Event =
  gr_erase_window FuncWin.win_def;;

func_close.bt_callback <- CloseFunc;;


let UpdateFunc NameVect =
  func_list.li_items <- NameVect;
  if FuncWin.win_def.win_state=Created
  then
  (
    let current=get_current_window () in
      set_draw_window FuncWin.win_def.win_id;
      gr_draw_list func_list;
      set_draw_window current
  )
;;



let EditFunction Item Event =
  let callbacks = !callbacks_def in
    let n = func_list.li_nu_item in
      if vect_length func_list.li_items = 0 
      then false
      else
      (
        set_nth_elem callbacks
                     n
                     (gr_edit "Function:" (nth_elem callbacks n));
        callbacks_def := callbacks;
        true
      )
;;


let DelFunction Item Event =
  let n=func_list.li_nu_item in
    gr_list_del_item func_list n;
    gr_draw_list func_list;
    callbacks_def := del_nth_elem !callbacks_def n;
  true
;;

func_del.bt_callback <- DelFunction;;
func_cfg.bt_callback <- EditFunction;;




(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let EditCallback Name =
  let name= if Name=""
            then gr_input_string "Callback's name:" ""
            else Name
          in
    let exist=in_vect (FunctionsNames ()) name in
    if not fst exist
    then
    (
      let Text="let " ^ name ^ " Obj Event =\n " in
        add_callback (gr_edit "Callback:" Text);
        UpdateFunc (FunctionsNames ())
    )
    else
    (
      let call = !callbacks_def in
        callbacks_def := set_nth_elem call (snd exist)
                                      (gr_edit "Function:"
                                               (nth_elem call (snd exist)));
        UpdateFunc (FunctionsNames ())
    )
;;

