#open "windows";;
#open "camlwin";;






let WinExprompt_def = 
{
  win_left     = 10;
  win_top      = 335;
  win_width    = 116;
  win_height   = 96;
  win_id       = gr_undef_window;
  win_name     = "Design window";
  win_state    = Destroyed
};;

let font_helpbar = 
{
  hl_window   = WinExprompt_def;
  hl_help     = ""
};;

let font_pt_idname = 
{
  pt_window   = WinExprompt_def;
  pt_left     = 5;
  pt_top      = 84;
  pt_name     = "Id name:"
};;

let font_pt_name = 
{
  pt_window   = WinExprompt_def;
  pt_left     = 4;
  pt_top      = 70;
  pt_name     = "Name:"
};;

let font_idname = 
{
  st_window   = WinExprompt_def;
  st_left     = 30;
  st_top      = 88;
  st_width    = 75;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;

let font_name = 
{
  st_window   = WinExprompt_def;
  st_left     = 30;
  st_top      = 72;
  st_width    = 75;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;

let font_ok = 
{
  bt_window   = WinExprompt_def;
  bt_left     = 14;
  bt_top      = 24;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Ok";
  bt_callback = gr_do_nothing
};;

let font_cancel = 
{
  bt_window   = WinExprompt_def;
  bt_left     = 72;
  bt_top      = 24;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Cancel";
  bt_callback = gr_do_nothing
};;

let font_color = 
{
  bt_window   = WinExprompt_def;
  bt_left     = 22;
  bt_top      = 48;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Color";
  bt_callback = gr_do_nothing
};;

let font_font = 
{
  bt_window   = WinExprompt_def;
  bt_left     = 60;
  bt_top      = 48;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Font";
  bt_callback = gr_do_nothing
};;

let font_area = 
{
  ar_window = WinExprompt_def;
  ar_name   = "Attributes";
  ar_left   = 14;
  ar_top    = 56;
  ar_width  = 81;
  ar_height = 26
};;

let font_title = 
{
  expt_window = WinExprompt_def;
  expt_left   = 30;
  expt_top    = 93;
  expt_name   = { f_type=Proportional_font; f_att =Italic; f_size =Size2_font; f_color =black; f_string = "ExPrompt Configuration"}
};;

let cfg_exprompt = 
{
  win_def      = WinExprompt_def;
  win_objects  = [
                  g_helpbar   font_helpbar;
                  g_prompt    font_pt_idname;
                  g_prompt    font_pt_name;
                  g_string    font_name;
                  g_string    font_idname;
                  g_button    font_ok;
                  g_button    font_cancel;
                  g_button    font_color;
                  g_button    font_font;
                  g_area      font_area;
                  g_exprompt  font_title
                 ];
  time_callback  = gr_do_nothing;
  resize_callback  = gr_do_nothing;
  help_file = "";
  miscellaneous = [| |]
};;









let font_save = 
{
  expt_window = WinExprompt_def;
  expt_left   = 52;
  expt_top    = 93;
  expt_name   = { f_type=Proportional_font; 
                  f_att =Italic; 
                  f_size =Size2_font; 
                  f_color =black; 
                  f_string = "ExPrompt Configuration" }
};;




let font_result = 
{
  expt_window = WinExprompt_def;
  expt_left   = 52;
  expt_top    = 93;
  expt_name   = { f_type=Proportional_font; 
                  f_att =Italic; 
                  f_size =Size2_font; 
                  f_color =black; 
                  f_string = "ExPrompt Configuration" }
};;

let font_id_save = ref "";;



let font_init exPrompt IdName =
  font_save.expt_name.f_type <- exPrompt.expt_name.f_type;
  font_save.expt_name.f_att  <- exPrompt.expt_name.f_att;
  font_save.expt_name.f_size <- exPrompt.expt_name.f_size;
  font_save.expt_name.f_color <- exPrompt.expt_name.f_color;
  font_save.expt_name.f_string <- exPrompt.expt_name.f_string;
  font_id_save := IdName;
  font_name.st_name <- exPrompt.expt_name.f_string;
  font_idname.st_name <- IdName;
  font_name.st_cursor <-0;
  font_idname.st_cursor <-0;
  font_idname.st_1st_char <-0;
  font_name.st_1st_char <-0
;; 



let CancelCallback Obj Event =
  font_result.expt_name.f_type <- font_save.expt_name.f_type;
  font_result.expt_name.f_att  <- font_save.expt_name.f_att;
  font_result.expt_name.f_size <- font_save.expt_name.f_size;
  font_result.expt_name.f_color <- font_save.expt_name.f_color;
  font_result.expt_name.f_string <- font_save.expt_name.f_string;
  font_idname.st_name <- !font_id_save;
  gr_erase_window cfg_exprompt.win_def
;;


let OkCallback Obj Event =
  font_result.expt_name.f_string <- font_name.st_name;
  gr_erase_window cfg_exprompt.win_def
;;


let ChooseFontCallback Obj Event =
  let new_font = gr_select_font font_save.expt_name in
    font_result.expt_name.f_type <- new_font.f_type;
    font_result.expt_name.f_att  <- new_font.f_att;
    font_result.expt_name.f_size <- new_font.f_size;
  true
;;


font_ok.bt_callback <- OkCallback;;
font_cancel.bt_callback <- CancelCallback;;
font_font.bt_callback <- ChooseFontCallback;;



let ChooseColorCallback Obj Event =
  font_result.expt_name.f_color 
       <- gr_select_color font_result.expt_name.f_color;
  true
;;



font_color.bt_callback <- ChooseColorCallback;;
