#open "windows";;
#open "camlwin";;

#open "camldraw";;
#open "camlicon";;
#open "saveicon";;
#open "maindraw";;
#open "globdraw";;
#open "objdraw";;
#open "funcdraw";;


let ExecCamldraw Obj Event =
  gr_create_window CamldrawWin.win_def;
  if not !window_file_name=""
  then (gr_create_window DesignWin.win_def; () );
  true
;;

let ExecCamlicon Obj Event =
  gr_create_window CamliconWin.win_def;
  true
;;

let WinShell Obj Event =
  gr_create_window gr_shell.win_def;
  true
;;

let CloseCamldsgn Obj Event =
  let DoClose () =
    gr_erase_window CamldrawWin.win_def;
    gr_erase_window DesignWin.win_def;
    gr_erase_window FuncWin.win_def;
    gr_erase_window ObjectWin.win_def;
    true
  in
    if not !window_saved
    then
    (
      gr_warning ("The window " ^ !window_file_name ^ " isn't saved. Save it ?")
                [| {warn_name="Yes";
                    warn_callback=gr_warning1};
                   {warn_name="No";
                    warn_callback=gr_warning2};
                   {warn_name="Cancel";
                    warn_callback=gr_warning3}
                 |];
      match gr_warn_button () with
        gr_ans1 -> SaveWindow Obj Event;
                   DoClose ()
      | gr_ans2 -> DoClose ()
      | gr_ans3 -> false
    )
    else DoClose ()
;;



let SaveIconThenClose Obj Event =
  gr_close_warning Obj Event;
  SaveIcon Obj Event;
  gr_erase_window CamliconWin.win_def;;


let CloseIconWithoutSaving Obj Event =
  gr_close_warning Obj Event;
  gr_erase_window CamliconWin.win_def;;


let CloseIcon Obj Event =
  if !icon_modified
  then
  (
    gr_warning ("The modifications aren't saved. Save them ?")
               [| {warn_name="Yes"; warn_callback=SaveIconThenClose};
                  {warn_name="No"; warn_callback=CloseIconWithoutSaving};
                  {warn_name="Cancel"; warn_callback=gr_close_warning}
               |];
    true
  )
  else gr_erase_window CamliconWin.win_def;;


iconexit_file.it_callback <- CloseIcon;;
drawexit_file.it_callback <- CloseCamldsgn;;

