#open "windows";;
#open "camlwin";;
#open "printexc";;


#open "tracer";;



let width = 100;;
let height = 75;;

let Win_def = 
{
  win_left     = (screen_width () - (gr_to_real_coord width))/2;
  win_top      = (screen_height () + (gr_to_real_coord height))/2;
  win_width    = width;
  win_height   = height;
  win_id       = gr_undef_window;
  win_name     = "Choose Color";
  win_state    = Destroyed
};;

let graph = make_graph Win_def 5 70 90 50;;

let close_button = 
{
  bt_window   = Win_def;
  bt_left     = 17;
  bt_top      = 15;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Close";
  bt_callback = gr_do_nothing
};;


let add_button = 
{
  bt_window   = Win_def;
  bt_left     = 57;
  bt_top      = 15;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Add";
  bt_callback = gr_do_nothing
};;

let Win = 
{
  win_def      = Win_def;
  win_objects  = [
                  g_user      graph;
                  g_button    close_button;
                  g_button    add_button
                 ];
  time_callback   = gr_do_nothing;
  resize_callback = gr_do_nothing;
  help_file       = "";
  miscellaneous    = [| |]
};;

(*
let Close Obj Event =
  gr_erase_window Win.win_def;
  true;;
*)

close_button.bt_callback <- gr_quit_callback;;

let Add Obj Event =
  add_func graph [ (0,25); (10,20); (20,60); (30,70); (40,10) ] red;
  add_func graph [ (0,10); (10,24); (20,60); (30,15); (40,36); (50,10); (60,0) ] blue;
  add_func graph [ (0,30); (10,5); (20,6); (30,10); (40,-6); (50,-2); (60,5) ] green;
  add_func graph [ (-30,30); (-20,10); (-10,-5); (0,-10); (10,-16); (30,-20); (60,-36) ] yellow;
  graph.us_draw graph;
  true
;;

add_button.bt_callback <- Add;;

f gr_main_loop [ Win ];;



