#open "windows";;
#open "camlwin";;
#open "printexc";;
#open "sort";;

#open "address";;

type AddressType =
{
  mutable Name : string;
  mutable Surname : string;
  mutable Address : string;
  mutable Phone : string
};;

let Address = ref 
[| {
    Name = "Unknown";
    Surname = "";
    Address = "NoWhere";
    Phone = ""
} |];;

try 
  let file = open_in "address.val" in
    Address := ((input_value file): AddressType vect);
  close_in file
with _ -> Address := [| |];;

let Current = ref 0;;


let DrawTime Win Event =
  let t = get_time () in
    let h = if t.hour < 10 
            then "0" ^ (string_of_int t.hour) 
            else (string_of_int t.hour)
    and m = if t.minute < 10 
            then "0" ^ (string_of_int t.minute) 
            else (string_of_int t.minute)
    and s = if t.second < 10 
            then "0" ^ (string_of_int t.second) 
            else (string_of_int t.second) in
      address_helpbar.hl_help <- h ^ ":" ^ m ^ "-" ^ s;
      gr_draw_helpbar address_helpbar;
      gr_flush ();
      true
;;


gr_use_time_event 1;;
AddressWin.time_callback <- DrawTime;; 


address_quit.bt_callback <- gr_quit_callback;;

let UpdateAff () =
  address_name.st_name <- !Address.(!Current).Name;
  gr_draw_string address_name;
  address_surname.st_name <- !Address.(!Current).Surname;
  gr_draw_string address_surname;
  address_phone.st_name <- !Address.(!Current).Phone;
  gr_draw_string address_phone;
  address_address.tx_name <- gr_lines_of_string !Address.(!Current).Name;
  gr_draw_text address_address
;;


let AddCallback Obj Event =
  Address := concat_vect !Address 
              [|
                { Name = "Unknown";
                  Surname = "";
                  Address = "NoWhere";
                  Phone = "" }
              |];
  Current := (vect_length !Address)-1;
  UpdateAff ();
  true
;;
address_add.bt_callback <- AddCallback;;

let DelCallback Obj Event =
  let len = vect_length !Address in
    if len = 0
    then false
    else
    (
      let vect_bef = sub_vect !Address 0 !Current
      and vect_aft = sub_vect !Address (!Current+1) (len - !Current -1) in
        Address := concat_vect vect_bef vect_aft; 
        Current := max 0 (!Current - 1);
        UpdateAff ();
        true
    )
;;
address_del.bt_callback <- DelCallback;;

let ChangeCallback Obj Event =
  !Address.(!Current).Name <- address_name.st_name;
  !Address.(!Current).Surname <- address_surname.st_name;
  !Address.(!Current).Address <- gr_string_of_lines address_address.tx_name;
  !Address.(!Current).Phone <- address_phone.st_name;
  let file = open_out "address.val" in
    output_value file !Address;
  close_out file;
  true
;;
address_change.bt_callback <- ChangeCallback;;

let SearchCallback Obj Event =
  let len = vect_length !Address in
    let Result = make_vect len "" in
     let rec make_namevect pos =
       if pos = len
       then ()
       else ( Result.(pos) <- !Address.(pos).Name; make_namevect (pos+1) )
     and nu_name name pos =
       if pos = len 
       then 0
       else if !Address.(pos).Name = name
            then pos
            else nu_name name (pos+1)
     in
       make_namevect 0;     
       let res = gr_select "Select a name" (vect_of_list (sort lt_string (list_of_vect Result))) in
         Current := nu_name (snd res) 0;
         UpdateAff ();
  true
;;
address_search.bt_callback <- SearchCallback;;

let NextCallback Obj Event =
  let len = vect_length !Address in
    Current := !Current + 1;
    Current := !Current mod len;
    UpdateAff ();
    true
;;
address_next.bt_callback <- NextCallback;;


UpdateAff ();;

f gr_main_loop [AddressWin];;
