#open "windows";;
#open "camlwin";;

#open "sys";;
#open "printexc";;


#open "globdraw";;
#open "cfgdraw";;
#open "camldraw";;
#open "indraw";;
#open "movedraw";;
#open "savedraw";;
#open "objdraw";;
#open "funcdraw";;


#open "saveicon";;
#open "camlicon";;
#open "newicon";;
#open "icondraw";;





let do_nothing1 x = ();;


(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let rec CollectEventLoop Objs Event =
  let Coord={x=Event.mouse_x; y=Event.mouse_y} in
    match Objs with
      []  -> ()
    | x::y ->
       (
         match x with
           g_button Button ->
             (
               match (inside_button Button Coord) with
                 Out -> CollectEventLoop y Event
               | Place ->
                   let End=(move_object Button.bt_left
                                        Button.bt_top
                                        Button.bt_width
                                        Button.bt_height
                                        Coord) in
                     if Button.bt_left=End.x & Button.bt_top=End.y
                     then ConfigObject x
                     else
                       (
                         Button.bt_left <- End.x;
                         Button.bt_top <- End.y;
                         Button.bt_state <- Up;
                         window_saved := false;
                         gr_draw_window design_win.win_id
                       )
               | Resize ->
                   let End=(resize_object Button.bt_left
                                          Button.bt_top
                                          Button.bt_width
                                          Button.bt_height
                                          Coord) in
                     if Button.bt_width=End.x & Button.bt_height=End.y
                     then ConfigObject x
                     else
                       (
                         Button.bt_width <- End.x;
                         Button.bt_height <- End.y;
                         Button.bt_state <- Up;
                         window_saved := false;
                         gr_draw_window design_win.win_id
                       )
             )
         | g_string String ->
           (
             match (inside_string String Coord) with
               Out -> CollectEventLoop y Event
             | Place ->
                 let End=(move_object String.st_left
                                      String.st_top
                                      String.st_width
                                      (gr_to_win_coord (gr_text_height+4*gr_short_space))
                                      Coord) in
                   if String.st_left=End.x & String.st_top=End.y
                   then ConfigObject x
                   else
                   (
                     String.st_left <- End.x;
                     String.st_top <- End.y;
                     window_saved := false;
                     gr_draw_window design_win.win_id
                   )
             | Resize ->
                 let End=(width_object String.st_left
                                       String.st_top
                                       String.st_width
                                       (gr_to_win_coord (gr_text_height+4*gr_short_space))
                                       Coord) in
                   if String.st_width=End
                   then ConfigObject x
                   else
                   (
                     String.st_width <- End;
                     window_saved := false;
                     gr_draw_window design_win.win_id
                   )
           )
         | g_text Text ->
           (
             match (inside_text Text Coord) with
               Out -> CollectEventLoop y Event
             | Place ->
                 let End=(move_object Text.tx_left
                                      Text.tx_top
                                      Text.tx_width
                                      Text.tx_height
                                      Coord) in
                   if Text.tx_left=End.x & Text.tx_top=End.y
                   then ConfigObject x
                   else
                   (
                     Text.tx_left <- End.x;
                     Text.tx_top <- End.y;
                     window_saved := false;
                     gr_draw_window design_win.win_id
                   )
             | Resize ->
                 let End=(resize_object Text.tx_left
                                        Text.tx_top
                                        Text.tx_width
                                        Text.tx_height
                                        Coord) in
                   if Text.tx_width=End.x & Text.tx_height=End.y
                   then ConfigObject x
                   else
                   (
                     Text.tx_width <- End.x;
                     Text.tx_height <- End.y;
                     window_saved := false;
                     gr_draw_window design_win.win_id
                   )
           )
         | g_shell Shell ->
           (
             match (inside_shell Shell Coord) with
               Out -> CollectEventLoop y Event
             | Place ->
                 let End=(move_object Shell.sh_left
                                      Shell.sh_top
                                      Shell.sh_width
                                      Shell.sh_height
                                      Coord) in
                   if Shell.sh_left=End.x & Shell.sh_top=End.y
                   then ConfigObject x
                   else
                   (
                     Shell.sh_left <- End.x;
                     Shell.sh_top <- End.y;
                     window_saved := false;
                     gr_draw_window design_win.win_id
                   )
             | Resize ->
                 let End=(resize_object Shell.sh_left
                                        Shell.sh_top
                                        Shell.sh_width
                                        Shell.sh_height
                                        Coord) in
                   if Shell.sh_width=End.x & Shell.sh_height=End.y
                   then ConfigObject x
                   else
                   (
                     Shell.sh_width <- End.x;
                     Shell.sh_height <- End.y;
                     window_saved := false;
                     gr_draw_window design_win.win_id
                   )
           )
         | g_list List ->
           (
             match (inside_list List Coord) with
               Out -> CollectEventLoop y Event
             | Place ->
                 let End=(move_object List.li_left
                                      List.li_top
                                      List.li_width
                                      List.li_height
                                      Coord) in
                   if List.li_left=End.x & List.li_top=End.y
                   then ConfigObject x
                   else
                   (
                     List.li_left <- End.x;
                     List.li_top <- End.y;
                     window_saved := false;
                     gr_draw_window design_win.win_id
                   )
             | Resize ->
                 let End=(resize_object List.li_left
                                        List.li_top
                                        List.li_width
                                        List.li_height
                                        Coord) in
                   if List.li_width=End.x & List.li_height=End.y
                   then ConfigObject x
                   else
                   (
                     List.li_width <- End.x;
                     List.li_height <- End.y;
                     window_saved := false;
                     gr_draw_window design_win.win_id
                   )
           )
         | g_helpbar Helpbar ->
           (
             if (inside_helpbar Helpbar Coord)=Place
             then ConfigObject x
             else CollectEventLoop y Event
           )
         | g_toolbar Toolbar ->
           (
             if (inside_toolbar Toolbar Coord)=Place
             then ConfigObject x
             else CollectEventLoop y Event
           )
         | g_prompt Prompt ->
           (
             if (inside_prompt Prompt Coord)=Place
             then
               (
                 let End=(move_object Prompt.pt_left
                                      Prompt.pt_top
                                      (gr_to_win_coord(fst (text_size Prompt.pt_name)))
                                      (gr_to_win_coord gr_text_height)
                                      Coord) in
                   if Prompt.pt_left=End.x & Prompt.pt_top=End.y
                   then ConfigObject x
                   else
                   (
                     Prompt.pt_left <- End.x;
                     Prompt.pt_top <- End.y;
                     window_saved := false;
                     gr_draw_window design_win.win_id
                   )
               )
             else CollectEventLoop y Event
           )
         | g_radio Radio ->
           (
             if (inside_radio Radio Coord)=Place
             then
               (
                 let End=(move_object Radio.ra_left
                                      Radio.ra_top
                                      (gr_to_win_coord ((fst (text_size Radio.ra_name))+
                                                        gr_text_height+3*gr_short_space))
                                      (gr_to_win_coord gr_text_height)
                                      Coord) in
                   if Radio.ra_left=End.x & Radio.ra_top=End.y
                   then ConfigObject x
                   else
                   (
                     Radio.ra_left <- End.x;
                     Radio.ra_top <- End.y;
                     window_saved := false;
                     gr_draw_window design_win.win_id
                   )
               )
             else CollectEventLoop y Event
           )
         | g_scrollbar Scroll ->
           (
             let width= match Scroll.sb_dir with
                          Vertical -> gr_to_win_coord gr_scroll_width
                        | Horizontal -> Scroll.sb_length
             and height= match Scroll.sb_dir with
                           Vertical -> Scroll.sb_length
                         | Horizontal -> gr_to_win_coord gr_scroll_width in
             match (inside_scrollbar Scroll Coord) with
               Out -> CollectEventLoop y Event
             | Place ->
                 let End=(move_object Scroll.sb_left
                                      Scroll.sb_top
                                      width
                                      height
                                      Coord) in
                   if Scroll.sb_left=End.x & Scroll.sb_top=End.y
                   then ConfigObject x
                   else
                   (
                     Scroll.sb_left <- End.x;
                     Scroll.sb_top <- End.y;
                     window_saved := false;
                     gr_draw_window design_win.win_id
                   )
             | Resize ->
                 let End= match Scroll.sb_dir with
                            Horizontal ->
                              width_object Scroll.sb_left
                                           Scroll.sb_top
                                           width
                                           height
                                           Coord
                          | Vertical ->
                              height_object Scroll.sb_left
                                            Scroll.sb_top
                                            width
                                            height
                                            Coord in
                   if Scroll.sb_length=End
                   then ConfigObject x
                   else
                   (
                     Scroll.sb_length <- End;
                     window_saved := false;
                     gr_draw_window design_win.win_id
                   )
           )
         | g_bitmap Bitmap ->
           (
             if (inside_bitmap Bitmap Coord)=Place
             then
               (
                 let width  =fst (image_size Bitmap.bm_bitmap)
                 and height =snd (image_size Bitmap.bm_bitmap) in
                 let End=(move_object Bitmap.bm_left
                                      Bitmap.bm_top
                                      (gr_to_win_coord width)
                                      (gr_to_win_coord height)
                                      Coord) in
                   if Bitmap.bm_left=End.x & Bitmap.bm_top=End.y
                   then ConfigObject x
                   else
                   (
                     Bitmap.bm_left <- End.x;
                     Bitmap.bm_top <- End.y;
                     window_saved := false;
                     gr_draw_window design_win.win_id
                   )
               )
             else CollectEventLoop y Event
           )
         | g_grprad Grprad ->
           (
             match (inside_grprad Grprad Coord) with
               Out -> CollectEventLoop y Event
             | Place ->
                 let End=(move_object Grprad.ga_left
                                      Grprad.ga_top
                                      Grprad.ga_width
                                      Grprad.ga_height
                                      Coord) in
                   if Grprad.ga_left=End.x & Grprad.ga_top=End.y
                   then ConfigObject x
                   else
                   (
                     Grprad.ga_left <- End.x;
                     Grprad.ga_top <- End.y;
                     window_saved := false;
                     gr_draw_window design_win.win_id
                   )
             | Resize ->
                 let End=(resize_object Grprad.ga_left
                                        Grprad.ga_top
                                        Grprad.ga_width
                                        Grprad.ga_height
                                        Coord) in
                   if Grprad.ga_width=End.x & Grprad.ga_height=End.y
                   then ConfigObject x
                   else
                   (
                     Grprad.ga_width <- End.x;
                     Grprad.ga_height <- End.y;
                     window_saved := false;
                     gr_draw_window design_win.win_id
                   )
           )
         | g_grpbut Grpbut ->
           (
             match (inside_grpbut Grpbut Coord) with
               Out -> CollectEventLoop y Event
             | Place ->
                 let End=(move_object Grpbut.gb_left
                                      Grpbut.gb_top
                                      Grpbut.gb_width
                                      Grpbut.gb_height
                                      Coord) in
                   if Grpbut.gb_left=End.x & Grpbut.gb_top=End.y
                   then ConfigObject x
                   else
                   (
                     Grpbut.gb_left <- End.x;
                     Grpbut.gb_top <- End.y;
                     window_saved := false;
                     gr_draw_window design_win.win_id
                   )
             | Resize ->
                 let End=(resize_object Grpbut.gb_left
                                        Grpbut.gb_top
                                        Grpbut.gb_width
                                        Grpbut.gb_height
                                        Coord) in
                   if Grpbut.gb_width=End.x & Grpbut.gb_height=End.y
                   then ConfigObject x
                   else
                   (
                     Grpbut.gb_width <- End.x;
                     Grpbut.gb_height <- End.y;
                     window_saved := false;
                     gr_draw_window design_win.win_id
                   )
           )
         | g_line Line ->
           (
             match (inside_line Line Coord) with
               Out -> CollectEventLoop y Event
             | Place ->
                 let End=(move_object (fst Line.ln_point1)
                                      (snd Line.ln_point1)
                                      (abs ((fst Line.ln_point1) - (fst Line.ln_point2)))
                                      (abs ((snd Line.ln_point1) - (snd Line.ln_point2)))
                                      Coord) in
                   if Line.ln_point1=(End.x, End.y)
                   then ConfigObject x
                   else
                   (
                     Line.ln_point2 <- ((fst Line.ln_point2)-(fst Line.ln_point1)+End.x,
                                        (snd Line.ln_point2)-(snd Line.ln_point1)+End.y);
                     Line.ln_point1 <- (End.x,End.y);
                     window_saved := false;
                     gr_draw_window design_win.win_id
                   )
             | Resize ->
                 let End=(resize_object (fst Line.ln_point1)
                                        (snd Line.ln_point1)
                                        (abs ((fst Line.ln_point1) - (fst Line.ln_point2)))
                                        (abs ((snd Line.ln_point1) - (snd Line.ln_point2)))
                                        Coord) in
                   if (abs ((fst Line.ln_point1) - (fst Line.ln_point2)))=End.x &
                      (abs ((snd Line.ln_point1) - (snd Line.ln_point2)))=End.y
                   then ConfigObject x
                   else
                   (
                     Line.ln_point2 <- ((End.x+(fst Line.ln_point1)),
                                        ((snd Line.ln_point1)-End.y));
                     window_saved := false;
                     gr_draw_window design_win.win_id
                   )
           )

         | g_rectangle Rectangle ->
           (
             match (inside_rectangle Rectangle Coord) with
               Out -> CollectEventLoop y Event
             | Place ->
                 let End=(move_object (fst Rectangle.re_point)
                                      ((snd Rectangle.re_point)+Rectangle.re_height)
                                      Rectangle.re_width
                                      Rectangle.re_height
                                      Coord) in
                   if  Rectangle.re_point=(End.x, End.y-Rectangle.re_height)
                   then ConfigObject x
                   else
                   (
                     Rectangle.re_point <- (End.x,End.y-Rectangle.re_height);
                     window_saved := false;
                     gr_draw_window design_win.win_id
                   )
             | Resize ->
                 let End=(resize_object (fst Rectangle.re_point)
                                        ((snd Rectangle.re_point)+Rectangle.re_height)
                                        Rectangle.re_width
                                        Rectangle.re_height
                                        Coord) in
                   if Rectangle.re_width=End.x & Rectangle.re_height=End.y
                   then ConfigObject x
                   else
                   (
                     Rectangle.re_width <- End.x;
                     Rectangle.re_height <- End.y;
                     window_saved := false;
                     gr_draw_window design_win.win_id
                   )
           )

         | g_ellipse Ellipse ->
           (
             match (inside_ellipse Ellipse Coord) with
               Out -> CollectEventLoop y Event
             | Place ->
                 let End=(move_object ((fst Ellipse.el_center)-Ellipse.el_xray)
                                      ((snd Ellipse.el_center)+Ellipse.el_yray)
                                      (2*Ellipse.el_xray)
                                      (2*Ellipse.el_yray)
                                      Coord) in
                   if Ellipse.el_center=(End.x+Ellipse.el_xray,
                                         End.y-Ellipse.el_yray)
                   then ConfigObject x
                   else
                   (
                     Ellipse.el_center <- (End.x+Ellipse.el_xray,
                                           End.y-Ellipse.el_yray);
                     window_saved := false;
                     gr_draw_window design_win.win_id
                   )
             | Resize ->
                 let End=(resize_object ((fst Ellipse.el_center)-Ellipse.el_xray)
                                        ((snd Ellipse.el_center)+Ellipse.el_yray)
                                        (2*Ellipse.el_xray)
                                        (2*Ellipse.el_yray)
                                        Coord) in
                   if Ellipse.el_xray=(End.x/2) & Ellipse.el_yray=(End.y/2)
                   then ConfigObject x
                   else
                   (
                     Ellipse.el_xray <- (End.x/2);
                     Ellipse.el_yray <- (End.y/2);
                     window_saved := false;
                     gr_draw_window design_win.win_id
                   )
           )
         | g_area Area ->
           (
             match (inside_area Area Coord) with
               Out -> CollectEventLoop y Event
             | Place ->
                 let End=(move_object Area.ar_left
                                      Area.ar_top
                                      Area.ar_width
                                      Area.ar_height
                                      Coord) in
                   if Area.ar_left=End.x & Area.ar_top=End.y
                   then ConfigObject x
                   else
                   (
                     Area.ar_left <- End.x;
                     Area.ar_top <- End.y;
                     window_saved := false;
                     gr_draw_window design_win.win_id
                   )
             | Resize ->
                 let End=(resize_object Area.ar_left
                                        Area.ar_top
                                        Area.ar_width
                                        Area.ar_height
                                        Coord) in
                   if Area.ar_width=End.x & Area.ar_height=End.y
                   then ConfigObject x
                   else
                   (
                     Area.ar_width <- End.x;
                     Area.ar_height <- End.y;
                     window_saved := false;
                     gr_draw_window design_win.win_id
                   )
           )
         | g_extext ExText ->
           (
             match (inside_extext ExText Coord) with
               Out -> CollectEventLoop y Event
             | Place ->
                 let End=(move_object ExText.extx_left
                                      ExText.extx_top
                                      ExText.extx_width
                                      ExText.extx_height
                                      Coord) in
                   if ExText.extx_left=End.x & ExText.extx_top=End.y
                   then ConfigObject x
                   else
                   (
                     ExText.extx_left <- End.x;
                     ExText.extx_top <- End.y;
                     window_saved := false;
                     gr_draw_window design_win.win_id
                   )
             | Resize ->
                 let End=(resize_object ExText.extx_left
                                        ExText.extx_top
                                        ExText.extx_width
                                        ExText.extx_height
                                        Coord) in
                   if ExText.extx_width=End.x & ExText.extx_height=End.y
                   then ConfigObject x
                   else
                   (
                     ExText.extx_width <- End.x;
                     ExText.extx_height <- End.y;
                     window_saved := false;
                     gr_draw_window design_win.win_id
                   )
           )
         | g_exprompt exPrompt -> 
           (
             if (inside_exprompt exPrompt Coord)=Place
             then
               (
                 let End=(move_object exPrompt.expt_left
                                      exPrompt.expt_top
                                      (gr_to_win_coord(fst (text_size exPrompt.expt_name.f_string)))
                                      (gr_to_win_coord gr_text_height)
                                      Coord) in
                   if exPrompt.expt_left=End.x & exPrompt.expt_top=End.y
                   then ConfigObject x
                   else
                   (
                     exPrompt.expt_left <- End.x;
                     exPrompt.expt_top <- End.y;
                     window_saved := false;
                     gr_draw_window design_win.win_id
                   )
               )
             else CollectEventLoop y Event
           )
         | g_item Item -> CollectEventLoop y Event
         | g_menu Menu -> CollectEventLoop y Event
         | g_user usr -> CollectEventLoop y Event
       )
;;


let CollectEvent User Event =
  if Event.id_event=Button_down
  then
    (
      CollectEventLoop DesignWin.win_objects Event;
      true
    )
  else false
;;


