#open "windows";;
#open "camlwin";;


#open "confdraw";;
#open "camldraw";;
#open "globdraw";;
#open "objdraw";;
#open "funcdraw";;












(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let DelSimpleObject Obj =
  let n=which_object Obj DesignWin.win_objects in
    obj_def :=del_nth_elem !obj_def n;
    DesignWin.win_objects <- del_nth_elem DesignWin.win_objects n
;;




(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let DelItem NuMenu NuItem =
  let toolb=get_toolbar DesignWin.win_objects in
    let nb_items=vect_length toolb.tb_items.(NuMenu).mn_items
    and Items=toolb.tb_items.(NuMenu).mn_items in
      let s=sub_vect Items 0 NuItem
      and e=sub_vect Items (NuItem+1) (nb_items-NuItem-1) in
        toolb.tb_items.(NuMenu).mn_items <- concat_vect s e;
      let s=sub_vect !toolb_def.(NuMenu).items_def 0 NuItem
      and e=sub_vect !toolb_def.(NuMenu).items_def (NuItem+1) (nb_items-NuItem-1) in
        !toolb_def.(NuMenu).items_def <- concat_vect s e;
      window_saved := false
;;




(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let DelMenu NuMenu =
  let toolb=get_toolbar DesignWin.win_objects in
    let nb_menus=vect_length toolb.tb_items in
      let s=sub_vect toolb.tb_items 0 NuMenu
      and e=sub_vect toolb.tb_items (NuMenu+1) (nb_menus-NuMenu-1) in
        toolb.tb_items <- concat_vect s e;
      let s=sub_vect !toolb_def 0 NuMenu
      and e=sub_vect !toolb_def (NuMenu+1) (nb_menus-NuMenu-1) in
        toolb_def := concat_vect s e;
    window_saved := false
;;




(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let DelToolbar Toolb =
  let n=which_object (g_toolbar Toolb) DesignWin.win_objects in
    obj_def := del_nth_elem !obj_def n;
    toolb_def := [| |];
    DesignWin.win_objects <- del_nth_elem DesignWin.win_objects n
;;


(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let DelObject Obj =
  (
    match Obj with
      g_button  Button  -> DelSimpleObject Obj
    | g_grpbut  Grpbut  -> DelSimpleObject Obj
    | g_bitmap  Bitmap  -> DelSimpleObject Obj
    | g_menu    Menu    ->
        let Toolbar=get_toolbar DesignWin.win_objects in
          DelMenu (MenuPos Menu Toolbar)
    | g_toolbar Toolbar -> DelToolbar Toolbar
    | g_item    Item    ->
        let Toolbar = get_toolbar DesignWin.win_objects in
          let pos = ItemPos Item Toolbar in
            DelItem  (fst pos) (snd pos)
    | g_prompt  Prompt  -> DelSimpleObject Obj
    | g_line    Line    -> DelSimpleObject Obj
    | g_extext  ExText  -> DelSimpleObject Obj
    | g_exprompt ExPt   -> DelSimpleObject Obj
    | g_area    Area    -> DelSimpleObject Obj
    | g_rectangle Rect  -> DelSimpleObject Obj
    | g_ellipse Ellipse -> DelSimpleObject Obj
    | g_text    Text    -> DelSimpleObject Obj
    | g_shell   Shell   -> DelSimpleObject Obj
    | g_helpbar Help    -> DelSimpleObject Obj
    | g_string  String  -> DelSimpleObject Obj
    | g_list    List    -> DelSimpleObject Obj
    | g_scrollbar Scr   -> DelSimpleObject Obj
    | g_radio   Radio   -> DelSimpleObject Obj
    | g_grprad  Grprad  -> DelSimpleObject Obj
    | g_user    User    -> ()
  );
  gr_draw_window design_win.win_id;
  UpdateObject (id_name_vect !obj_def !toolb_def);
  UpdateFunc (FunctionsNames ())
;;
