#open "camlwin";;


type object_cfg_type =
{
  mutable id_name : string;
  mutable callback : string;
  mutable images_names :  string vect
};;

type toolbar_cfg_type =
{
  mutable menu_name : string;
  mutable items_def : (string * string) vect
};;



let obj_def = ref [ {id_name=""; callback=""; images_names=[||]} ];;
let toolb_def = ref [| {menu_name=""; items_def=[| ("","") |]} |];;
  toolb_def := [| |];;




(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let toolb_length () =
  let rec toolb_len_loop i pos =
    if pos = vect_length !toolb_def
    then i
    else toolb_len_loop (i+1+(vect_length !toolb_def.(pos).items_def))
                        (pos+1)
  in
    toolb_len_loop 0 0
;;



(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let id_name_vect CfgList ToolbVect =
  let rec objs_names CfgList Result =
    match CfgList with
      []   -> Result
    | x::y -> objs_names y (concat_vect Result [| x.id_name |])
  in
  let rec toolb_names Result i =
    if i>= vect_length ToolbVect
    then Result
    else toolb_names (concat_vect Result
                                  (concat_vect [| ToolbVect.(i).menu_name |]
                                               (map_vect fst ToolbVect.(i).items_def)
                                  )
                     )
                     (i+1)
  in
    concat_vect (objs_names CfgList [| |]) (toolb_names [| |] 0)
;;



(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let Wich_object Nu ObjList Toolbar =
  let rec toolb_search NuMenu NuItem i =
    if NuMenu>= vect_length Toolbar.tb_items
    then
    (
      let str="confdraw: NuMenu=" ^ (string_of_int NuMenu) ^
              " Len=" ^ (string_of_int (vect_length Toolbar.tb_items))
      in
        raise (Failure str)
    );

    if NuItem>=vect_length Toolbar.tb_items.(NuMenu).mn_items
    then toolb_search (NuMenu+1) (-1) i
    else
    (
      if i = 0
      then
      (
        if NuItem < 0
        then g_menu Toolbar.tb_items.(NuMenu)
        else g_item Toolbar.tb_items.(NuMenu).mn_items.(NuItem)
      )
      else toolb_search NuMenu (NuItem+1) (i-1)
    )
  in
  let rec objs_search ObjList i =
    if i=0
    then
    (
      if ObjList = []
      then toolb_search 0 (-1) i
      else hd ObjList
    )
    else
    (
      match (ObjList) with
        []   -> toolb_search 0 (-1) i
      | x::y -> objs_search y (i-1)
    )
  in
    objs_search ObjList Nu
;;




(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let callback_name_vect CfgList ToolbVect =
  let rec objs_names CfgList Result =
    match CfgList with
      []   -> Result
    | x::y -> objs_names y (concat_vect Result [| x.callback |])
  in
  let rec toolb_names Result i =
    if vect_length ToolbVect <= i
    then Result
    else toolb_names (concat_vect Result (map_vect snd ToolbVect.(i).items_def))
                     (i+1)
  in
    concat_vect (objs_names CfgList [| |]) (toolb_names [| |] 0)
;;



(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let images_name_vect CfgList =
  let rec images_names_loop CfgList Result =
    match CfgList with
      []   -> Result
    | x::y -> images_names_loop y (concat_vect Result x.images_names)
  in
    images_names_loop CfgList [| |]
;;


(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let add_object Name Callback Images =
  obj_def := !obj_def @ [ {id_name=Name;
                           callback=Callback;
                           images_names=Images } ]
;;





