#open "sys";;

#open "windows";;
#open "camlwin";;

#open "camlprog";;
#open "cfgprog";;
#open "linkprog";;




(****************************************************************************)
(*                                                                          *)
(****************************************************************************)
let file_exist FileName =
  try
  (
    let obj=open_in FileName in
      close_in obj;
    true
  )
  with Sys_error v -> false
;;


(****************************************************************************)
(*                                                                          *)
(****************************************************************************)
let Compile FileName =
  let suff = gr_suffix_only FileName in
    let cfg = GetConfig ("." ^ suff) in
    if cfg.suffix = ("." ^ suff)
    then
    (
      let execstr = cfg.compiler ^ " " ^ cfg.flags ^ " " ^ FileName in
        prog_help.hl_help <- ("Compiling file: " ^ execstr);
        gr_draw_helpbar prog_help;
        system execstr;
        prog_help.hl_help <- "";
        gr_draw_helpbar prog_help;
        let file=open_in (gr_camlwin_env ^ "camlwin.err") in
          let txt=input_file file in
            close_in file;
          if (string_length txt)>=2
          then
          (
            gr_edit ("Compile " ^ FileName ^ ":") txt;
            let file = open_out (gr_camlwin_env ^ "camlwin.err")in
            close_out file; (* Remove errors *)
            false
          )
          else true
    )
    else false
;;





(****************************************************************************)
(*                                                                          *)
(****************************************************************************)
let Link ExeName FilesNames =
  let nb_files=vect_length FilesNames in
  if cfglink_goal.ga_radio = 0
  then 
  ( (* make a program *)
    let nb_files=vect_length FilesNames
    and tmp_file=open_out "temp.mak" in
      for i=0 to (nb_files-1) do
      (
        let name=gr_without_suffix FilesNames.(i)
        and suff=gr_suffix_only FilesNames.(i) in
          let cfg = GetConfig ("." ^ suff) in
            if cfg.suffix = ("." ^ suff) & not suff = "html" & 
               not suff = "htm" & not suff = "mli"
            then
            (
               output_string tmp_file (name ^ cfg.goal_suffix ^ " ")
            )
      )
      done;
      close_out tmp_file;
      let txt=link_cmd (ExeName ^ program_extention) 
                       (cfglink_flags.st_name ^ " -files temp.mak")  in
        prog_help.hl_help <- ("Linking Project : " ^ txt);
        gr_draw_helpbar prog_help;
        system txt
  )
  else
  ( (* make a library *)
    let outname = gr_without_suffix FilesNames.(nb_files-1)
    and inname  = gr_without_suffix cfglink_tmpfile.st_name in
      prog_help.hl_help <- ("Moving " ^ outname ^ ".zo to " ^ 
                            inname ^ ".zo.");
      gr_draw_helpbar prog_help;
      rename (outname ^ ".zo") (inname ^ ".zo");
      let tmp_file=open_out "temp.mak" in
      for i=0 to (nb_files-2) do
      (
        let name=gr_without_suffix FilesNames.(i)
        and suf=gr_suffix_only FilesNames.(i) in
          if suf="ml" or suf="zo"
          then output_string tmp_file (name ^ ".zo  ")
      )
      done;
      output_string tmp_file (inname ^ ".zo  ");
      close_out tmp_file;
      let txt = "camllibr -o " ^ outname ^ ".zo -files temp.mak"  in
      prog_help.hl_help <- ("Build library: " ^ txt);
      gr_draw_helpbar prog_help;
      system txt
  );
  if cfglink_helpindex.ra_state
  then (* make an index file *)
  (
    let txt = "camlhelp -i " ^ !help_index_file ^ " outname.prj"  in
      prog_help.hl_help <- ("Build help index file: " ^ txt);
      gr_draw_helpbar prog_help;
      system txt;
      ()
  );
  if cfglink_helptitle.ra_state
  then (* uptade title numbers *)
  (

  );
  prog_help.hl_help <- "";
  gr_draw_helpbar prog_help;
  remove "temp.mak"; 
  let file=open_in (gr_camlwin_env ^ "camlwin.err") in
    let txt=input_file file in
      close_in file;
      if (string_length txt)>=2
      then
      (
        gr_edit ("Link " ^ ExeName ^ ":") txt;
        let file = open_out (gr_camlwin_env ^ "camlwin.err") in
        close_out file; (* empty file camlwin.err *)
        false
      )
      else true
;;




(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let earlier FileName1 FileName2 =
  let time1=file_modif FileName1
  and time2=file_modif FileName2 in
    time1.s_1_1_1970 < time2.s_1_1_1970
;;

let Make ExeName FilesNames =
  try
  (
    let nb_files=vect_length FilesNames in
        (* check time of .zo files and .ml files and compile when need *)
      for i=0 to (nb_files-1) do
        let name=gr_without_suffix FilesNames.(i)
        and suff=gr_suffix_only FilesNames.(i) in
          let cfg = GetConfig ("." ^ suff) in
            if cfg.suffix = ("." ^ suff) 
            then
            (
              if file_exist (name ^ cfg.goal_suffix)
              then if earlier (name ^ cfg.goal_suffix) (name ^ cfg.suffix)
                   then if not Compile FilesNames.(i)
                        then raise (Failure ("Can't compile file " ^ 
                                              FilesNames.(i)))
                        else ()
                   else ()
              else if not Compile FilesNames.(i)
                   then raise (Failure ("Can't compile file " ^ 
                                        FilesNames.(i)))
                   else ()
            )
            else raise (Failure ("I don't know how to handle file " ^ 
                                  FilesNames.(i)))
      done;

      Link ExeName FilesNames
  )
  with Failure v -> false
;;



(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let Build ExeName FilesNames =
  try
  (
    let nb_files=vect_length FilesNames in
        (* check time of .zo files and .ml files and compile when need *)
      for i=0 to (nb_files-1) do
        let name=gr_without_suffix FilesNames.(i)
        and suff=gr_suffix_only FilesNames.(i) in
          let cfg = GetConfig ("." ^ suff) in
            if cfg.suffix = ("." ^ suff)
            then
            (
              if not Compile FilesNames.(i)
              then raise (Failure ("Can't find file " ^ FilesNames.(i)))
              else ()
            )
            else raise (Failure ("I don't know how to handle file " ^ 
                                  FilesNames.(i)))
      done;

      Link ExeName FilesNames
  )
  with Failure v -> false
;;





(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let rec Clean ExeName FilesNames =
  let nb_files=vect_length FilesNames in
    for i=0 to (nb_files-1) do
      let name=gr_without_suffix FilesNames.(i)
      and suff=gr_suffix_only FilesNames.(i) in
        let cfg = GetConfig ("." ^ suff) in
          if cfg.suffix = ("." ^ suff) 
          then
          (
            prog_help.hl_help <- ("Remove file " ^ name ^ cfg.goal_suffix);
            gr_draw_helpbar prog_help;
            gr_flush();
            (
              try
                remove (name ^ cfg.goal_suffix)
              with _ -> ()
            );
            if suff = "ml"
            then ( Clean "" [| name ^ ".mli" |]; ())
          )
    done;
    prog_help.hl_help <- ("Remove file " ^ ExeName);
    gr_draw_helpbar prog_help;
    gr_flush();
    (
      try
       remove (ExeName ^ program_extention)
      with _ -> ()
    );
    prog_help.hl_help <- "";
    gr_draw_helpbar prog_help;
    gr_flush();
  true
;;





(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let NeedMake ExeName FilesNames =
  try
  (
    if not (file_exist (ExeName ^ program_extention))
    then raise (Failure ("Can't find file: " ^ ExeName));


    let nb_files=vect_length FilesNames in
        (* check time of .zo files and .ml files *)
      for i=0 to (nb_files-1) do
        let name=gr_without_suffix FilesNames.(i)
        and suff=gr_suffix_only FilesNames.(i) in
          let cfg = GetConfig ("." ^ suff) in
            if cfg.suffix = ("." ^ suff)
            then
            (
              if file_exist (name ^ cfg.goal_suffix)
              then if (earlier (name ^ cfg.goal_suffix) (name ^ cfg.suffix)) 
                   or (earlier (ExeName ^ program_extention)  (name ^ cfg.goal_suffix))
                   then raise (Failure ("File " ^ FilesNames.(i) ^ 
                                        " is not up to date."))
                   else ()
              else raise (Failure ("File " ^ FilesNames.(i) ^ 
                                   " is not up to date."))
           )
           else raise (Failure ("I don't know how to handle file " ^ 
                                 FilesNames.(i)))
      done;
      false
  )
  with Failure v -> true
;;






(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let Run ExeName FilesNames =
  let exec () =
    let str = ExeName ^ " " ^ cfglink_runflags.st_name in
      prog_help.hl_help <- ("Running: " ^ str);
      gr_draw_helpbar prog_help;
      system str;
      prog_help.hl_help <- "";
      gr_draw_helpbar prog_help
  in
  if NeedMake ExeName FilesNames
  then 
  (
     if Make ExeName FilesNames
     then exec ()
     else ()
  )
  else exec ();
  
  let file=open_in (gr_camlwin_env ^ "camlwin.err") in
    let txt=input_file file in
      close_in file;
      if string_length txt >=2
      then
      (
        gr_edit ("Execution filed stderr with :") txt;
        ()
      )
;;




(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let ToToplevel String =
  let file=open_out (gr_camlwin_env ^ "camlwin.in") in
    output_string file String;
    close_out file;
  let cmd=caml_cmd ^ " < " ^ gr_camlwin_env ^ "camlwin.in" in
  system cmd;
  let err_file=open_in (gr_camlwin_env ^ "camlwin.err")
  and out_file=open_in (gr_camlwin_env ^ "camlwin.out") in
    let txt=(input_file out_file) ^ (input_file err_file) in
      close_in err_file;
      close_in out_file;
      gr_edit ("Top level answer :")
                txt;
      ()
;;








