#open "windows";;
#open "camlwin";;



let cfg_color_def = 
{
  win_left     = 41;
  win_top      = 337;
  win_width    = 150;
  win_height   = 100;
  win_id       = gr_undef_window;
  win_name     = "Select a color";
  win_state    = Destroyed
};;

let color_idname =
{
  st_window   = cfg_color_def;
  st_left     = 37;
  st_top      = 40;
  st_width    = 75;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;

let color_prompt =
{
  pt_window   = cfg_color_def;
  pt_left     = 5;
  pt_top      = 37;
  pt_name     = "Id name:"
};;

let color_ok =
{
  bt_window   = cfg_color_def;
  bt_left     = 62;
  bt_top      = 25;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Ok";
  bt_callback = gr_do_nothing
};;

let color_help =
{
  hl_window   = cfg_color_def;
  hl_help     = "Press Ok when choosen"
};;

let color_title =
{
  pt_window   = cfg_color_def;
  pt_left     = 48;
  pt_top      = 95;
  pt_name     = "Choose a color"
};;

let color_buttons=
{
  gb_window=cfg_color_def;
  gb_top=82;
  gb_left=25;
  gb_width=100;
  gb_height=37;
  gb_delta=2;
  gb_btwidth=20;
  gb_btheight=15;
  gb_dir=Vertical;
  gb_button=0;
  gb_name=[|
           bitmap_type (make_image (make_matrix 20 20 black));
           bitmap_type (make_image (make_matrix 20 20 red));
           bitmap_type (make_image (make_matrix 20 20 green));
           bitmap_type (make_image (make_matrix 20 20 blue));
           bitmap_type (make_image (make_matrix 20 20 yellow));
           bitmap_type (make_image (make_matrix 20 20 cyan));
           bitmap_type (make_image (make_matrix 20 20 magenta));
           bitmap_type (make_image (make_matrix 20 20 white))
          |];
  gb_callback= gr_do_nothing
};;


let cfg_color =
{
  win_def      = cfg_color_def;
  win_objects  = [
                  g_string    color_idname;
                  g_prompt    color_prompt;
                  g_button    color_ok;
                  g_helpbar   color_help;
                  g_prompt    color_title;
                  g_grpbut    color_buttons
                 ];
  time_callback = gr_do_nothing;
  resize_callback = gr_do_nothing;
  help_file = "";
  miscellaneous = [| |]
};;




let which_color () =
  match color_buttons.gb_button with
    0 -> black
  | 1 -> red
  | 2 -> green
  | 3 -> blue
  | 4 -> yellow
  | 5 -> cyan
  | 6 -> magenta
  | 7 -> white
  | _ -> gr_grey;;

let which_button Color =
  match Color with
    0x000000 (*black*)   -> color_buttons.gb_button <- 0
  | 0xFF0000 (*red*)     -> color_buttons.gb_button <- 1
  | 0x00FF00 (*green*)   -> color_buttons.gb_button <- 2
  | 0x0000FF (*blue*)    -> color_buttons.gb_button <- 3
  | 0xFFFF00 (*yellow*)  -> color_buttons.gb_button <- 4
  | 0x00FFFF (*cyan*)    -> color_buttons.gb_button <- 5
  | 0xFF00FF (*magenta*) -> color_buttons.gb_button <- 6
  | 0xFFFFFF (*white*)   -> color_buttons.gb_button <- 7
  | _ -> color_buttons.gb_button <- 0;;




let CloseColorCfg Obj Event =
  gr_erase_window cfg_color.win_def;;

color_ok.bt_callback <- CloseColorCfg;;

