#open "windows";;
#open "camlwin";;

#open "camlprog";;
#open "strbrk";;



let ConfProg_def = 
{
  win_left     = 10;
  win_top      = 335;
  win_width    = 146;
  win_height   = 108;
  win_id       = gr_undef_window;
  win_name     = "Design window";
  win_state    = Destroyed
};;

let cfgprog_extent_list = 
{
  li_window   = ConfProg_def;
  li_left     = 4;
  li_top      = 86;
  li_width    = 42;
  li_height   = 52;
  li_nu_item  = 0;
  li_1st_item = 0;
  li_scroll   = 0;
  li_items    = [|".mli"; ".ml"; ".html"; ".c" |];
  li_callback = gr_do_nothing
};;

let cfgprog_pt_out_suffix = 
{
  pt_window   = ConfProg_def;
  pt_left     = 52;
  pt_top      = 80;
  pt_name     = "Goal suffix:"
};;

let cfgprog_pt_compiler = 
{
  pt_window   = ConfProg_def;
  pt_left     = 54;
  pt_top      = 68;
  pt_name     = "Compiler:"
};;

let cfgprog_out_suffix = 
{
  st_window   = ConfProg_def;
  st_left     = 82;
  st_top      = 81;
  st_width    = 48;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;

let cfgprog_pt_flags = 
{
  pt_window   = ConfProg_def;
  pt_left     = 54;
  pt_top      = 58;
  pt_name     = "Flags:"
};;

let cfgprog_pt_extent_list = 
{
  pt_window   = ConfProg_def;
  pt_left     = 4;
  pt_top      = 93;
  pt_name     = "Suffixes:"
};;

let cfgprog_compiler = 
{
  st_window   = ConfProg_def;
  st_left     = 76;
  st_top      = 70;
  st_width    = 54;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;

let cfgprog_flags = 
{
  st_window   = ConfProg_def;
  st_left     = 68;
  st_top      = 60;
  st_width    = 62;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;

let cfgprog_change = 
{
  bt_window   = ConfProg_def;
  bt_left     = 80;
  bt_top      = 45;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Change";
  bt_callback = gr_do_nothing
};;

let cfgprog_title = 
{
  expt_window = ConfProg_def;
  expt_left   = 52;
  expt_top    = 104;
  expt_name   = { f_type=Proportional_font; f_att =Italic; f_size =Size2_font; f_color =black; f_string = "Make Configuration"}
};;

let cfgprog_area = 
{
  ar_window = ConfProg_def;
  ar_name   = "Configuration";
  ar_left   = 50;
  ar_top    = 92;
  ar_width  = 90;
  ar_height = 64
};;

let cfgprog_add = 
{
  bt_window   = ConfProg_def;
  bt_left     = 8;
  bt_top      = 28;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Add";
  bt_callback = gr_do_nothing
};;

let cfgprog_del = 
{
  bt_window   = ConfProg_def;
  bt_left     = 8;
  bt_top      = 12;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Del";
  bt_callback = gr_do_nothing
};;

let cfgprog_ok = 
{
  bt_window   = ConfProg_def;
  bt_left     = 108;
  bt_top      = 12;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Ok";
  bt_callback = gr_do_nothing
};;

let ConfProjWin = 
{
  win_def      = ConfProg_def;
  win_objects  = [
                  g_list      cfgprog_extent_list;
                  g_prompt    cfgprog_pt_out_suffix;
                  g_prompt    cfgprog_pt_compiler;
                  g_string    cfgprog_out_suffix;
                  g_prompt    cfgprog_pt_flags;
                  g_prompt    cfgprog_pt_extent_list;
                  g_string    cfgprog_compiler;
                  g_string    cfgprog_flags;
                  g_exprompt  cfgprog_title;
                  g_area      cfgprog_area;
                  g_button    cfgprog_add;
                  g_button    cfgprog_del;
                  g_button    cfgprog_ok;
                  g_button    cfgprog_change
                 ];
  time_callback  = gr_do_nothing;
  resize_callback  = gr_do_nothing;
  help_file = "";
  miscellaneous = [| |]
};;



let CloseCallback Obj Event =
  gr_erase_window ConfProjWin.win_def;
  true
;;

cfgprog_ok.bt_callback <- CloseCallback;;



type ConfMakeType =
{
  mutable suffix : string;
  mutable goal_suffix : string;
  mutable compiler : string;
  mutable flags : string
};;


let ConfMakeInit = [ { suffix = ".mli";
                       goal_suffix = ".zi";
                       compiler = "camlc";
                       flags = "-c"
                     };
                     { suffix = ".ml";
                       goal_suffix = ".zo";
                       compiler = "camlc";
                       flags = "-c"
                     };
                     { suffix = ".html";
                       goal_suffix = ".hlp";
                       compiler = "camlhelp";
                       flags = "-c 190"
                     };
                     { suffix = ".c";
                       goal_suffix = ".o";
                       compiler = "gcc";
                       flags = "-c"
                     }
                   ]
;;

let ConfMake = ref ConfMakeInit;;




let GetConfig suffix =
(*  if nth_char suffix 0 =`.`
  then 
*)
    let rec cfg_loop List =
      match List with
        []   -> { suffix = "";
                  goal_suffix = "";
                  compiler = "";
                  flags = ""
                 }
      | x::y -> if x.suffix = suffix
                then x
                else cfg_loop y
  in 
   cfg_loop !ConfMake
;;
  


let InitAttributes () =
    let cfg = GetConfig cfgprog_extent_list.li_items.(cfgprog_extent_list.li_nu_item) in
      cfgprog_out_suffix.st_name <- cfg.goal_suffix;
      cfgprog_compiler.st_name <- cfg.compiler;
      cfgprog_flags.st_name <- cfg.flags;
      cfgprog_out_suffix.st_cursor <- 0;
      cfgprog_compiler.st_cursor <- 0;
      cfgprog_flags.st_cursor <- 0;
      cfgprog_out_suffix.st_1st_char <- 0;
      cfgprog_compiler.st_1st_char <- 0;
      cfgprog_flags.st_1st_char <- 0
;;


let OpenConfProgWin () =
    cfgprog_extent_list.li_nu_item <- 0;
    InitAttributes ();
    gr_block_loop ConfProjWin
;;


let ChangeItem Obj Event =
  InitAttributes ();
  gr_draw_string cfgprog_out_suffix;
  gr_draw_string cfgprog_compiler;
  gr_draw_string cfgprog_flags;
  true
;;

cfgprog_extent_list.li_callback <-  ChangeItem;;



let AddItem Obj Event =
  let suffix_name = gr_input_string "New suffix:" "." in
    ConfMake := !ConfMake @ [  { suffix = suffix_name;
                                 goal_suffix = "";
                                 compiler = "";
                                 flags = ""
                               } ];
   gr_list_add_item cfgprog_extent_list  suffix_name 99;
   ChangeItem Obj Event;
   gr_draw_list cfgprog_extent_list;
   true
;;


cfgprog_add.bt_callback <- AddItem;;


let ChangeItem Obj Event =
  let cfg = GetConfig cfgprog_extent_list.li_items.(cfgprog_extent_list.li_nu_item) in
    cfg.goal_suffix <- cfgprog_out_suffix.st_name;
    cfg.compiler <- cfgprog_compiler.st_name;
    cfg.flags <- cfgprog_flags.st_name;
    ChangeItem Obj Event;
    true
;;

cfgprog_change.bt_callback <- ChangeItem;;



let DelItem Obj Event =
  gr_list_del_item cfgprog_extent_list cfgprog_extent_list.li_nu_item;
  ChangeItem Obj Event;
  gr_draw_list cfgprog_extent_list;
  true
;;

cfgprog_del.bt_callback <- DelItem;;





let SaveConfigMake Channel =
  let rec save_loop List =
    match List with
      [] -> ()
    | x::y ->
       output_string Channel (x.suffix ^ " " ^ x.goal_suffix ^ " " ^ 
                              x.compiler ^ " " ^ x.flags ^ "\n");
       save_loop y
  in
    output_string Channel ("Camlprog Project V" ^ 
                           (string_of_float CamlprogVersion) ^ "\n");
    save_loop !ConfMake;
    output_string Channel "\n"
;;



let UpdateSuffixList () =
  let rec update_loop List =
    match List with
      []   -> ()
    | x::y -> cfgprog_extent_list.li_items <- 
         concat_vect cfgprog_extent_list.li_items [| x.suffix |];
         update_loop y
  in
    cfgprog_extent_list.li_items <- [| |];
    update_loop !ConfMake
;;



let LoadConfigMake Channel =
  let rec read_loop () =
    try
    (
      let line = input_line Channel in
        if line = ""
        then raise End_of_file;
        let strvect = break_str line " " in
          let len = vect_length strvect in
            let item = { suffix = strvect.(0);
                         goal_suffix = strvect.(1);
                         compiler = strvect.(2);
                         flags = merge_str (sub_vect strvect 3 (len-3)) " "
                       } in
          ConfMake := !ConfMake @ [ item ];
          read_loop ()
     )
     with End_of_file -> () 
   in
    input_line Channel;
    ConfMake := [];
    read_loop ();
    UpdateSuffixList ()
;;


let InitConfigMake () =
  ConfMake := ConfMakeInit;
  UpdateSuffixList ()
;;
