#open "windows";;
#open "camlwin";;


#open "confdraw";;
#open "globdraw";;
#open "camldraw";;
#open "indraw";;
#open "movedraw";;
#open "savedraw";;
#open "objdraw";;
#open "funcdraw";;
#open "windraw";;
#open "butdraw";;
#open "listdraw";;
#open "strdraw";;
#open "s2draw";;
#open "s3draw";;
#open "tooldraw";;
#open "textdraw";;
#open "grdraw";;
#open "coldraw";;
#open "graddraw";;
#open "gbutdraw";;
#open "scrodraw";;
#open "bmpdraw";;
#open "fontdraw";;

#open "saveicon";;
#open "camlicon";;







(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let ConfigButton Button =
  let n =(which_object (g_button Button) DesignWin.win_objects) in
    let Def = nth_elem !obj_def n in
      if vect_length Def.images_names > 0
      then button_init (string_of_melted Button.bt_name Def.images_names.(0))
                       Def
      else button_init (string_of_melted Button.bt_name "")
                       Def;
      gr_block_loop cfg_button;
      Button.bt_name <- melted_of_string button_name.st_name;
      Button.bt_state <- Up;
      Def.id_name  <- button_idname.st_name;
      Def.callback <- button_callback.st_name;
      Def.images_names <- [| image_name_of_string button_name.st_name |]
;;


(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let ConfigRadio Radio =
  let n =(which_object (g_radio Radio) DesignWin.win_objects) in
    let Def = nth_elem !obj_def n in
      s3_init "Radio Configuration"
              Def.id_name
              Radio.ra_name
              Def.callback;
      gr_block_loop cfg_s3;
      Radio.ra_name <- s3_name.st_name;
      Def.id_name  <- s3_idname.st_name;
      Def.callback <- s3_callback.st_name;
      Def.images_names <- [| |]
;;


(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let ConfigList List =
  let n =(which_object (g_list List) DesignWin.win_objects) in
    let Def = nth_elem !obj_def n in
      list_init Def.id_name Def.callback List.li_items;
      gr_block_loop cfg_list;
      List.li_items <- list_list.li_items;
      Def.id_name  <- list_idname.st_name;
      Def.callback <- list_callback.st_name;
      Def.images_names <- [| |]
;;


(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let ConfigString String =
  let n =(which_object (g_string String) DesignWin.win_objects) in
    let Def = nth_elem !obj_def n in
      str_init Def.id_name String.st_name String.st_type Def.callback;
      gr_block_loop cfg_string;
      String.st_name <- str_string.st_name;
      String.st_type <- str_string.st_type;
      Def.id_name  <- str_idname.st_name;
      Def.callback <- str_callback.st_name;
      Def.images_names <- [| |]
;;


(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let ConfigPrompt Prompt =
  let n =(which_object (g_prompt Prompt) DesignWin.win_objects) in
    let Def = nth_elem !obj_def n in
      s2_init "Prompt Configuration" Def.id_name Prompt.pt_name;
      gr_block_loop cfg_s2;
      Prompt.pt_name <- s2_name.st_name;
      Def.id_name  <- s2_idname.st_name;
      Def.callback <- "";
      Def.images_names <- [| |]
;;



(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let ConfigExtext ExText =
  let n =(which_object (g_extext ExText) DesignWin.win_objects) in
    let Def = nth_elem !obj_def n in
      s2_init "ExText Configuration" Def.id_name ExText.extx_name;
      gr_block_loop cfg_s2;
      ExText.extx_name <- s2_name.st_name;
      Def.id_name  <- s2_idname.st_name;
      Def.callback <- "";
      Def.images_names <- [| |]
;;





(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let ConfigExPrompt ExPrompt =
  let n =(which_object (g_exprompt ExPrompt) DesignWin.win_objects) in
    let Def = nth_elem !obj_def n in
      font_init ExPrompt Def.id_name;
      gr_block_loop cfg_exprompt;
      ExPrompt.expt_name.f_type <- font_result.expt_name.f_type;
      ExPrompt.expt_name.f_att <- font_result.expt_name.f_att;
      ExPrompt.expt_name.f_size <- font_result.expt_name.f_size;
      ExPrompt.expt_name.f_color <- font_result.expt_name.f_color;
      ExPrompt.expt_name.f_string <- font_result.expt_name.f_string;
      Def.id_name  <- font_idname.st_name;
      Def.callback <- "";
      Def.images_names <- [| |]
;;




(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let ConfigArea Area =
  let n =(which_object (g_area Area) DesignWin.win_objects) in
    let Def = nth_elem !obj_def n in
      s2_init "Area Configuration" Def.id_name Area.ar_name;
      gr_block_loop cfg_s2;
      Area.ar_name <- s2_name.st_name;
      Def.id_name  <- s2_idname.st_name;
      Def.callback <- "";
      Def.images_names <- [| |]
;;




(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let ConfigHelpb Helpbar =
  let n =(which_object (g_helpbar Helpbar) DesignWin.win_objects) in
    let Def = nth_elem !obj_def n in
      s2_init "Helpbar Configuration" Def.id_name Helpbar.hl_help;
      gr_block_loop cfg_s2;
      Helpbar.hl_help <- s2_name.st_name;
      Def.id_name  <- s2_idname.st_name;
      Def.callback <- "";
      Def.images_names <- [| |]
;;


(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let ConfigText Text =
  let n =(which_object (g_text Text) DesignWin.win_objects) in
    let Def = nth_elem !obj_def n in
      text_init Def.id_name Text.tx_scroll Text.tx_state;
      gr_block_loop cfg_text;
      Text.tx_scroll <- text_get_scro ();
      Text.tx_state <- text_get_editable ();
      Def.id_name  <- text_idname.st_name;
      Def.callback <- "";
      Def.images_names <- [| |]
;;


(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let ConfigShell Shell =
  let n =(which_object (g_shell Shell) DesignWin.win_objects) in
    let Def = nth_elem !obj_def n in
      Def.id_name  <- gr_input_string "Shell's name:" Def.id_name;
      Def.callback <- "";
      Def.images_names <- [| |]
;;



(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let ConfigGrprad Grprad =
  let n =(which_object (g_grprad Grprad) DesignWin.win_objects) in
    let Def = nth_elem !obj_def n in
      grprad_init Def.id_name Def.callback Grprad;
      gr_block_loop cfg_grprad;
      Grprad.ga_delta <- int_of_string grprad_delta.st_name;
      Grprad.ga_name <- grprad_names.li_items;
      Def.id_name  <- grprad_idname.st_name;
      Def.callback <- grprad_callback.st_name;
      Def.images_names <- [| |]
;;


(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let ConfigGrpbut Grpbut =
  let n =(which_object (g_grpbut Grpbut) DesignWin.win_objects) in
    let Def = nth_elem !obj_def n in
      grpbut_init Def Grpbut;
      gr_block_loop cfg_grpbut;
      Grpbut.gb_delta <- int_of_string grpbut_delta.st_name;
      Grpbut.gb_btwidth <- int_of_string grpbut_width.st_name;
      Grpbut.gb_btheight <- int_of_string grpbut_height.st_name;
      Grpbut.gb_name <- lines_to_GrpbutName grpbut_names.li_items;
      Grpbut.gb_dir <- GrpbutDir ();
      Def.id_name  <- grpbut_idname.st_name;
      Def.callback <- grpbut_callback.st_name;
      Def.images_names <- [| |];
      let len = vect_length grpbut_names.li_items in
        for i=0 to (len-1) do
          Def.images_names <- concat_vect Def.images_names
                                          [| image_name_of_string grpbut_names.li_items.(i) |]
        done
;;


(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let ConfigLine Line =
  let n =(which_object (g_line Line) DesignWin.win_objects) in
    let Def = nth_elem !obj_def n in
      color_idname.st_name <- Def.id_name;
      which_button Line.ln_color;
      gr_block_loop cfg_color;
      Line.ln_color <- which_color ();
      Def.id_name  <- color_idname.st_name;
      Def.callback <- "";
      Def.images_names <- [| |]
;;


(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let ConfigRectangle Rectangle =
  let n =(which_object (g_rectangle Rectangle) DesignWin.win_objects) in
    let Def = nth_elem !obj_def n in
      color_idname.st_name <- Def.id_name;
      which_button Rectangle.re_color;
      gr_block_loop cfg_color;
      Rectangle.re_color <- which_color ();
      Def.id_name  <- color_idname.st_name;
      Def.callback <- "";
      Def.images_names <- [| |]
;;


(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let ConfigEllipse Ellipse =
  let n =(which_object (g_ellipse Ellipse) DesignWin.win_objects) in
    let Def = nth_elem !obj_def n in
      color_idname.st_name <- Def.id_name;
      which_button Ellipse.el_color;
      gr_block_loop cfg_color;
      Ellipse.el_color <- which_color ();
      Def.id_name  <- color_idname.st_name;
      Def.callback <- "";
      Def.images_names <- [| |]
;;




(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let ConfigScroll Scroll =
  let n =(which_object (g_scrollbar Scroll) DesignWin.win_objects) in
    let Def = nth_elem !obj_def n in
      scroll_init Def.id_name Def.callback Scroll.sb_delta Scroll.sb_dir;
      gr_block_loop cfg_scroll;
      Scroll.sb_dir <- which_dir ();
      Scroll.sb_delta <- int_of_string scroll_delta.st_name;
      Def.id_name  <- scroll_idname.st_name;
      Def.callback <- scroll_callback.st_name;
      Def.images_names <- [| |]
;;



(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let ConfigBitmap Bitmap =
  let n =which_object (g_bitmap Bitmap) DesignWin.win_objects in
    let Def= nth_elem !obj_def n in
      bitmap_init Def.id_name Def.images_names.(0) Def.callback;
      gr_block_loop cfg_bitmap;
      Bitmap.bm_bitmap <- load_bitmap !bitmap_name Bitmap.bm_bitmap;
      Def.id_name  <- bitmap_idname.st_name;
      Def.callback <- bitmap_callback.st_name;
      Def.images_names <- [| !bitmap_name |]
;;





(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let ConfigToolb Toolbar =
  let n = which_object (g_toolbar Toolbar) DesignWin.win_objects in
    let Def= nth_elem !obj_def n in
      toolb_name.st_name <- Def.id_name;
      gr_block_loop cfg_toolb;
      Def.id_name  <- toolb_name.st_name;
      Def.callback <- "";
      Def.images_names <- [| |]
;;


(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let ConfigItem NuMenu NuItem =
  let Toolb = get_toolbar DesignWin.win_objects in
    let Def = !toolb_def.(NuMenu)
    and Menu = Toolb.tb_items.(NuMenu) in
      let Item = Menu.mn_items.(NuItem) in
        s3_init "Item Configuration" (fst Def.items_def.(NuItem))
                Item.it_name (snd Def.items_def.(NuItem));
        gr_block_loop cfg_s3;
        Item.it_name <- s3_name.st_name;
        Def.items_def.(NuItem) <- (s3_idname.st_name,s3_callback.st_name);
        window_saved := false;
        UpdateObject (id_name_vect !obj_def !toolb_def)
;;


(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let ConfigMenu NuMenu =
  let Toolb=get_toolbar DesignWin.win_objects in
    let Menu=(Toolb.tb_items.(NuMenu))
    and Def= !toolb_def.(NuMenu) in
      s2_init "Menu Configuration" Def.menu_name Menu.mn_name;
      gr_block_loop cfg_s2;
      Menu.mn_name <- s2_name.st_name;
      Def.menu_name <- s2_idname.st_name;
      window_saved := false;
      UpdateObject (id_name_vect !obj_def !toolb_def)
;;






(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let ConfigWin ()  =
  win_init design_win.win_width design_win.win_height !window_name;
  gr_block_loop cfg_win;
  design_win.win_width <- int_of_string cwin_width.st_name;
  design_win.win_height <- int_of_string cwin_height.st_name;
  window_saved := false;
  window_name := cwin_name.st_name
;;






(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let ConfigObject Obj =
  (
    match Obj with
      g_menu    Menu    ->
        let Toolbar=get_toolbar DesignWin.win_objects in
          ConfigMenu (MenuPos Menu Toolbar)
    | g_toolbar Toolbar -> ConfigToolb     Toolbar
    | g_prompt  Prompt  -> ConfigPrompt    Prompt
    | g_line    Line    -> ConfigLine      Line
    | g_rectangle Rect  -> ConfigRectangle Rect
    | g_ellipse Ellipse -> ConfigEllipse   Ellipse
    | g_text    Text    -> ConfigText      Text
    | g_shell   Shell   -> ConfigShell     Shell
    | g_helpbar Help    -> ConfigHelpb     Help
    | g_button Button   -> ConfigButton    Button
    | g_string String   -> ConfigString    String
    | g_list   List     -> ConfigList      List
    | g_item   Item     ->
        let Toolbar = get_toolbar DesignWin.win_objects in
          let pos = ItemPos Item Toolbar in
            ConfigItem  (fst pos) (snd pos)
    | g_bitmap Bitmap   -> ConfigBitmap    Bitmap
    | g_scrollbar Scr   -> ConfigScroll    Scr
    | g_radio  Radio    -> ConfigRadio     Radio
    | g_grprad Grprad   -> ConfigGrprad    Grprad
    | g_grpbut Grpbut   -> ConfigGrpbut    Grpbut
    | g_user   User     -> ()
    | g_area   Area     -> ConfigArea      Area
    | g_extext ExText   -> ConfigExtext    ExText
    | g_exprompt ExPt   -> ConfigExPrompt  ExPt
  );
  window_saved := false;
  UpdateObject (id_name_vect !obj_def !toolb_def);
  gr_draw_window design_win.win_id
;;
