#open "windows";;


(***************************************************************************)
(*                                                                         *)
(*  g_config.ml                                                            *)
(*                                                                         *)
(***************************************************************************)
value operating_system    : operating_system_type
  and directory_separator : string
  and gr_screen           : screen_type
  and program_extention   : string
  and link_cmd            : string -> string -> string
  and compile_cmd         : string -> string
  and caml_cmd            : string
;;





(***************************************************************************)
(*                                                                         *)
(*  g_global.ml                                                            *)
(*                                                                         *)
(***************************************************************************)
type gr_look_list =
    Std_color
  | Std_mono
  | Window_color
  | Os2_color
  | Motif_color
  | Open_look_color
  | Open_look_mono
  | Next_color
  | Mac_mono
  | Mac_color
;;

type direction =
    Vertical
  | Horizontal
;;
type coord =
  { x : int
  ; y : int
  }
;;
type rect =
  { x1 : int
  ; y1 : int
  ; x2 : int
  ; y2 : int
  }
;;


value gr_grey : int
  and gr_darkgrey : int
;;

value gr_set_look  : gr_look_list -> unit
  and gr_get_look  : unit -> gr_look_list
  and gr_backcolor : unit -> color
  and gr_is_color_look : unit -> bool
;;

value gr_long_space  : int
  and gr_short_space : int
  and gr_text_height : int
;;

value gr_coord_extent  : int
  and gr_to_real_coord : int -> int
  and gr_to_win_coord  : int -> int
;;

value gr_do_nothing  : 'a -> 'b -> bool
  and gr_empty_image : image
  and gr_empty_line  : string
;;

value gr_inside : coord -> rect -> bool
  and gr_draw_rect : int -> int -> int -> int -> unit
  and gr_draw_triangle : int -> int -> int -> unit
;;


value nth_elem : 'a list -> int -> 'a
  and set_nth_elem : 'a list -> int -> 'a -> 'a list
  and del_nth_elem : 'a list -> int -> 'a list
;;

value ins_char : string -> char -> int -> string
;;

value input_file : in_channel -> string
;;

value gr_debug : unit -> unit
  and gr_no_debug : unit -> unit
;;




(***************************************************************************)
(*                                                                         *)
(* g_window.ml                                                             *)
(*                                                                         *)
(***************************************************************************)
type win_state_def =
    Created
  | Destroyed
;;
type gr_window =
  { mutable win_id : window
  ; mutable win_top : int
  ; mutable win_left : int
  ; mutable win_width : int
  ; mutable win_height : int
  ; mutable win_name : string
  ; mutable win_state : win_state_def
  }
;;


value gr_std_win : gr_window;;
value gr_undef_window : window;;





(***************************************************************************)
(*                                                                         *)
(* g_button.ml                                                             *)
(*                                                                         *)
(***************************************************************************)
type melted_type = string_type of string
                 | int_type of int
                 | float_type of float
                 | bitmap_type of image
                 | bool_type of bool
;;
type button_state =
    Up
  | Down
  | Unused
;;
type gr_button =
  { bt_window : gr_window
  ; mutable bt_top : int
  ; mutable bt_left : int
  ; mutable bt_width : int
  ; mutable bt_height : int
  ; mutable bt_name : melted_type
  ; mutable bt_state : button_state
  ; mutable bt_callback : gr_button -> event -> bool
  }
;;


value gr_draw_unfilled_button : gr_button -> unit
  and gr_draw_button : gr_button -> unit
  and gr_button_managed : gr_button -> event -> bool
;;






(***************************************************************************)
(*                                                                         *)
(* g_bitmap.ml                                                             *)
(*                                                                         *)
(***************************************************************************)
type gr_bitmap =
  { bm_window : gr_window
  ; mutable bm_left : int
  ; mutable bm_top : int
  ; mutable bm_bitmap : image
  ; mutable bm_callback : gr_bitmap -> event -> bool
  }
;;


value gr_icon_size : int
  and gr_draw_bitmap : gr_bitmap -> unit
  and gr_draw_center_bitmap : gr_bitmap -> rect -> unit
  and gr_bitmap_managed : gr_bitmap -> event -> bool
;;






(***************************************************************************)
(*                                                                         *)
(* g_item.ml                                                               *)
(*                                                                         *)
(***************************************************************************)
type item_state =
    Selected
  | Unselected
  | Unselectable
;;
type gr_item =
  { it_window : gr_window
  ; mutable it_state : item_state
  ; mutable it_name : string
  ; mutable it_callback : gr_item -> event -> bool
  }
;;


value gr_draw_item : gr_item -> coord -> int -> unit
  and gr_item_managed : 'a -> 'b -> bool
;;







(***************************************************************************)
(*                                                                         *)
(* g_menu.ml                                                               *)
(*                                                                         *)
(***************************************************************************)
type menu_state =
    Visible
  | Unvisible
;;
type gr_menu =
  { mn_window : gr_window
  ; mutable mn_left : int
  ; mutable mn_top : int
  ; mutable mn_state : menu_state
  ; mutable mn_nu_item : int
  ; mutable mn_name : string
  ; mutable mn_items : gr_item vect
  ; mutable mn_hide_area : image
  }
;;


value gr_draw_menu : gr_menu -> unit
  and gr_erase_menu : gr_menu -> unit
  and gr_menu_managed : gr_menu -> event -> bool
;;




(***************************************************************************)
(*                                                                         *)
(* g_toolb.ml                                                              *)
(*                                                                         *)
(***************************************************************************)
type gr_toolbar =
  { tb_window : gr_window
  ; mutable tb_items : gr_menu vect
  }
;;


value gr_draw_toolbar : gr_toolbar -> unit
  and gr_toolbar_managed : gr_toolbar -> event -> bool
;;







(***************************************************************************)
(*                                                                         *)
(* g_scroll.ml                                                             *)
(*                                                                         *)
(***************************************************************************)
type gr_scrollbar =
  { sb_window : gr_window
  ; mutable sb_left : int
  ; mutable sb_top : int
  ; mutable sb_length : int
  ; mutable sb_pos : int
  ; mutable sb_delta : int
  ; mutable sb_dir : direction
  ; mutable sb_callback : gr_scrollbar -> event -> bool
  }
;;


value gr_elevator_width : int
  and gr_elevator_height : int
  and gr_scroll_width : int
  and gr_scroll_course : int -> int
  and gr_draw_scrollbar : gr_scrollbar -> unit
  and gr_scrollbar_managed : gr_scrollbar -> event -> bool
;;






(***************************************************************************)
(*                                                                         *)
(* g_string.ml                                                             *)
(*                                                                         *)
(***************************************************************************)
type string_state =
    View_only
  | Editable
  | Edited
;;
type string_type =
    Gr_string
  | Gr_natural
  | Gr_int
  | Gr_hexa
  | Gr_float
  | Gr_password
;;
type gr_string =
  { st_window : gr_window
  ; mutable st_top : int
  ; mutable st_left : int
  ; mutable st_width : int
  ; mutable st_type : string_type
  ; mutable st_name : string
  ; mutable st_cursor : int
  ; mutable st_1st_char : int
  ; mutable st_state : string_state
  ; mutable st_callback : gr_string -> event -> bool
  }
;;


value gr_draw_string : gr_string -> unit
  and gr_string_managed : gr_string -> event -> bool
;;






(***************************************************************************)
(*                                                                         *)
(* g_text.ml                                                               *)
(*                                                                         *)
(***************************************************************************)
type scrolllink =
    Noscroll
  | Vscroll
  | Dscroll
;;

type tmp_text =
  { t_window : gr_window
  ; mutable t_top : int
  ; mutable t_left : int
  ; mutable t_width : int
  ; mutable t_height : int
  ; mutable t_name : string vect
  ; mutable t_state : string_state
  ; mutable t_scroll : scrolllink
  }
;;

type gr_text =
  { tx_window : gr_window
  ; mutable tx_top : int
  ; mutable tx_left : int
  ; mutable tx_width : int
  ; mutable tx_height : int
  ; mutable tx_name : string vect
  ; mutable tx_cursor : int
  ; mutable tx_line : int
  ; mutable tx_1st_line : int
  ; mutable tx_1st_row : int
  ; mutable tx_state : string_state
  ; mutable tx_modified : bool
  ; mutable tx_scroll : scrolllink
  ; mutable tx_vscroll : int
  ; mutable tx_hscroll : int
  ; mutable tx_s_select : int * int
  ; mutable tx_e_select : int * int
  }
;;


value gr_lines_of_string : string -> string vect
  and gr_string_of_lines : string vect -> string
;;
value gr_make_text : tmp_text -> gr_text;;
value gr_draw_text : gr_text -> unit
  and gr_text_managed : gr_text -> event -> bool
;;

type gr_search =
    FromCursor
  | FullText
  | FullSelected
;;

value gr_text_find : gr_text -> string -> gr_search -> int * int
  and gr_text_goto : gr_text -> int * int -> unit
  and gr_text_replace : gr_text -> string -> string -> gr_search -> bool
  and gr_text_save : gr_text -> out_channel -> unit
  and gr_text_load : gr_text -> in_channel -> unit
  and gr_get_selected_text : gr_text -> string
  and gr_add_text : gr_text -> string -> unit
  and gr_del_selected_text : gr_text -> unit
  and gr_text_init : gr_text -> unit
;;




(***************************************************************************)
(*                                                                         *)
(* g_shell.ml                                                               *)
(*                                                                         *)
(***************************************************************************)
type tmp_shell =
  { s_window : gr_window
  ; mutable s_top : int
  ; mutable s_left : int
  ; mutable s_width : int
  ; mutable s_height : int
  ; mutable s_state : string_state
  }
;;

type gr_shell =
  { sh_window : gr_window
  ; mutable sh_top : int
  ; mutable sh_left : int
  ; mutable sh_width : int
  ; mutable sh_height : int
  ; mutable sh_name : string vect
  ; mutable sh_cursor : int
  ; mutable sh_line : int
  ; mutable sh_1st_line : int
  ; mutable sh_1st_row : int
  ; mutable sh_state : string_state
  ; mutable sh_vscroll : int
  ; mutable sh_hscroll : int
  ; mutable sh_s_select : int * int
  ; mutable sh_e_select : int * int
  }
;;


value gr_make_shell : tmp_shell -> gr_shell;;
value gr_draw_shell : gr_shell -> unit
  and gr_shell_managed : gr_shell -> event -> bool
  and gr_camlwin_env : string
;;





(***************************************************************************)
(*                                                                         *)
(* g_list.ml                                                               *)
(*                                                                         *)
(***************************************************************************)
type gr_list =
  { li_window : gr_window
  ; mutable li_left : int
  ; mutable li_top : int
  ; mutable li_width : int
  ; mutable li_height : int
  ; mutable li_nu_item : int
  ; mutable li_1st_item : int
  ; mutable li_items : string vect
  ; mutable li_callback : gr_list -> event -> bool
  ; mutable li_scroll : int
  }
;;


value gr_draw_list : gr_list -> unit
  and gr_list_managed : gr_list -> event -> bool
  and gr_list_add_item : gr_list -> string -> int -> unit
  and gr_list_del_item : gr_list -> int -> unit
  and gr_list_sort : gr_list -> unit
  and gr_list_save : gr_list -> out_channel -> unit
  and gr_list_load : gr_list -> in_channel -> unit
;;



(***************************************************************************)
(*                                                                         *)
(* g_graph.ml                                                              *)
(*                                                                         *)
(***************************************************************************)
type gr_line =
  { ln_window : gr_window
  ; mutable ln_color : color
  ; mutable ln_point1 : int * int
  ; mutable ln_point2 : int * int
  }
;;
type gr_ellipse =
  { el_window : gr_window
  ; mutable el_filled : bool
  ; mutable el_color : color
  ; mutable el_center : int * int
  ; mutable el_xray : int
  ; mutable el_yray : int
  }
;;
type gr_rectangle =
  { re_window : gr_window
  ; mutable re_filled : bool
  ; mutable re_color : color
  ; mutable re_point : int * int
  ; mutable re_width : int
  ; mutable re_height : int
  }
;;


value gr_draw_line : gr_line -> unit
  and gr_draw_ellipse : gr_ellipse -> unit
  and gr_draw_rectangle : gr_rectangle -> unit
;;




(***************************************************************************)
(*                                                                         *)
(* g_grpbut.ml                                                             *)
(*                                                                         *)
(***************************************************************************)
type gr_grpbut =
  { gb_window : gr_window
  ; mutable gb_top : int
  ; mutable gb_left : int
  ; mutable gb_width : int
  ; mutable gb_height : int
  ; mutable gb_delta : int
  ; mutable gb_btwidth : int
  ; mutable gb_btheight : int
  ; mutable gb_dir : direction
  ; mutable gb_button : int
  ; mutable gb_name : melted_type vect
  ; mutable gb_callback : gr_grpbut -> event -> bool
  }
;;


value gr_draw_grpbut : gr_grpbut -> unit
  and gr_draw_unfilled_grpbut : gr_grpbut -> unit
  and gr_grpbut_managed : gr_grpbut -> event -> bool
;;





(***************************************************************************)
(*                                                                         *)
(* g_grprad.ml                                                             *)
(*                                                                         *)
(***************************************************************************)
type gr_grprad =
  { ga_window : gr_window
  ; mutable ga_top : int
  ; mutable ga_left : int
  ; mutable ga_width : int
  ; mutable ga_height : int
  ; mutable ga_delta : int
  ; mutable ga_radio : int
  ; mutable ga_name : string vect
  ; mutable ga_callback : gr_grprad -> event -> bool
  }
;;

value gr_draw_grprad : gr_grprad -> unit
  and gr_draw_unfilled_grprad : gr_grprad -> unit
  and gr_grprad_managed : gr_grprad -> event -> bool
;;






(***************************************************************************)
(*                                                                         *)
(* g_prompt.ml                                                             *)
(*                                                                         *)
(***************************************************************************)
type gr_prompt =
  { pt_window : gr_window
  ; mutable pt_left : int
  ; mutable pt_top : int
  ; mutable pt_name : string
  }
;;


value gr_draw_prompt : gr_prompt -> unit;;






(***************************************************************************)
(*                                                                         *)
(* g_radio.ml                                                              *)
(*                                                                         *)
(***************************************************************************)
type gr_radio =
  { ra_window : gr_window
  ; mutable ra_left : int
  ; mutable ra_top : int
  ; mutable ra_state : bool
  ; mutable ra_name : string
  ; mutable ra_callback : gr_radio -> event -> bool
  }
;;


value gr_draw_radio : gr_radio -> unit
  and gr_radio_managed : gr_radio -> event -> bool
;;




(***************************************************************************)
(*                                                                         *)
(* g_helpb.ml                                                              *)
(*                                                                         *)
(***************************************************************************)
type gr_helpbar =
  { hl_window : gr_window
  ; mutable hl_help : string
  }
;;


value gr_draw_helpbar : gr_helpbar -> unit;;







(***************************************************************************)
(*                                                                         *)
(* g_html.ml                                                               *)
(*                                                                         *)
(***************************************************************************)
type AnchorMode = HREF | NAME;;
type AnchorType = 
{ 
  mutable AnchorType : AnchorMode; 
  mutable AnchorFile : string; 
  mutable AnchorName : string
};;

type AlignType = AlignBottom | AlignTop | AlignMiddle;;

type ImageType = 
{ 
  mutable ImageAlign : AlignType; 
  mutable ImageFile : string; 
  mutable ImageAlt : string 
};;




type HTML_type = ANCHOR     of AnchorType
               | HtmlText   of string
               | H1         of HTML_type list
               | H2         of HTML_type list
               | H3         of HTML_type list
               | H4         of HTML_type list
               | H5         of HTML_type list
               | H6         of HTML_type list
               | LineBreak
               | UList      of HTML_type list
               | OList      of HTML_type list 
               | DList      of HTML_type list 
               | DD         of HTML_type list
               | DT         of HTML_type list
               | LI         of HTML_type list
               | PRE        of HTML_type list
               | BLOCKQUOTE of HTML_type list
               | ADDRESS    of HTML_type list
               | DFN        of HTML_type list
               | EM         of HTML_type list
               | CITE       of HTML_type list
               | CODE       of HTML_type list
               | KBD        of HTML_type list
               | SAMP       of HTML_type list
               | STRONG     of HTML_type list
               | VAR        of HTML_type list
               | BOLD       of HTML_type list
               | ITALIC     of HTML_type list
               | TT         of HTML_type list
               | IMG        of ImageType 
               | HLine
               | Ignore     of string
;;



value gr_html_interpreter : in_channel -> HTML_type list 
  and gr_html_save : HTML_type list -> out_channel -> unit  
  and gr_save_HTML_type : string -> HTML_type list -> out_channel -> unit
  and gr_html_anchor_list : HTML_type list -> AnchorType list
;;




(***************************************************************************)
(*                                                                         *)
(* g_extext.ml                                                             *)
(*                                                                         *)
(***************************************************************************)
type Formated_string = 
{
  mutable f_type : Font_Type;
  mutable f_att  : Font_Attributes;
  mutable f_size : Font_Size;
  mutable f_color : color;
  mutable f_string : string
};;

type Formated_line = 
{
  mutable l_indent : int;
  mutable l_line   : bool;
  mutable l_content : Formated_string list
};;



type gr_extext  =
  { extx_window : gr_window
  ; mutable extx_name : string
  ; mutable extx_left : int
  ; mutable extx_top : int
  ; mutable extx_width : int
  ; mutable extx_height : int
  ; mutable extx_scroll : int
  ; mutable extx_anchors : (AnchorType * int) list
  ; mutable extx_content : Formated_line vect
  ; mutable extx_callback : (string * string) -> (string * string)
  }
;;


value gr_HtmlList_to_Formated :  HTML_type list -> int ->  
                                 Formated_line vect * ((AnchorType * int) list)
  and gr_draw_extext : gr_extext -> unit
  and gr_html_extext : gr_extext -> event -> bool
  and gr_extext_width : gr_extext -> int
  and gr_extext_goto_anchor : gr_extext -> string -> unit
  and gr_extext_load : gr_extext -> string -> HTML_type list
  and gr_extext_save : gr_extext -> string -> unit
  and gr_extext_callback : (string * string) -> (string * string)
;;




(***************************************************************************)
(*                                                                         *)
(* g_exprpt.ml                                                             *)
(*                                                                         *)
(***************************************************************************)
type gr_exprompt =
  { expt_window : gr_window
  ; mutable expt_left : int
  ; mutable expt_top : int
  ; mutable expt_name : Formated_string
  }
;;


value gr_draw_exprompt : gr_exprompt -> unit
  and gr_fline_to_string : Formated_line -> string;;





(***************************************************************************)
(*                                                                         *)
(* g_area.ml                                                               *)
(*                                                                         *)
(***************************************************************************)
type gr_area =
  { ar_window : gr_window
  ; mutable ar_left : int
  ; mutable ar_top : int
  ; mutable ar_width : int
  ; mutable ar_height : int
  ; mutable ar_name : string
  }
;;


value gr_draw_area : gr_area -> unit;;






(***************************************************************************)
(*                                                                         *)
(* g_user.ml                                                               *)
(*                                                                         *)
(***************************************************************************)
type gr_user  =
  { us_window : gr_window
  ; mutable us_param : melted_type vect
  ; mutable us_draw : gr_user -> unit
  ; mutable us_callback : gr_user -> event -> bool
  }
;;








(***************************************************************************)
(*                                                                         *)
(* g_type.ml                                                               *)
(*                                                                         *)
(***************************************************************************)
type graph_obj =
    g_button of gr_button
  | g_item of gr_item
  | g_menu of gr_menu
  | g_string of gr_string
  | g_text of gr_text
  | g_shell of gr_shell
  | g_toolbar of gr_toolbar
  | g_bitmap of gr_bitmap
  | g_scrollbar of gr_scrollbar
  | g_prompt of gr_prompt
  | g_rectangle of gr_rectangle
  | g_line of gr_line
  | g_ellipse of gr_ellipse
  | g_list of gr_list
  | g_radio of gr_radio
  | g_helpbar of gr_helpbar
  | g_grpbut of gr_grpbut
  | g_user of gr_user
  | g_grprad of gr_grprad
  | g_extext of gr_extext
  | g_exprompt of gr_exprompt
  | g_area of gr_area
;;

type window_type =
  { mutable win_def : gr_window
  ; mutable win_objects : graph_obj list
  ; mutable resize_callback : window_type -> event -> bool
  ; mutable time_callback : window_type -> event -> bool
  ; mutable help_file : string
  ; mutable miscellaneous : melted_type vect
  }
;;


value gr_use_time_event : int -> unit
  and gr_no_time_event : unit -> unit
;;






(***************************************************************************)
(*                                                                         *)
(* g_mloop.ml                                                              *)
(*                                                                         *)
(***************************************************************************)

value gr_create_window : gr_window -> bool
  and gr_erase_window : gr_window -> bool
  and gr_quit_callback : 'a -> 'b -> bool
  and gr_callback : graph_obj -> event -> bool
  and gr_draw_graph_obj : graph_obj -> unit
  and gr_draw_window : window -> unit
  and gr_graph_obj_callback : graph_obj -> event -> bool
  and gr_which_window : window_type list -> window -> window_type
  and gr_main_loop : window_type list -> unit
  and gr_block_loop : window_type -> unit
;;





(***************************************************************************)
(*                                                                         *)
(* g_input.ml                                                              *)
(*                                                                         *)
(***************************************************************************)

value gr_input_string : string -> string -> string
  and gr_input_natural : string -> int -> int
  and gr_input_int : string -> int -> int
  and gr_input_hexa : string -> int -> int
  and gr_input_float : string -> float -> float
  and gr_input_password : string -> string -> string
  and gr_input_filename : string -> string -> string
;;


(***************************************************************************)
(*                                                                         *)
(* g_minput.ml                                                              *)
(*                                                                         *)
(***************************************************************************)
type minput_type = 
{
  minput_name : string;
  minput_type : string_type;
  minput_init : melted_type
};;

value gr_minput : string -> minput_type vect -> melted_type vect
  and gr_string_of_melted : melted_type -> string 
  and gr_int_of_melted : melted_type -> int
  and gr_float_of_melted : melted_type -> float
  and gr_bool_of_melted : melted_type -> bool
  and gr_image_of_melted : melted_type -> image
;;






(***************************************************************************)
(*                                                                         *)
(* g_edit.ml                                                              *)
(*                                                                         *)
(***************************************************************************)

value gr_edit : string -> string -> string;;







(***************************************************************************)
(*                                                                         *)
(* g_wshell.ml                                                              *)
(*                                                                         *)
(***************************************************************************)

value gr_shell : window_type;;








(***************************************************************************)
(*                                                                         *)
(* g_find.ml                                                               *)
(*                                                                         *)
(***************************************************************************)
value gr_find_in_text : gr_text -> int -> int -> unit
  and gr_replace_in_text : gr_text -> int -> int -> unit;;







(***************************************************************************)
(*                                                                         *)
(* g_warn.ml                                                               *)
(*                                                                         *)
(***************************************************************************)
type gr_answer = gr_ans1
               | gr_ans2
               | gr_ans3
;;

type gr_warn =
  { warn_name : string
  ; warn_callback : gr_button -> event -> bool
  }
;;

value gr_warning : string -> gr_warn vect -> unit
  and gr_close_warning : 'a -> 'b -> bool
  and gr_warning1 : 'a -> 'b -> bool
  and gr_warning2 : 'a -> 'b -> bool
  and gr_warning3 : 'a -> 'b -> bool
  and gr_warn_button : unit -> gr_answer
;;







(***************************************************************************)
(*                                                                         *)
(* g_look.ml                                                               *)
(*                                                                         *)
(***************************************************************************)

value gr_look_menu : gr_window -> gr_menu;;







(***************************************************************************)
(*                                                                         *)
(* g_file.ml                                                               *)
(*                                                                         *)
(***************************************************************************)
value gr_select_file : string -> string
  and gr_without_suffix : string -> string
  and gr_suffix_only : string -> string
;;






(***************************************************************************)
(*                                                                         *)
(* g_select.ml                                                             *)
(*                                                                         *)
(***************************************************************************)
value gr_select : string -> string vect -> (int * string);;





(***************************************************************************)
(*                                                                         *)
(* g_font.ml                                                               *)
(*                                                                         *)
(***************************************************************************)
value gr_select_font : Formated_string -> Formated_string
;;




(***************************************************************************)
(*                                                                         *)
(* g_color.ml                                                              *)
(*                                                                         *)
(***************************************************************************)
value gr_select_color : color -> color
;;





(***************************************************************************)
(*                                                                         *)
(* g_save.ml                                                               *)
(*                                                                         *)
(***************************************************************************)
value gr_output_window : out_channel -> window_type -> unit
  and gr_input_window : in_channel -> gr_window -> window_type
;;






(***************************************************************************)
(*                                                                         *)
(* g_helpw.ml                                                               *)
(*                                                                         *)
(***************************************************************************)
value gr_open_help : string -> string -> unit
;;
