#open "windows";;




(***************************************************************************)
(*                                                                         *)
(*  g_config.ml                                                            *)
(*                                                                         *)
(***************************************************************************)
let operating_system = g_config__gr_operating_system
and directory_separator = g_config__gr_directory_separator
and gr_screen = g_config__gr_screen_col
and program_extention = g_config__gr_program_extention
and link_cmd = g_config__gr_link_cmd
and compile_cmd = g_config__gr_compile_cmd
and caml_cmd = g_config__gr_caml_cmd
;;






(***************************************************************************)
(*                                                                         *)
(*  g_global.ml                                                            *)
(*                                                                         *)
(***************************************************************************)
let gr_grey = g_global__grey
and gr_darkgrey = g_global__darkgrey
;;

let gr_set_look = g_global__set_gr_look
and gr_get_look = g_global__get_gr_look
and gr_backcolor = g_global__backcolor
and gr_is_color_look = g_global__is_color_look
;;

let gr_long_space = g_global__long_space
and gr_short_space = g_global__short_space
and gr_text_height = g_global__line_height
;;

let gr_do_nothing = g_global__do_nothing
and gr_empty_image = g_global__empty_image
and gr_empty_line = g_global__empty_line
;;

let gr_coord_extent = g_global__coord_extent
and gr_to_real_coord =g_global__to_real_coord
and gr_to_win_coord = g_global__to_win_coord
;;


let gr_inside = g_global__inside
and gr_draw_rect = g_global__draw_rect
and gr_draw_triangle = g_global__draw_triangle
;;


let nth_elem = g_global__gr_nth_elem
and set_nth_elem = g_global__gr_set_nth_elem
and del_nth_elem = g_global__gr_del_nth_elem
;;

let ins_char = g_global__add_char
;;

let input_file = g_global__load_file
;;

let gr_debug = g_global__set_debug
and gr_no_debug =  g_global__unset_debug
;;



let gr_std_win = g_global__std_win;;
let gr_undef_window = g_global__undef_window;;



(***************************************************************************)
(*                                                                         *)
(* g_window.ml                                                             *)
(*                                                                         *)
(***************************************************************************)


(***************************************************************************)
(*                                                                         *)
(* g_button.ml                                                             *)
(*                                                                         *)
(***************************************************************************)
let gr_draw_unfilled_button = g_button__draw_unfilled_gr_button
and gr_draw_button = g_button__draw_gr_button
and gr_button_managed = g_button__gr_button_callback
;;



(***************************************************************************)
(*                                                                         *)
(* g_bitmap.ml                                                             *)
(*                                                                         *)
(***************************************************************************)
let gr_icon_size = g_bitmap__icon_size
and gr_draw_bitmap = g_bitmap__draw_gr_bitmap
and gr_draw_center_bitmap = g_bitmap__draw_center_gr_bitmap
and gr_bitmap_managed = g_bitmap__gr_bitmap_callback
;;


(***************************************************************************)
(*                                                                         *)
(* g_item.ml                                                               *)
(*                                                                         *)
(***************************************************************************)
let gr_draw_item = g_item__draw_gr_item
and gr_item_managed = g_item__gr_item_callback
;;


(***************************************************************************)
(*                                                                         *)
(* g_menu.ml                                                               *)
(*                                                                         *)
(***************************************************************************)
let gr_draw_menu = g_menu__draw_gr_menu
and gr_erase_menu = g_menu__erase_gr_menu
and gr_menu_managed = g_menu__gr_menu_callback
;;


(***************************************************************************)
(*                                                                         *)
(* g_scroll.ml                                                             *)
(*                                                                         *)
(***************************************************************************)
let gr_elevator_width = g_scroll__elevator_width
and gr_elevator_height = g_scroll__elevator_height
and gr_scroll_width = g_scroll__scroll_width
and gr_scroll_course = g_scroll__scroll_course
and gr_draw_scrollbar = g_scroll__draw_gr_scrollbar
and gr_scrollbar_managed = g_scroll__gr_scrollbar_callback
;;


(***************************************************************************)
(*                                                                         *)
(* g_string.ml                                                             *)
(*                                                                         *)
(***************************************************************************)
let gr_draw_string = g_string__draw_gr_string
and gr_string_managed = g_string__gr_string_callback
;;


(***************************************************************************)
(*                                                                         *)
(* g_text.ml                                                               *)
(*                                                                         *)
(***************************************************************************)
let gr_lines_of_string = g_text__lines_of_string
and gr_string_of_lines = g_text__string_of_lines
and gr_make_text = g_text__make_text
and gr_draw_text = g_text__draw_gr_text
and gr_text_managed = g_text__gr_text_callback
and gr_text_find = g_text__search_string
and gr_text_goto = g_text__goto_text
and gr_text_replace = g_text__replace_string
and gr_text_save = g_text__save_gr_text
and gr_text_load = g_text__load_gr_text
and gr_get_selected_text = g_text__gr_text_get_selected_area
and gr_add_text = g_text__gr_text_add_text
and gr_del_selected_text = g_text__gr_text_del_selected_area
and gr_text_init = g_text__gr_init_text
;;


(***************************************************************************)
(*                                                                         *)
(* g_shell.ml                                                              *)
(*                                                                         *)
(***************************************************************************)
let gr_make_shell = g_shell__make_shell
and gr_draw_shell = g_shell__draw_gr_shell
and gr_shell_managed = g_shell__gr_shell_callback
and gr_camlwin_env = g_shell__camlwin_env
;;


(***************************************************************************)
(*                                                                         *)
(* g_toolb.ml                                                              *)
(*                                                                         *)
(***************************************************************************)
let gr_draw_toolbar = g_toolb__draw_gr_toolbar
and gr_toolbar_managed = g_toolb__gr_toolbar_callback
;;


(***************************************************************************)
(*                                                                         *)
(* g_list.ml                                                               *)
(*                                                                         *)
(***************************************************************************)
let gr_draw_list = g_list__draw_gr_list
and gr_list_managed = g_list__gr_list_callback
and gr_list_add_item = g_list__add_item
and gr_list_del_item = g_list__del_item
and gr_list_sort = g_list__list_sort
and gr_list_save = g_list__save_gr_list
and gr_list_load = g_list__load_gr_list
;;


(***************************************************************************)
(*                                                                         *)
(* g_graph.ml                                                              *)
(*                                                                         *)
(***************************************************************************)
let gr_draw_line = g_graph__draw_gr_line
and gr_draw_ellipse = g_graph__draw_gr_ellipse
and gr_draw_rectangle = g_graph__draw_gr_rectangle
;;


(***************************************************************************)
(*                                                                         *)
(* g_grpbut.ml                                                             *)
(*                                                                         *)
(***************************************************************************)
let gr_draw_grpbut = g_grpbut__draw_gr_grpbut
and gr_draw_unfilled_grpbut = g_grpbut__draw_unfilled_gr_grpbut
and gr_grpbut_managed = g_grpbut__gr_grpbut_callback
;;


(***************************************************************************)
(*                                                                         *)
(* g_grprad.ml                                                             *)
(*                                                                         *)
(***************************************************************************)
let gr_draw_grprad = g_grprad__draw_gr_grprad
and gr_draw_unfilled_grprad = g_grprad__draw_unfilled_gr_grprad
and gr_grprad_managed = g_grprad__gr_grprad_callback
;;


(***************************************************************************)
(*                                                                         *)
(* g_prompt.ml                                                             *)
(*                                                                         *)
(***************************************************************************)
let gr_draw_prompt = g_prompt__draw_gr_prompt;;


(***************************************************************************)
(*                                                                         *)
(* g_radio.ml                                                              *)
(*                                                                         *)
(***************************************************************************)
let gr_draw_radio = g_radio__draw_gr_radio
and gr_radio_managed = g_radio__gr_radio_callback
;;


(***************************************************************************)
(*                                                                         *)
(* g_helpb.ml                                                              *)
(*                                                                         *)
(***************************************************************************)
let gr_draw_helpbar = g_helpb__draw_gr_helpbar;;


(***************************************************************************)
(*                                                                         *)
(* g_html_?.ml                                                             *)
(*                                                                         *)
(***************************************************************************)
let gr_html_interpreter = g_html_i__html_interpreter
and gr_html_save = g_html_o__html_save
and gr_save_HTML_type = g_html_o__save_HTML_type_list 
and gr_html_anchor_list = g_html_d__html_anchor
and gr_HtmlList_to_Formated = g_html_d__HtmlList_to_Formated
;;

(***************************************************************************)
(*                                                                         *)
(* g_extext.ml                                                             *)
(*                                                                         *)
(***************************************************************************)
let gr_draw_extext = g_extext__draw_gr_extext
and gr_html_extext = g_extext__gr_extext_callback
and gr_extext_width = g_extext__extext_width
and gr_extext_goto_anchor = g_extext__extext_goto_anchor
and gr_extext_load = g_extext__extext_load
and gr_extext_save = g_extext__extext_save
and gr_extext_callback = g_extext__extext_empty_callback
;;


(***************************************************************************)
(*                                                                         *)
(* g_exprpt.ml                                                             *)
(*                                                                         *)
(***************************************************************************)
let gr_draw_exprompt = g_exprpt__draw_gr_exprompt
and gr_fline_to_string = g_exprpt__fline_to_string
;;


(***************************************************************************)
(*                                                                         *)
(* g_area.ml                                                               *)
(*                                                                         *)
(***************************************************************************)
let gr_draw_area = g_area__draw_gr_area
;;


(***************************************************************************)
(*                                                                         *)
(* g_mloop.ml                                                              *)
(*                                                                         *)
(***************************************************************************)
let gr_create_window = g_mloop__create_window
and gr_erase_window = g_mloop__erase_window
and gr_quit_callback = g_mloop__quit_callback
and gr_callback = g_mloop__call_callback
and gr_draw_graph_obj = g_mloop__draw_graph_obj
and gr_draw_window = g_mloop__redraw_window
and gr_graph_obj_callback = g_mloop__graph_obj_callback
and gr_which_window = g_mloop__which_window
and gr_main_loop = g_mloop__main_loop
and gr_block_loop = g_mloop__block_loop
and gr_use_time_event = g_mloop__use_time_event
and gr_no_time_event = g_mloop__no_time_event
;;



(***************************************************************************)
(*                                                                         *)
(* g_input.ml                                                              *)
(*                                                                         *)
(***************************************************************************)
let gr_input_string = g_input__input_string
and gr_input_natural = g_input__input_natural
and gr_input_int = g_input__input_int
and gr_input_hexa = g_input__input_hexa
and gr_input_float = g_input__input_float
and gr_input_password = g_input__input_password
and gr_input_filename =g_input__input_filename
;;


(***************************************************************************)
(*                                                                         *)
(* g_minput.ml                                                             *)
(*                                                                         *)
(***************************************************************************)
let gr_minput = g_minput__minput
and gr_string_of_melted = g_minput__string_of_melted  
and gr_int_of_melted = g_minput__int_of_melted
and gr_float_of_melted = g_minput__float_of_melted
and gr_bool_of_melted = g_minput__bool_of_melted
and gr_image_of_melted = g_minput__image_of_melted
;;


(***************************************************************************)
(*                                                                         *)
(* g_edit.ml                                                               *)
(*                                                                         *)
(***************************************************************************)

let gr_edit = g_edit__edit;;


(***************************************************************************)
(*                                                                         *)
(* g_wshell.ml                                                             *)
(*                                                                         *)
(***************************************************************************)

let gr_shell = g_wshell__gr_shell_window;;


(***************************************************************************)
(*                                                                         *)
(* g_warn.ml                                                               *)
(*                                                                         *)
(***************************************************************************)
let gr_warning = g_warn__create_warning
and gr_close_warning = g_warn__close_warning
and gr_warning1 = g_warn__warn_callback1
and gr_warning2 = g_warn__warn_callback2
and gr_warning3 = g_warn__warn_callback3
and gr_warn_button = g_warn__warn_button
;;


(***************************************************************************)
(*                                                                         *)
(* g_find.ml                                                               *)
(*                                                                         *)
(***************************************************************************)
let gr_find_in_text = g_find__find_in_text
and gr_replace_in_text = g_find__replace_in_text
;;


(***************************************************************************)
(*                                                                         *)
(* g_look.ml                                                               *)
(*                                                                         *)
(***************************************************************************)
let gr_look_menu = g_look__make_menu_look;;


(***************************************************************************)
(*                                                                         *)
(* g_file.ml                                                               *)
(*                                                                         *)
(***************************************************************************)
let gr_select_file = g_file__select_file
and gr_without_suffix = g_file__without_suffix
and gr_suffix_only = g_file__suffix_only
;;


(***************************************************************************)
(*                                                                         *)
(* g_select.ml                                                             *)
(*                                                                         *)
(***************************************************************************)
let gr_select = g_select__select;;


(***************************************************************************)
(*                                                                         *)
(* g_font.ml                                                               *)
(*                                                                         *)
(***************************************************************************)
let gr_select_font = g_font__select_font
;;

(***************************************************************************)
(*                                                                         *)
(* g_color.ml                                                              *)
(*                                                                         *)
(***************************************************************************)
let gr_select_color = g_color__select_color
;;


(***************************************************************************)
(*                                                                         *)
(* g_save.ml                                                               *)
(*                                                                         *)
(***************************************************************************)
let gr_output_window = g_save__output_window
and gr_input_window = g_save__input_window
;;






(***************************************************************************)
(*                                                                         *)
(* g_helpd.ml                                                               *)
(*                                                                         *)
(***************************************************************************)
let gr_open_help = g_helpd__open_help
;;




