#open "windows";;
#open "camlwin";;



let CamlprogVersion = 0.8;;




let prog_win_def = 
{
  win_left     = 20;
  win_top      = 320;
  win_width    = 300;
  win_height   = 150;
  win_id       = gr_undef_window;
  win_name     = "Caml Program Editor";
  win_state    = Destroyed
};;

let run_toplevel =
{
  it_window   = prog_win_def;
  it_name     = "To toplevel";
  it_state    = Unselected;
  it_callback = gr_do_nothing
};;

let run_compile =
{
  it_window   = prog_win_def;
  it_name     = "Compile";
  it_state    = Unselected;
  it_callback = gr_do_nothing
};;

let run_link =
{
  it_window   = prog_win_def;
  it_name     = "Link";
  it_state    = Unselected;
  it_callback = gr_do_nothing
};;

let run_make =
{
  it_window   = prog_win_def;
  it_name     = "Make";
  it_state    = Unselected;
  it_callback = gr_do_nothing
};;

let run_build =
{
  it_window   = prog_win_def;
  it_name     = "Build all";
  it_state    = Unselected;
  it_callback = gr_do_nothing
};;

let run_clean =
{
  it_window   = prog_win_def;
  it_name     = "Clean";
  it_state    = Unselected;
  it_callback = gr_do_nothing
};;

let run_run =
{
  it_window   = prog_win_def;
  it_name     = "Run";
  it_state    = Unselected;
  it_callback = gr_do_nothing
};;

let exec_camlicon =
{
  it_window   = prog_win_def;
  it_name     = "Caml Icon";
  it_state    = Unselected;
  it_callback = gr_do_nothing
};;

let exec_camldraw =
{
  it_window   = prog_win_def;
  it_name     = "Caml Design";
  it_state    = Unselected;
  it_callback = gr_do_nothing
};;

let exec_shell =
{
  it_window   = prog_win_def;
  it_name     = "Shell";
  it_state    = Unselected;
  it_callback = gr_do_nothing
};;

let search_find =
{
  it_window   = prog_win_def;
  it_name     = "Find";
  it_state    = Unselected;
  it_callback = gr_do_nothing
};;

let search_replace =
{
  it_window   = prog_win_def;
  it_name     = "Replace";
  it_state    = Unselected;
  it_callback = gr_do_nothing
};;

let search_line =
{
  it_window   = prog_win_def;
  it_name     = "Go to line...";
  it_state    = Unselected;
  it_callback = gr_do_nothing
};;

let proj_new =
{
  it_window   = prog_win_def;
  it_name     = "New Project";
  it_state    = Unselected;
  it_callback = gr_do_nothing
};;

let proj_load =
{
  it_window   = prog_win_def;
  it_name     = "Load Project";
  it_state    = Unselected;
  it_callback = gr_do_nothing
};;

let proj_save =
{
  it_window   = prog_win_def;
  it_name     = "Save Project";
  it_state    = Unselected;
  it_callback = gr_do_nothing
};;

let file_new =
{
  it_window   = prog_win_def;
  it_name     = "New";
  it_state    = Unselected;
  it_callback = gr_do_nothing
};;

let file_load =
{
  it_window   = prog_win_def;
  it_name     = "Load...";
  it_state    = Unselected;
  it_callback = gr_do_nothing
};;

let file_save =
{
  it_window   = prog_win_def;
  it_name     = "Save";
  it_state    = Unselected;
  it_callback = gr_do_nothing
};;

let file_saveas =
{
  it_window   = prog_win_def;
  it_name     = "Save as...";
  it_state    = Unselected;
  it_callback = gr_do_nothing
};;

let file_exit =
{
  it_window   = prog_win_def;
  it_name     = "Exit";
  it_state    = Unselected;
  it_callback = gr_do_nothing
};;

let edit_copy =
{
  it_window   = prog_win_def;
  it_name     = "Copy";
  it_state    = Unselected;
  it_callback = gr_do_nothing
};;

let edit_past =
{
  it_window   = prog_win_def;
  it_name     = "Past";
  it_state    = Unselected;
  it_callback = gr_do_nothing
};;

let edit_cut =
{
  it_window   = prog_win_def;
  it_name     = "Cut";
  it_state    = Unselected;
  it_callback = gr_do_nothing
};;

let edit_clear =
{
  it_window   = prog_win_def;
  it_name     = "Clear";
  it_state    = Unselected;
  it_callback = gr_do_nothing
};;

let prog_text = gr_make_text
{
  t_window    = prog_win_def;
  t_left      = 1;
  t_top       = 140;
  t_width     = 297;
  t_height    = 127;
  t_name      = gr_lines_of_string "\n";
  t_state     = Editable;
  t_scroll    = Dscroll
};;

let prog_help =
{
  hl_window   = prog_win_def;
  hl_help     = ""
};;

let run_menu =
{
  mn_window   = prog_win_def;
  mn_left     = 0;
  mn_top      = 0;
  mn_nu_item  = 0;
  mn_hide_area= gr_empty_image;
  mn_name     = "Run";
  mn_state    = Unvisible;
  mn_items    = [|
                 run_toplevel;
                 run_compile;
                 run_link;
                 run_make;
                 run_build;
                 run_clean;
                 run_run
                |]
};;

let exec_menu =
{
  mn_window   = prog_win_def;
  mn_left     = 0;
  mn_top      = 0;
  mn_nu_item  = 0;
  mn_hide_area= gr_empty_image;
  mn_name     = "Exec";
  mn_state    = Unvisible;
  mn_items    = [|
                 exec_camlicon;
                 exec_camldraw;
                 exec_shell
                |]
};;

let search_menu = 
{
  mn_window   = prog_win_def;
  mn_left     = 0;
  mn_top      = 0;
  mn_nu_item  = 0;
  mn_hide_area= gr_empty_image;
  mn_name     = "Search";
  mn_state    = Unvisible;
  mn_items    = [|
                 search_find;
                 search_replace;
                 search_line
                |]
};;

let proj_menu = 
{
  mn_window   = prog_win_def;
  mn_left     = 0;
  mn_top      = 0;
  mn_nu_item  = 0;
  mn_hide_area= gr_empty_image;
  mn_name     = "Project";
  mn_state    = Unvisible;
  mn_items    = [|
                 proj_new;
                 proj_load;
                 proj_save
                |]
};;

let edit_menu =
{
  mn_window   = prog_win_def;
  mn_left     = 0;
  mn_top      = 0;
  mn_nu_item  = 0;
  mn_hide_area= gr_empty_image;
  mn_name     = "Edit";
  mn_state    = Unvisible;
  mn_items    = [|
                 edit_copy;
                 edit_past;
                 edit_cut;
                 edit_clear
                |]
};;

let file_menu =
{
  mn_window   = prog_win_def;
  mn_left     = 0;
  mn_top      = 0;
  mn_nu_item  = 0;
  mn_hide_area= gr_empty_image;
  mn_name     = "File";
  mn_state    = Unvisible;
  mn_items    = [|
                 file_new;
                 file_load;
                 file_save;
                 file_saveas;
                 file_exit
                |]
};;

let prog_toolb = 
{
  tb_window   = prog_win_def;
  tb_items    = [|
                 file_menu;
                 edit_menu;
                 proj_menu;
                 search_menu;
                 run_menu;
                 exec_menu;
                 (gr_look_menu prog_win_def)
                |]
};;

let prog_win = 
{
  win_def      = prog_win_def;
  win_objects  = [
                  g_helpbar   prog_help;
                  g_toolbar   prog_toolb;
                  g_text      prog_text
                 ];
  time_callback = gr_do_nothing;
  resize_callback = gr_do_nothing;
  help_file = "index.html";
  miscellaneous = [| |]
};;




