#open "sys";;
#open "windows";;
#open "camlwin";;

#open "newicon";;
#open "saveicon";;
#open "ic_trans";;




let icon_color=ref black;;
let icon_file=ref "";;
let icon_modified=ref false;;
let scale = 4;;







let camlicon_win =
{
  win_id = gr_undef_window;
  win_top = screen_height () - 20;
  win_left = 20;
  win_width = 125;
  win_height = 140;
  win_name = "Caml Icon";
  win_state = Destroyed
};;


let iconnew_file =
{
  it_window=camlicon_win;
  it_state=Unselected;
  it_name="New icon";
  it_callback=gr_do_nothing
};;

let iconload_file =
{
  it_window=camlicon_win;
  it_state=Unselected;
  it_name="Load icon";
  it_callback=gr_do_nothing
};;

let iconsave_file =
{
  it_window=camlicon_win;
  it_state=Unselected;
  it_name="Save icon";
  it_callback=gr_do_nothing
};;

let iconsaveas_file =
{
  it_window=camlicon_win;
  it_state=Unselected;
  it_name="Save icon as...";
  it_callback=gr_do_nothing
};;

let iconexit_file =
{
  it_window=camlicon_win;
  it_state=Unselected;
  it_name="Exit";
  it_callback= gr_do_nothing
};;

let menu_file =
{
   mn_window=camlicon_win;
   mn_left=0;
   mn_top=0;
   mn_state=Unvisible;
   mn_nu_item=0;
   mn_name="File";
   mn_items=[| iconnew_file;
               iconload_file;
               iconsave_file;
               iconsaveas_file;
               iconexit_file
            |];
   mn_hide_area=gr_empty_image
};;

let camlicon_toolbar =
{
  tb_window=camlicon_win;
  tb_items=[| menu_file; (gr_look_menu  camlicon_win)|]
};;


let coord_prompt =
{
  pt_window=camlicon_win;
  pt_left=5;
  pt_top=55;
  pt_name="x * y ="
};;

let icon_coord =
{
  st_window   = camlicon_win;
  st_left     = 35;
  st_top      = 56;
  st_width    = 35;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = View_only;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;

let name_prompt =
{
  pt_window=camlicon_win;
  pt_left=5;
  pt_top=40;
  pt_name="Name:"
};;

let icon_name =
{
  st_window   = camlicon_win;
  st_left     = 35;
  st_top      = 42;
  st_width    = 35;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = View_only;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;

let color_size = gr_to_real_coord 10;;

let color_buttons=
{
  gb_window=camlicon_win;
  gb_top=camlicon_win.win_height-15;
  gb_left=camlicon_win.win_width-42;
  gb_width=40;
  gb_height=camlicon_win.win_height-18;
  gb_delta=2;
  gb_btwidth=14;
  gb_btheight=14;
  gb_dir=Vertical;
  gb_button=0;
  gb_name=if gr_is_color_look ()
          then
            [| bitmap_type (make_image (make_matrix color_size color_size black));
               bitmap_type (make_image (make_matrix color_size color_size red));
               bitmap_type (make_image (make_matrix color_size color_size green));
               bitmap_type (make_image (make_matrix color_size color_size blue));
               bitmap_type (make_image (make_matrix color_size color_size yellow));
               bitmap_type (make_image (make_matrix color_size color_size cyan));
               bitmap_type (make_image (make_matrix color_size color_size magenta));
               bitmap_type (make_image (make_matrix color_size color_size white));
               bitmap_type (make_image (make_matrix color_size color_size gr_grey))
             |]
          else
            [| bitmap_type (make_image (make_matrix color_size color_size black));
               bitmap_type (make_image (make_matrix color_size color_size white));
               bitmap_type (make_image ic_trans)
             |];

  gb_callback= gr_do_nothing
};;



let icon=
{
  bm_window=camlicon_win;
  bm_left=10;
  bm_top=30;
  bm_bitmap=make_image (make_matrix gr_icon_size gr_icon_size transp);
  bm_callback=gr_do_nothing
};;

let icon_frame =
{
  bt_window=camlicon_win;
  bt_left=8;
  bt_top=32;
  bt_width=gr_to_win_coord (gr_icon_size)+4;
  bt_height=gr_to_win_coord (gr_icon_size)+4;
  bt_name=string_type "";
  bt_state=Unused;
  bt_callback= gr_do_nothing
};;



let Design_area = ref (make_matrix gr_icon_size gr_icon_size transp);;




let change_color Color x y left top =
  if gr_is_color_look ()
  then
  (
    if Color = transp
    then set_color (gr_backcolor ())
    else set_color Color;
    fill_rect (left+(x*scale)+1) (top-(y*scale)-scale+1)
              (scale-1) (scale-1)
  )
  else
  (
    if Color = transp
    then
    (
      set_color white;
      fill_rect (left+(x*scale)+1) (top-(y*scale)-scale+1)
                (scale-1) (scale-1);
      set_color black;
      plot (left+(x*scale)+(scale/2)) (top-(y*scale)-(scale/2))
    )
    else
    (
      set_color Color;
      fill_rect (left+(x*scale)+1) (top-(y*scale)-scale+1)
                (scale-1) (scale-1)
    )
  )
;;





let draw_drawing_area UserObj =
  let size=image_size icon.bm_bitmap in
    let width = fst size
    and height = snd size
    and color = if gr_backcolor ()=white then black else white
    and x = gr_to_real_coord ( match UserObj.us_param.(0) with
                                 int_type n -> n
                               | _          -> 0
                             )
    and y = gr_to_real_coord ( match UserObj.us_param.(1) with
                                 int_type n -> n
                               | _          -> 0
                             )
    in

      set_color color;
      for i=0 to width do
      (
        moveto (x+scale*i) y;
        lineto (x+scale*i) (y-height*scale)
      ) done;
      for i=0 to height do
      (
        moveto x (y-scale*i);
        lineto (x+width*scale) (y-scale*i)
      ) done;
      for i=0 to (width - 1) do
        for j= 0 to (height - 1) do
        (
            change_color !Design_area.(i).(j) i j x y
        )
        done
      done
;;



let user_bitmap=
{
  us_window=camlicon_win;
  us_param=[| (int_type 10); (int_type (camlicon_win.win_height-15)) |];
  us_draw=draw_drawing_area;
  us_callback= gr_do_nothing
};;




let CamliconWin =
{
  win_def=camlicon_win;
  win_objects=[
               g_button  icon_frame;
               g_bitmap  icon;
               g_toolbar camlicon_toolbar;
               g_grpbut  color_buttons;
               g_prompt  name_prompt;
               g_string  icon_name;
               g_prompt  coord_prompt;
               g_string  icon_coord;
               g_user    user_bitmap
              ];
  time_callback = gr_do_nothing;
  resize_callback = gr_do_nothing;
  help_file = "camlicon.html";
  miscellaneous = [| |]
};;








let Actualise_icon () =
  let sizes = image_size icon.bm_bitmap in
    let width  = fst sizes
    and height = snd sizes in
      Design_area := make_matrix width height transp;
      for i= 0 to (width-1) do
        for j = 0 to (height-1) do
           !Design_area.(i).(j) <- pixel_image icon.bm_bitmap i j
        done
      done
;;











let DrawCoord x y =
  icon_coord.st_name <- (string_of_int x) ^ " * " ^ (string_of_int y);
  gr_draw_string icon_coord
;;



let DrawIcon_callback User Event =
  if Event.button=true
  then
    (
      let width  =scale * fst (image_size icon.bm_bitmap)
      and height =scale * snd (image_size icon.bm_bitmap)
      and left = gr_to_real_coord ( match User.us_param.(0) with
                                     int_type n -> n
                                    | _          -> 0
                                  )
      and top  = gr_to_real_coord ( match User.us_param.(1) with
                                     int_type n -> n
                                    | _          -> 0
                                  )
      in
        let mouse_coord={x=Event.mouse_x; y=Event.mouse_y}
        and Bitmap_area={x1=left;
                         y1=top-height;
                         x2=left+width;
                         y2=top}
        and w = (width/scale) - 1
        and h = (height/scale) - 1 in
          if gr_inside mouse_coord Bitmap_area 
          then
            (
              let x = min w ((Event.mouse_x-left)/scale) 
              and y = min h ((top-Event.mouse_y)/scale) 
              and col = !icon_color in
                icon_modified := true;
                DrawCoord x y;
                if not col=transp
                then set_color col
                else set_color (gr_backcolor ());
                plot_image icon.bm_bitmap x y col;
                plot ((gr_to_real_coord icon.bm_left)+x)
                     ((gr_to_real_coord icon.bm_top)-y);
                change_color col x y left top;
                !Design_area.(x).(y) <- col;
                true
            )
          else false
    )
  else false
;;



let DrawIcon User Event =
  if (DrawIcon_callback User Event)
  then
    (
      while (DrawIcon_callback User (get_event([Button_up; Mouse_motion]))) do
      () done;
      true
    )
  else false
;;





let DrawName () =
  icon_name.st_name <- !icon_file;
  gr_draw_string icon_name
;;





let SaveIcon Graph_obj Event =
  if !icon_file=""
  then icon_file := gr_without_suffix(gr_input_filename "bitmap's name:" "icon");
  DrawName ();
  save_bitmap icon.bm_bitmap !icon_file;
  icon_modified := false;
  true
;;





let OpenNewIcon Obj Event =
  gr_block_loop NewiconWin;
  true
;;


let NewIcon Graph_obj Event =
  let width=(int_of_string newicon_width.st_name)
  and height=(int_of_string newicon_height.st_name) in
    icon.bm_bitmap <- make_image (make_matrix height width transp);
    Design_area := make_matrix width height transp;
    icon_file := "";
    icon_name.st_name <- "";
    icon_modified := false;

    camlicon_win.win_width <-  max (60+gr_to_win_coord (width*scale)) 125;
    camlicon_win.win_height <- max (76+gr_to_win_coord (height*scale)) 140;
    user_bitmap.us_param.(1) <- int_type (camlicon_win.win_height-15);
    color_buttons.gb_top <- (camlicon_win.win_height-15);
    color_buttons.gb_left <- (camlicon_win.win_width-42);
    icon_frame.bt_width <- gr_to_win_coord (width)+4;
    icon_frame.bt_height <- gr_to_win_coord (height)+4;

    gr_erase_window NewiconWin.win_def;
    set_current_window camlicon_win.win_id;
    set_window_car camlicon_win.win_left
                   (camlicon_win.win_top-(gr_to_real_coord camlicon_win.win_height))
                   (gr_to_real_coord camlicon_win.win_width)
                   (gr_to_real_coord camlicon_win.win_height);
    gr_draw_window camlicon_win.win_id;
    true
;;



let SaveModifThenNew Obj Event =
  gr_close_warning Obj Event;
  SaveIcon Obj Event;
  OpenNewIcon Obj Event
;;

let CancelModifThenNew Obj Event =
  gr_close_warning Obj Event;
  OpenNewIcon Obj Event
;;


let CreateNewIcon Obj Event =
  if !icon_modified
  then
    (
      gr_warning ("The modifications aren't saved. Save them ?")
                 [| {warn_name="Yes"; warn_callback=SaveModifThenNew};
                    {warn_name="No"; warn_callback=CancelModifThenNew};
                    {warn_name="Cancel"; warn_callback=gr_close_warning}
                 |];
      true
    )
  else OpenNewIcon Obj Event
;;




let load_icon Name =
  icon_file := Name;
  icon.bm_bitmap <- load_bitmap Name icon.bm_bitmap;
  icon_name.st_name <- Name;
  icon_modified := false;
  let width=fst (image_size icon.bm_bitmap)
  and height=snd (image_size icon.bm_bitmap) in
    camlicon_win.win_width <-  max (60+gr_to_win_coord (width*scale)) 125;
    camlicon_win.win_height <- max (76+gr_to_win_coord (height*scale)) 140;
    user_bitmap.us_param.(1) <- int_type (camlicon_win.win_height-15);
    color_buttons.gb_top <- (camlicon_win.win_height-15);
    color_buttons.gb_left <- (camlicon_win.win_width-42);
    icon_frame.bt_width <- gr_to_win_coord (width)+4;
    icon_frame.bt_height <- gr_to_win_coord (height)+4
;;



let SaveIconAs Graph_obj Event =
  icon_file := "";
  SaveIcon Graph_obj Event
;;

let LoadIcon Graph_obj Event =
  let Name=(gr_without_suffix (gr_select_file "*.ml")) in
    load_icon Name;
    Actualise_icon ();
    set_current_window camlicon_win.win_id;
    set_window_car camlicon_win.win_left
                   (camlicon_win.win_top-(gr_to_real_coord camlicon_win.win_height))
                   (gr_to_real_coord camlicon_win.win_width)
                   (gr_to_real_coord camlicon_win.win_height);
    gr_draw_window camlicon_win.win_id;

    true
;;





let SaveModifThenLoad Obj Event =
  gr_close_warning Obj Event;
  SaveIcon Obj Event;
  LoadIcon Obj Event
;;

let CancelModifThenLoad Obj Event =
  gr_close_warning Obj Event;
  LoadIcon Obj Event
;;

let LoadNewIcon Obj Event =
  if !icon_modified
  then
    (
      gr_warning ("The modifications aren't saved. Save them ?")
                 [| {warn_name="Yes"; warn_callback=SaveModifThenLoad};
                    {warn_name="No"; warn_callback=CancelModifThenLoad};
                    {warn_name="Cancel"; warn_callback=gr_close_warning}
                 |];
      true
    )
  else LoadIcon Obj Event
;;












let SetColor Grpbut Event =
  if gr_is_color_look ()
  then
  (
    match color_buttons.gb_button with
      0 -> icon_color := black
    | 1 -> icon_color := red
    | 2 -> icon_color := green
    | 3 -> icon_color := blue
    | 4 -> icon_color := yellow
    | 5 -> icon_color := cyan
    | 6 -> icon_color := magenta
    | 7 -> icon_color := white
    | 8 -> icon_color := transp
    | _ -> ()
  )
  else
  (
    match color_buttons.gb_button with
      0 -> icon_color := black
    | 1 -> icon_color := white
    | 2 -> icon_color := transp
    | _ -> ()
  );
  true
;;





iconnew_file.it_callback <- CreateNewIcon;;
iconload_file.it_callback <- LoadNewIcon;;
iconsave_file.it_callback <- SaveIcon;;
iconsaveas_file.it_callback <- SaveIconAs;;

user_bitmap.us_callback <- DrawIcon;;
color_buttons.gb_callback <- SetColor;;
newicon_ok.bt_callback <- NewIcon;;






