#open "windows";;
#open "camlwin";;


let gr_help_width = 200;;
let gr_help_height = 100;;


let HtmlWin_def = 
{
  win_left     = (screen_width() - (gr_to_real_coord gr_help_width))/2;
  win_top      = (screen_height() + (gr_to_real_coord gr_help_height))/2;
  win_width    = gr_help_width;
  win_height   = gr_help_height;
  win_id       = gr_undef_window;
  win_name     = "Help Browser";
  win_state    = Destroyed
};;

let html_draw = 
{
  extx_window  = HtmlWin_def;
  extx_name    = "";
  extx_left    = 2;
  extx_top     = 96;
  extx_width   = gr_help_width - 40;
  extx_height  = 80;
  extx_scroll   = 0;
  extx_anchors = [];
  extx_content = [| |];
  extx_callback = gr_extext_callback
};;

let html_load = 
{
  bt_window   = HtmlWin_def;
  bt_left     = gr_help_width - 30;
  bt_top      = 95;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Load";
  bt_callback = gr_do_nothing
};;

let html_save = 
{
  bt_window   = HtmlWin_def;
  bt_left     = gr_help_width - 30;
  bt_top      = 80;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Save";
  bt_callback = gr_do_nothing
};;

let html_anchor = 
{
  bt_window   = HtmlWin_def;
  bt_left     = gr_help_width - 30;
  bt_top      = 65;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Anchor"; 
  bt_callback = gr_do_nothing
};;

let html_help = 
{
  hl_window   = HtmlWin_def;
  hl_help     = ""
};;

let html_quit = 
{
  bt_window   = HtmlWin_def;
  bt_left     = gr_help_width - 30;
  bt_top      = 28;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Quit";
  bt_callback = gr_do_nothing
};;

let HtmlWin = 
{
  win_def      = HtmlWin_def;
  win_objects  = [
                  g_extext    html_draw;
                  g_button    html_load;
                  g_button    html_save;
                  g_button    html_anchor;
                  g_helpbar   html_help;
                  g_button    html_quit
                 ];
  time_callback  = gr_do_nothing;
  resize_callback  = gr_do_nothing;
  help_file = "camlhelp.html";
  miscellaneous = [| |]
};;

