#open "windows";;
#open "camlwin";;


#open "ic_but";;
#open "ic_str";;
#open "ic_scro";;
#open "ic_tool";;
#open "ic_prom";;
#open "ic_icon";;
#open "ic_tex";;
#open "ic_list";;
#open "ic_help";;
#open "ic_radio";;
#open "ic_grpb";;
#open "ic_grpr";;
#open "ic_gra";;
#open "ic_shell";;
#open "ic_area";;
#open "ic_expt";;
#open "ic_extx";;




let camldraw_win =
{
  win_id = gr_undef_window;
  win_top = screen_height () - 20;
  win_left = 20;
  win_width = 160;
  win_height = 117;
  win_name = "Caml Design";
  win_state = Destroyed
};;


let drawnew_file =
{
  it_window=camldraw_win;
  it_state=Unselected;
  it_name="New window";
  it_callback= gr_do_nothing
};;

let drawload_file =
{
  it_window=camldraw_win;
  it_state=Unselected;
  it_name="Load window";
  it_callback= gr_do_nothing
};;

let drawsave_file =
{
  it_window=camldraw_win;
  it_state=Unselected;
  it_name="Save window";
  it_callback= gr_do_nothing
};;

let drawsaveas_file =
{
  it_window=camldraw_win;
  it_state=Unselected;
  it_name="Save window as...";
  it_callback= gr_do_nothing
};;

let drawexit_file =
{
  it_window=camldraw_win;
  it_state=Unselected;
  it_name="Exit";
  it_callback= gr_do_nothing
};;

let menu_file =
{
  mn_window=camldraw_win;
  mn_left=0;
  mn_top=0;
  mn_state=Unvisible;
  mn_nu_item=0;
  mn_name="File";
  mn_items=[|
             drawnew_file;
             drawload_file;
             drawsave_file;
             drawsaveas_file;
             drawexit_file
           |];
  mn_hide_area=gr_empty_image
};;



let drawedit_func =
{
  it_window=camldraw_win;
  it_state=Unselected;
  it_name="New callback";
  it_callback= gr_do_nothing
};;

let drawnew_func =
{
  it_window=camldraw_win;
  it_state=Unselected;
  it_name="New function";
  it_callback= gr_do_nothing
};;

let drawlist_func =
{
  it_window=camldraw_win;
  it_state=Unselected;
  it_name="Functions list";
  it_callback= gr_do_nothing
};;


let menu_func =
{
  mn_window=camldraw_win;
  mn_left=0;
  mn_top=0;
  mn_state=Unvisible;
  mn_nu_item=0;
  mn_name="Functions";
  mn_items=[|
             drawedit_func;
             drawnew_func;
             drawlist_func
           |];
  mn_hide_area=gr_empty_image
};;


let drawresize_window =
{
  it_window=camldraw_win;
  it_state=Unselected;
  it_name="Window char";
  it_callback= gr_do_nothing
};;

let drawlist_window =
{
  it_window=camldraw_win;
  it_state=Unselected;
  it_name="Window Objects";
  it_callback= gr_do_nothing
};;

let drawpos_window =
{
  it_window=camldraw_win;
  it_state=Unselected;
  it_name="Save Window Pos";
  it_callback= gr_do_nothing
};;

let menu_window =
{
  mn_window=camldraw_win;
  mn_left=0;
  mn_top=0;
  mn_state=Unvisible;
  mn_nu_item=0;
  mn_name="Window";
  mn_items=[|
             drawresize_window;
             drawlist_window;
             drawpos_window
           |];
  mn_hide_area=gr_empty_image
};;

let camldraw_toolbar =
{
  tb_window=camldraw_win;
  tb_items=[| menu_file; menu_func; menu_window;
              (gr_look_menu camldraw_win)
           |]
};;


let camldraw_buttons=
{
  gb_window=camldraw_win;
  gb_top=104;
  gb_left=2;
  gb_width=camldraw_win.win_width-5;
  gb_height=77;
  gb_delta=5;
  gb_btwidth=25;
  gb_btheight=12;
  gb_dir=Horizontal;
  gb_button=0;
  gb_name=[| bitmap_type (make_image ic_but);
             bitmap_type (make_image ic_str);
             bitmap_type (make_image ic_tex);
             bitmap_type (make_image ic_tool);
             bitmap_type (make_image ic_list);
             bitmap_type (make_image ic_prom);
             bitmap_type (make_image ic_icon);
             bitmap_type (make_image ic_scro);
             bitmap_type (make_image ic_help);
             bitmap_type (make_image ic_radio);
             bitmap_type (make_image ic_grpb);
             bitmap_type (make_image ic_grpr);
             bitmap_type (make_image ic_gra);
             bitmap_type (make_image ic_shell);
             bitmap_type (make_image ic_area);
             bitmap_type (make_image ic_expt);
             bitmap_type (make_image ic_extx)
           |];
  gb_callback= gr_do_nothing
};;

let camldraw_helpbar =
{
  hl_window=camldraw_win;
  hl_help="Welcome in camldsgn"
};;

let camldraw_promptsize =
{
  pt_window=camldraw_win;
  pt_left=90;
  pt_top=20;
  pt_name="Size:"
};;

let camldraw_promptpos =
{
  pt_window=camldraw_win;
  pt_left=5;
  pt_top=20;
  pt_name="Position:"
};;

let camldraw_size =
{
  st_window   = camldraw_win;
  st_left     = 110;
  st_top      = 22;
  st_width    = 45;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;

let camldraw_pos =
{
  st_window   = camldraw_win;
  st_left     = 40;
  st_top      = 22;
  st_width    = 45;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;








let CamldrawWin =
{
  win_def=camldraw_win;
  win_objects=[ g_toolbar camldraw_toolbar;
                g_helpbar camldraw_helpbar;
                g_grpbut  camldraw_buttons;
                g_prompt  camldraw_promptsize;
                g_string  camldraw_size;
                g_prompt  camldraw_promptpos;
                g_string  camldraw_pos
                       ];
  time_callback = gr_do_nothing;
  resize_callback = gr_do_nothing;
  help_file = "camldsgn";
  miscellaneous = [| |]
};;





let design_win =
{
  win_id = gr_undef_window;
  win_top = 0;
  win_left = 0;
  win_width = 150;
  win_height = 100;
  win_name = "Design window";
  win_state = Destroyed
};;

let DesignWin =
{
  win_def=design_win;
  win_objects=[];
  time_callback = gr_do_nothing;
  resize_callback = gr_do_nothing;
  help_file = "";
  miscellaneous = [| |]
};;

