#open "windows";;
#open "camlwin";;


#open "funcdraw";;
#open "globdraw";;
#open "confdraw";;
#open "camlicon";;
#open "saveicon";;



let cfg_button_def = 
{
  win_left     = 31;
  win_top      = 305;
  win_width    = 150;
  win_height   = 125;
  win_id       = gr_undef_window;
  win_name     = "Button Configuration";
  win_state    = Destroyed
};;

let button_title =
{
  pt_window   = cfg_button_def;
  pt_left     = 37;
  pt_top      = 122;
  pt_name     = "Button Configuration"
};;

let button_help =
{
  hl_window   = cfg_button_def;
  hl_help     = "Press Ok when finshed"
};;

let button_ok =
{
  bt_window   = cfg_button_def;
  bt_left     = 37;
  bt_top      = 24;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Ok";
  bt_callback = gr_do_nothing
};;

let button_cancel =
{
  bt_window   = cfg_button_def;
  bt_left     = 85;
  bt_top      = 24;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Cancel";
  bt_callback = gr_do_nothing
};;

let button_pt_idname =
{
  pt_window   = cfg_button_def;
  pt_left     = 5;
  pt_top      = 105;
  pt_name     = "Id name:"
};;

let button_pt_name =
{
  pt_window   = cfg_button_def;
  pt_left     = 5;
  pt_top      = 97;
  pt_name     = "Name:"
};;

let button_pt_callback =
{
  pt_window   = cfg_button_def;
  pt_left     = 5;
  pt_top      = 80;
  pt_name     = "Callback:"
};;

let button_idname =
{
  st_window   = cfg_button_def;
  st_left     = 40;
  st_top      = 107;
  st_width    = 75;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;

let button_name =
{
  st_window   = cfg_button_def;
  st_left     = 40;
  st_top      = 95;
  st_width    = 75;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = View_only;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;

let button_callback =
{
  st_window   = cfg_button_def;
  st_left     = 40;
  st_top      = 82;
  st_width    = 75;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;

let button_type =
{
  gb_window   = cfg_button_def;
  gb_left     = 7;
  gb_top      = 55;
  gb_width    = 137;
  gb_height   = 18;
  gb_btwidth  = 40;
  gb_btheight = 10;
  gb_delta    = 4;
  gb_button   = 0;
  gb_dir      = Vertical;
  gb_name     = [|
                  string_type "Text";
                  string_type "Bitmap";
                  string_type "Integer"
                |];
  gb_callback = gr_do_nothing
};;

let button_edit =
{
  bt_window   = cfg_button_def;
  bt_left     = 121;
  bt_top      = 82;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Edit";
  bt_callback = gr_do_nothing
};;

let button_pt_label =
{
  pt_window   = cfg_button_def;
  pt_left     = 52;
  pt_top      = 62;
  pt_name     = "Label type:"
};;

let button_change =
{
  bt_window   = cfg_button_def;
  bt_left     = 121;
  bt_top      = 95;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Edit";
  bt_callback = gr_do_nothing
};;

let cfg_button =
{
  win_def      = cfg_button_def;
  win_objects  = [
                  g_prompt    button_title;
                  g_helpbar   button_help;
                  g_button    button_ok;
                  g_button    button_cancel;
                  g_prompt    button_pt_idname;
                  g_prompt    button_pt_name;
                  g_prompt    button_pt_callback;
                  g_string    button_idname;
                  g_string    button_name;
                  g_string    button_callback;
                  g_grpbut    button_type;
                  g_button    button_edit;
                  g_prompt    button_pt_label;
                  g_button    button_change
                 ];
  time_callback = gr_do_nothing;
  resize_callback = gr_do_nothing;
  help_file = "";
  miscellaneous = [| |]
};;




let button_def = ref {id_name=""; callback=""; images_names=[| |]};;
let button_save = ref "";;


let button_init Name Def =
  (
    match (nth_char Name 0) with
      `b` -> button_type.gb_button <- 1
    | `i` -> button_type.gb_button <- 2
    | _   -> button_type.gb_button <- 0
  );
  button_def  := Def;
  button_save := Name;
  button_idname.st_cursor <-0;
  button_name.st_cursor <-0;
  button_callback.st_cursor <-0;
  button_idname.st_1st_char <-0;
  button_name.st_1st_char <-0;
  button_callback.st_1st_char <-0;
  button_idname.st_name <- Def.id_name;
  button_name.st_name <- Name;
  button_callback.st_name <- Def.callback
;;


let button_restore () =
  button_idname.st_name <- !button_def.id_name;
  button_name.st_name <- !button_save;
  button_callback.st_name <- !button_def.callback
;;



let CloseButtonCfg Obj Event =
  gr_erase_window cfg_button.win_def
;;

let CancelButtonCfg Obj Event =
  button_restore ();
  gr_erase_window cfg_button.win_def
;;

let EditButtonCfg Obj Event =
  EditCallback button_callback.st_name;
  true
;;

let ChangeButtonCfg Obj Event =
  let len=string_length button_name.st_name
  and str=button_name.st_name in
    let name=sub_string str 2 (len-2) in
  (
  match button_type.gb_button with
    1 -> (* button with bitmap label *)
        if nth_char str 0=`b`
        then
        (
          load_icon name;
          icon_name.st_name <- name
        )
        else icon_name.st_name <- "";
        gr_block_loop CamliconWin;
        button_name.st_name <- string_of_melted (bitmap_type gr_empty_image)
                                                !icon_file
  | 2 -> (* button with int label *)
        let label_init= if nth_char str 0=`i`
                        then int_of_string name
                        else 0 in
        button_name.st_name <-
            string_of_melted (int_type (gr_input_int "Label:"
                                                     label_init)
                             )
                             ""
  | _ -> (* button with text label *)
        let label_init= if nth_char str 0=`s`
                        then name
                        else "Button" in
        button_name.st_name <-
            string_of_melted (string_type (gr_input_string "Label:"
                                                           label_init)
                             )
                             ""
  );
  gr_draw_string button_name;
  true
;;

button_ok.bt_callback <- CloseButtonCfg;;
button_cancel.bt_callback <- CancelButtonCfg;;
button_edit.bt_callback <- EditButtonCfg;;
button_change.bt_callback <- ChangeButtonCfg;;

