#open "windows";;
#open "camlwin";;

#open "funcdraw";;
#open "camlicon";;



let cfg_bitmap_def =
{
  win_left     = 33;
  win_top      = 267;
  win_width    = 150;
  win_height   = 75;
  win_id       = gr_undef_window;
  win_name     = "Bitmap Configuration";
  win_state    = Destroyed
};;

let bitmap_title =
{
  pt_window   = cfg_bitmap_def;
  pt_left     = 38;
  pt_top      = 72;
  pt_name     = "Bitmap Configuration"
};;

let bitmap_help =
{
  hl_window   = cfg_bitmap_def;
  hl_help     = "Press Ok when finished"
};;

let bitmap_ok =
{
  bt_window   = cfg_bitmap_def;
  bt_left     = 32;
  bt_top      = 25;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Ok";
  bt_callback = gr_do_nothing
};;

let bitmap_cancel =
{
  bt_window   = cfg_bitmap_def;
  bt_left     = 82;
  bt_top      = 25;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Cancel";
  bt_callback = gr_do_nothing
};;

let bitmap_pr_idname =
{
  pt_window   = cfg_bitmap_def;
  pt_left     = 5;
  pt_top      = 60;
  pt_name     = "Id name:"
};;

let bitmap_pr_callback =
{
  pt_window   = cfg_bitmap_def;
  pt_left     = 5;
  pt_top      = 50;
  pt_name     = "Callback:"
};;

let bitmap_idname =
{
  st_window   = cfg_bitmap_def;
  st_left     = 42;
  st_top      = 62;
  st_width    = 75;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;

let bitmap_callback =
{
  st_window   = cfg_bitmap_def;
  st_left     = 42;
  st_top      = 52;
  st_width    = 75;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;

let bitmap_image =
{
  bt_window   = cfg_bitmap_def;
  bt_left     = 43;
  bt_top      = 41;
  bt_width    = 50;
  bt_height   = 11;
  bt_state    = Up;
  bt_name     = string_type "Edit bitmap";
  bt_callback = gr_do_nothing
};;

let bitmap_pr_editbitmap =
{
  pt_window   = cfg_bitmap_def;
  pt_left     = 5;
  pt_top      = 37;
  pt_name     = "Bitmap:"
};;

let bitmap_edit =
{
  bt_window   = cfg_bitmap_def;
  bt_left     = 120;
  bt_top      = 53;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Edit";
  bt_callback = gr_do_nothing
};;

let cfg_bitmap =
{
  win_def      = cfg_bitmap_def;
  win_objects  = [
                  g_prompt    bitmap_title;
                  g_helpbar   bitmap_help;
                  g_button    bitmap_ok;
                  g_button    bitmap_cancel;
                  g_prompt    bitmap_pr_idname;
                  g_prompt    bitmap_pr_callback;
                  g_string    bitmap_idname;
                  g_string    bitmap_callback;
                  g_button    bitmap_image;
                  g_prompt    bitmap_pr_editbitmap;
                  g_button    bitmap_edit
                 ];
  time_callback = gr_do_nothing;
  resize_callback = gr_do_nothing;
  help_file = "";
  miscellaneous = [| |]
};;



let bitmap_call=ref "";;
let bitmap_name=ref "";;
let bitmap_id=ref "";;


let bitmap_init Id Name Callback =
  bitmap_call := Callback;
  bitmap_id := Id;
  bitmap_name := Name;
  bitmap_idname.st_cursor <-0;
  bitmap_callback.st_cursor <-0;
  bitmap_idname.st_1st_char <-0;
  bitmap_callback.st_1st_char <-0;
  bitmap_idname.st_name <- Id;
  bitmap_callback.st_name <- Callback
;;


let bitmap_restore () =
  bitmap_idname.st_name <- !bitmap_id;
  bitmap_callback.st_name <- !bitmap_call
;;



let CloseBitmapCfg Obj Event =
  gr_erase_window cfg_bitmap.win_def;;

let CancelBitmapCfg Obj Event =
  bitmap_restore ();
  gr_erase_window cfg_bitmap.win_def
;;

let EditBitmapCfg Obj Event =
  EditCallback bitmap_callback.st_name;
  true
;;

let EditImageCfg Obj Event =
  load_icon !bitmap_name;
  icon_name.st_name <- !bitmap_name;
  gr_block_loop CamliconWin;
  bitmap_name := icon_name.st_name;
  true
;;


bitmap_ok.bt_callback     <- CloseBitmapCfg;;
bitmap_cancel.bt_callback <- CancelBitmapCfg;;
bitmap_edit.bt_callback   <- EditBitmapCfg;;
bitmap_image.bt_callback  <- EditImageCfg;;

