#open "windows";;
#open "camlwin";;

#open "sys";;
#open "printexc";;


#open "confdraw";;
#open "globdraw";;
#open "camldraw";;
#open "objdraw";;
#open "grdraw";;
#open "tooldraw";;

#open "saveicon";;
#open "camlicon";;





let make_name Name =
  Name ^ (string_of_int ((list_length DesignWin.win_objects)+
                         (toolb_length ())-2))
;;

let update_lists Name Callback Images =
  add_object (make_name Name)
             Callback
             Images;
  gr_draw_window design_win.win_id;
  window_saved := false;
  UpdateObject (id_name_vect !obj_def !toolb_def)
;;


(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let AddObject Grpbut Event =
  if DesignWin.win_def.win_state = Destroyed
  then false
  else
  (
  let width = gr_to_win_coord (window_width design_win.win_id)
  and height =  gr_to_win_coord (window_height design_win.win_id) in

  match Grpbut.gb_button with
    0  -> (* add a button*)
        (
          let button= {
                       bt_window=design_win;
                       bt_left=width/2-12;
                       bt_top=height/2+5;
                       bt_width=25;
                       bt_height=10;
                       bt_name=string_type "Button";
                       bt_state=Up;
                       bt_callback= gr_do_nothing
                      } in
            DesignWin.win_objects <- DesignWin.win_objects @ [g_button button];
            update_lists "button" "gr_do_nothing" [| "" |];
            true
        )

  | 1  -> (* add a string *)
        (
          let String = {
                        st_window=design_win;
                        st_left=width/2-37;
                        st_top=height/2+5;
                        st_width=75;
                        st_cursor=0;
                        st_1st_char=0;
                        st_name="String";
                        st_type=Gr_string;
                        st_state=Editable;
                        st_callback= gr_do_nothing
                       } in
            DesignWin.win_objects <- DesignWin.win_objects @ [g_string String];
            update_lists "string" "gr_do_nothing" [| |];
            true
        )
  | 2  -> (* add a text *)
        (
          let Text = gr_make_text {
                      t_window=design_win;
                      t_top=height/2+25;
                      t_left=width/2-25;
                      t_width=50;
                      t_height=50;
                      t_name=gr_lines_of_string "Text";
                      t_state=Editable;
                      t_scroll=Vscroll
                     }  in
            DesignWin.win_objects <- DesignWin.win_objects @ [g_text Text];
            update_lists "text" "gr_do_nothing" [| |];
            true
        )
  | 3  -> (* add a toolbar *)
        (
          if not (had_toolbar DesignWin.win_objects)
          then
            (
              let toolbar= {
                            tb_window=design_win;
                            tb_items=[| |]
                           } in
                DesignWin.win_objects <-DesignWin.win_objects @ [g_toolbar toolbar];
                update_lists "toolbar" "gr_do_nothing" [| |];
                true
            )
          else false
        )

  | 4  -> (* add a list *)
        (
          let List = {
                      li_window=design_win;
                      li_left=width/2-25;
                      li_top=height/2+25;
                      li_width=50;
                      li_height=50;
                      li_nu_item=0;
                      li_1st_item=0;
                      li_scroll=0;
                      li_items=[| "item1"; "item2" |];
                      li_callback= gr_do_nothing
                     } in
            DesignWin.win_objects <- DesignWin.win_objects @ [g_list List];
            update_lists "list" "gr_do_nothing" [| |];
            true
        )
  | 5  -> (* add a prompt *)
        (
          let Prompt = {
                        pt_window=design_win;
                        pt_left=width/2-10;
                        pt_top=height/2+2;
                        pt_name="Prompt:"
                       } in
            DesignWin.win_objects <- DesignWin.win_objects @ [g_prompt Prompt];
            update_lists "prompt" "gr_do_nothing" [| |];
            true
        )
  | 6  -> (* add an icon *)
        (
          let Bitmap = {
                        bm_window=design_win;
                        bm_left=width/2-8;
                        bm_top=height/2+8;
                        bm_bitmap=make_image (make_matrix 32 32 black);
                        bm_callback=gr_do_nothing
                       } in
            gr_block_loop CamliconWin;
            let image_name=icon_name.st_name in
              Bitmap.bm_bitmap <- load_bitmap image_name Bitmap.bm_bitmap;
              DesignWin.win_objects <- DesignWin.win_objects @ [g_bitmap Bitmap];
              update_lists "bitmap" "gr_do_nothing" [| image_name |];
            true
        )
  | 7  -> (* add a scrollbar *)
        (
          let Scroll = {
                        sb_window=design_win;
                        sb_left=width/2-2;
                        sb_top=height/2+25;
                        sb_length=50;
                        sb_pos=0;
                        sb_delta=10;
                        sb_dir=Vertical;
                        sb_callback= gr_do_nothing
                       } in
            DesignWin.win_objects <- DesignWin.win_objects @ [g_scrollbar Scroll];
            update_lists "scrollbar" "gr_do_nothing" [| |];
            true
        )
  | 8  -> (* add a helpbar *)
        (
          if not (had_helpbar DesignWin.win_objects)
          then
            (
              let helpbar= {
                            hl_window=design_win;
                            hl_help="Helpbar"
                           } in
                DesignWin.win_objects <- DesignWin.win_objects @ [g_helpbar helpbar];
                update_lists "helpbar" "gr_do_nothing" [| |];
                true
            )
          else false
        )
  | 9  -> (* add a radio button *)
        (
          let Radio = {
                       ra_window=design_win;
                       ra_left=width/2-25;
                       ra_top=height/2+25;
                       ra_state=false;
                       ra_name="radio button";
                       ra_callback=gr_do_nothing
                      } in
            DesignWin.win_objects <- DesignWin.win_objects @ [g_radio Radio];
            update_lists "radio" "gr_do_nothing" [| |];
            true
        )
  | 10 -> (* add a group of buttons *)
        (
          let Grpbut = {
                         gb_window=design_win;
                         gb_top=height/2+15;
                         gb_left=width/2-25;
                         gb_width=50;
                         gb_height=30;
                         gb_delta=4;
                         gb_btwidth=40;
                         gb_btheight=10;
                         gb_dir=Vertical;
                         gb_button=0;
                         gb_name=[| string_type "1st option"; string_type "2nd option" |];
                         gb_callback=gr_do_nothing
                       } in
            DesignWin.win_objects <- DesignWin.win_objects @ [g_grpbut Grpbut];
            update_lists "grpbut" "gr_do_nothing" [| ""; "" |];
            true
        )
  | 11 -> (* add a group of radio buttons *)
        (
          let Grprad = {
                         ga_window=design_win;
                         ga_top=height/2+15;
                         ga_left=width/2-30;
                         ga_width=60;
                         ga_height=30;
                         ga_delta=5;
                         ga_radio=0;
                         ga_name=[| "1st choice" |];
                         ga_callback=gr_do_nothing
                       } in
            DesignWin.win_objects <- DesignWin.win_objects @ [g_grprad Grprad];
            update_lists "grprad" "gr_do_nothing" [| |];
            true
        )
  | 12 -> (* add a graphical object *)
        (
          gr_block_loop cfg_graph;
          if !graph_end
          then (* button Ok pressed -> add an object *)
          (
            match graph_type.ga_radio with
              0 -> (* add a line *)
                  let Line = {
                              ln_window=design_win;
                              ln_color=black;
                              ln_point1=(width/2-5,height/2+5);
                              ln_point2=(width/2+5,height/2-5)
                             } in
                    DesignWin.win_objects <- DesignWin.win_objects @ [g_line Line];
                    update_lists "line" "gr_do_nothing" [| |];
                    true

            | 1 -> (* add a rectangle *)
                  let Rectangle = {
                                   re_window=design_win;
                                   re_filled=true;
                                   re_color=black;
                                   re_point=(width/2-5,height/2-5);
                                   re_width=10;
                                   re_height=10
                                  } in
                    DesignWin.win_objects <- DesignWin.win_objects @ [g_rectangle Rectangle];
                    update_lists "rectangle" "gr_do_nothing" [| |];
                    true

            | 2 -> (* add a circle *)
                  let Ellipse = {
                                 el_window=design_win;
                                 el_filled=true;
                                 el_color=black;
                                 el_center=(width/2,height/2);
                                 el_xray=5;
                                 el_yray=5
                                } in
                    DesignWin.win_objects <- DesignWin.win_objects @ [g_ellipse Ellipse];
                    update_lists "ellipse" "gr_do_nothing" [| |];
                    true

            | _ -> false
          )
          else (* button Cancel pressed -> do nothing *)
            false
        )
  | 13 -> (* add a shell *)
        (
          let Shell = gr_make_shell {
                      s_window=design_win;
                      s_top=height/2+25;
                      s_left=width/2-25;
                      s_width=50;
                      s_height=50;
                      s_state=Editable
                     }  in
            DesignWin.win_objects <- DesignWin.win_objects @ [g_shell Shell];
            update_lists "shell" "gr_do_nothing" [| |];
            true
        )
  | 14 -> (* add an area *)
        (
          let Area = {
                      ar_window=design_win;
                      ar_top=height/2+25;
                      ar_left=width/2-25;
                      ar_width=50;
                      ar_height=50;
                      ar_name="Area"
                     }  in
            DesignWin.win_objects <- DesignWin.win_objects @ [g_area Area];
            update_lists "area" "gr_do_nothing" [| |];
            true
        )
  | 15 -> (* add an exprompt *)
        (
          let Prompt = {
                      expt_window=design_win;
                      expt_top=height/2+25;
                      expt_left=width/2-25;
                      expt_name= { f_type = Proportional_font;
                                   f_att = Italic;
                                   f_size = Size2_font;
                                   f_color = black;
                                   f_string = "ExPrompt"
                                 }
                     }  in
            DesignWin.win_objects <- DesignWin.win_objects @ [g_exprompt Prompt];
            update_lists "exprompt" "gr_do_nothing" [| |];
            true
        )
  | 16 -> (* add an extext *)
        (
          let Text = {
                      extx_window=design_win;
                      extx_top=height/2+25;
                      extx_left=width/2-25;
                      extx_width=50;
                      extx_height=50;
                      extx_name="ExText";
                      extx_scroll=0;
                      extx_anchors=[];
                      extx_content=[|{ l_indent=10;
                                       l_line=false;
                                       l_content=[ { f_type=Proportional_font;
                                                     f_att =Italic;
                                                     f_size=Size2_font;
                                                     f_color=black;
                                                     f_string="ExText"
                                                   } ] } |];
                      extx_callback = gr_extext_callback
                     }  in
            DesignWin.win_objects <- DesignWin.win_objects @ [g_extext Text];
            update_lists "extext" "gr_do_nothing" [| |];
            true
        )
  | _  -> false
  )
;;






(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let AddItem () =
  if had_toolbar DesignWin.win_objects
  then
  (
    let Toolb = get_toolbar DesignWin.win_objects
    and nu_menu = toolb_menu.li_nu_item in
      let Menu = Toolb.tb_items.(nu_menu) in
        let Item = {
                    it_window=design_win;
                    it_name="";
                    it_state=Unselected;
                    it_callback= gr_do_nothing
                   } in
          let len=(vect_length Menu.mn_items)
          and pos=(toolb_item.li_nu_item) in
            let b=sub_vect Menu.mn_items 0 pos
            and e=sub_vect Menu.mn_items pos (len-pos) in
              Menu.mn_items <- concat_vect b (concat_vect [| Item |] e);
            let b=sub_vect !toolb_def.(nu_menu).items_def 0 pos
            and e=sub_vect !toolb_def.(nu_menu).items_def pos (len-pos) in
              !toolb_def.(nu_menu).items_def <-
                  concat_vect b (concat_vect [| ("","gr_do_nothing") |] e);
            Item.it_name <- make_name "item";
            !toolb_def.(nu_menu).items_def.(pos) <- (Item.it_name,"gr_do_nothing");
            window_saved := false;
            UpdateObject (id_name_vect !obj_def !toolb_def);
            true
  )
  else false
;;


(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let AddMenu () =
  if had_toolbar DesignWin.win_objects
  then
  (
    let Toolb = get_toolbar DesignWin.win_objects in
      let Menu = {
                   mn_window=design_win;
                   mn_left=0;
                   mn_top=0;
                   mn_state=Unvisible;
                   mn_nu_item=0;
                   mn_name="";
                   mn_items=[| |];
                   mn_hide_area=gr_empty_image
                 } in
        let len=(vect_length Toolb.tb_items)
        and pos=(toolb_menu.li_nu_item) in
          let b=sub_vect Toolb.tb_items 0 pos
          and e=sub_vect Toolb.tb_items pos (len-pos) in
            Toolb.tb_items <- concat_vect b (concat_vect [| Menu |] e);
          let b=sub_vect !toolb_def 0 pos
          and e=sub_vect !toolb_def pos (len-pos) in
            toolb_def := concat_vect b (concat_vect [| {menu_name=""; items_def=[||]} |] e);
          Menu.mn_name <- make_name "menu";
          !toolb_def.(pos).menu_name <- Menu.mn_name;
          window_saved := false;
          UpdateObject (id_name_vect !obj_def !toolb_def);
          true
  )
  else false
;;



