#open "globals";;
#open "compiler";;

let extensions ext_act f=
  let rec ext_rec = function
    [] -> failwith ("Don't know what to do with " ^ f)
  | (ext,act)::rest -> 
      if filename__check_suffix f ext
       then let file = filename__chop_suffix f ext in
             act (filename__basename file) file
       else ext_rec rest
  in ext_rec ext_act
;;

let anonymous file =
  lexer__reset_infix();
  modules__reset_modules();
  uses_conv := false;
  if not file_exists file then failwith ("Cannot find '" ^ file ^ "'");
  extensions 
    [ ".caml", convert_implementation;
      ".camli", convert_interface;
      ".mlc", convert_mlc ]
    file;
  if !uses_conv then warn "uses module of conversion"

and set_zlc s =
  core_lib := s
and set_output s =
  output_lib := s
and add_include d =
  load_path := d :: !load_path
and open_set set =
  try
    modules__default_used_modules := assoc set default_used_interfaces
  with Not_found ->
    failwith ("unknown module set " ^ set)
and log_mode () =
  verbose := true
and no_warnings() =
  warn_flag := false
;;

let main() =
try
  sys__catch_break true;
  modules__default_used_modules := assoc "cautious" default_used_interfaces;
  load_path := [];
  arg__parse ["-clib", arg__String set_zlc;
              "-o", arg__String set_output;
              "-c", arg__String parse_mlc__compile_stdfile;
              "-I", arg__String add_include;
              "-include", arg__String add_include;
              "-O", arg__String open_set;
              "-open", arg__String open_set;
              "-L", arg__Unit log_mode;
              "-W", arg__Unit no_warnings;
              "-", arg__String anonymous]
             anonymous;
  exit 0
with Failure s -> prerr_endline ("Fatal error: " ^ s ^ "."); exit 2
   | sys__Break -> exit 2
   | sys__Sys_error msg ->
      prerr_endline ("Input/output error: " ^ msg ^ ".");
      exit 2
   | e -> prerr_endline "Unexpected exception. Please report."; raise e
;;

printexc__f main (); exit 0;;
