#!/bin/sh

libdir=INSTALLDIR
clib=LIBNAME
includes="-I $libdir"
options=""
output="a.zlc"

while : ; do
  case $1 in
    "")
        break;;
    -clib)
      clib=$2
      shift;;
    -I|-include)
      includes="$includes -I $2"
      shift;;
    -o)
      output=$2
      shift;;
    -O|-open)
      options="$options -O $2"
      shift;;
    -L|-verbose)
      options="$options -L";;
    -W|nowarning)
      options="$options -W";;
    -c)
      camlrun  $libdir/caml2csl \
            -clib $clib $includes $options -o $output -c $2 || exit 2
      shift;;
    -*)
      echo "Unknown option \"$1\", ignored" >&2;;
    *)
      camlrun $libdir/caml2csl \
            -clib $clib $includes $options $1 || exit 2 ;;
  esac
  shift
done

