/*-------------------------------------------------------------------------
 *  TULP - Unix Mailing List manager (sub-set of FRECP's
 *         Bitnet Listserv tool).
 *
 *  Copyright (C) 1991-1994  Kimmo Suominen, Christophe Wolfhugel
 *
 *  Please read the files COPYRIGHT and AUTHORS for the extended
 *  copyrights refering to this file.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *----------------------------------------------------------------------*/

static char rcsid[] = "@(#)vers.c,v 1.1.1.1 1997/06/05 02:15:27 woods Exp";

/*
 * 1.1.1.1
 */

#include <stdio.h>
#include "conf.h"

char vers[64], versFrom[116];
#ifdef ADD_SENDER
char versSender[124];
#endif

#include <sys/param.h>
#ifdef USE_UNAME
# include <sys/utsname.h>
#endif
#if defined(USE_UNAME) || defined(USE_GETHOSTNAME)
# include <sys/types.h>
# include <sys/socket.h>
# include <netdb.h>
char myname[MAXHOSTNAMELEN];
#endif

void versInit()
{
#if defined(USE_UNAME) || defined(USE_GETHOSTNAME)
  struct hostent *netname;
#endif
#ifdef USE_GETHOSTNAME
  char name[MAXHOSTNAMELEN];
#endif
#ifdef USE_UNAME
  struct utsname name;
  uname(&name);
  netname = gethostbyname(name.nodename);
#endif
#ifdef USE_GETHOSTNAME
  gethostname(name, MAXHOSTNAMELEN);
  netname = gethostbyname(name);
#endif
#if defined(USE_UNAME) || defined(USE_GETHOSTNAME)
  strcpy(myname, netname->h_name);
#endif
  sprintf(vers,"Listserv v%s",VERSION);
  sprintf(versFrom,"From: listserv@%s (%s)\n",HOST,vers);
#ifdef ADD_SENDER
  sprintf(versSender,"Sender: list-errors@%s\n",HOST);
#endif
}
