#ifndef lint
static char *rcsid = "@(#) queue.c,v 1.2 1997/07/02 18:48:37 woods Exp";
static char *copid = "@(#) Copyright (C) 1993  Christophe Wolfhugel & Herve Schauer Consultants";
#endif
/*
**  ML - A Unix Mailing Lists manager.
**
**  Copyright (C) 1994  Christophe Wolfhugel & Herve Schauer Consultants
**
**  Please read the files COPYRIGHT and AUTHORS for the extended
**  copyrights refering to this file.
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 1, or (at your option)
**  any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <sys/cdefs.h>
#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <sysexits.h>
#include "conf.h"
#ifdef FAKESYSLOG
# include "fakesyslog.h"
#else
# include <syslog.h>
#endif

static char	qfile[26*2];
static char	buf[BUFSIZ];
static int	i, fd;

/*
** Main loop.
*/
int
main(argn, argv)
   int argn;
   char *argv[];
{
   openlog("tulp-enqueue", LOG_PID, LOG_MAIL);
   if (argn != 2) {
      syslog(LOG_WARNING, "Invalid number of arguments");
      exit(EX_USAGE);
   }
   if (chdir(QUEUE_DIR) == -1) {
      syslog(LOG_WARNING, "Can't chdir to %s: %m", QUEUE_DIR);
      exit(EX_OSFILE);
   }
   umask(UMASK);			/* error check? */
   sleep(1);
   sprintf(qfile, "%ld.%d", (long)time((time_t *)NULL), getpid());
   qfile[2] = 'T';
   fd = open(qfile + 2, O_CREAT|O_WRONLY, 0600);
   if (fd == -1) {
      syslog(LOG_ERR, "Could not open %s: %m", qfile +2);
      exit(EX_CANTCREAT);
   }
   if (write(fd, "X-Listserv-To: ", 15) < 15) {
      syslog(LOG_ERR, "error writing %s: %s", qfile + 2, strerror(errno));
      exit(EX_IOERR);
   }
   if (write(fd, argv[1], strlen(argv[1])) == -1) {
      syslog(LOG_ERR, "error writing %s: %s", qfile + 2, strerror(errno));
      exit(EX_IOERR);
   }
   if (write(fd, "\n", 1) < 1) {
      syslog(LOG_ERR, "error writing %s: %s", qfile + 2, strerror(errno));
      exit(EX_IOERR);
   }
   while ((i = read(fileno(stdin), buf, sizeof buf)) > 0) {
     if (write(fd, buf, i) < i) {
       syslog(LOG_ERR, "error writing %s: %s", qfile + 2, strerror(errno));
       exit(EX_IOERR);
     }
   }
   if (close(fd) == -1) {
     syslog(LOG_ERR, "error closing %s: %s", qfile + 2, strerror(errno));
     exit(EX_IOERR);
   }
   if (rename(qfile + 2, qfile + 3) == -1) {
     syslog(LOG_ERR, "error renaming %s to %s: %s", qfile + 2, qfile + 3, strerror(errno));
     exit(EX_IOERR);
   }
   exit(0);
}
