#! /local/bin/perl

eval 'exec /local/bin/perl -S $0 ${1+"$@"}'
   if $running_under_some_shell;

#
# deliver.pl -- a filter front-end for TULP's queue command.
#

$ENV{'PATH'} = '/bin:/usr/bin:/usr/lib';

## Put here your local delivery agent (see sendmail.cf)
$tulpenqueue = "/local/libexec/tulp-enqueue";

## Path to Sendmail
$sendmail = "/usr/lib/sendmail";

## the local domain name
$mailserver = "weird.com";

## Should the UNIX From line be removed ?  True on many systems.
$nofrom = 1;

## Regexps for the unwanted strings.

@avoid_hdr = (
	      '(please\s+)?(add|unsub|remove|del|sub(\s|scribe)?|sign?o?f?f?)',
	      'subs?c?r?i?p?t?i?o?n?\s+requ?e?s?t?',
	      'listserve?r?\s+requ?e?s?t?',
	      '^\s*APPR?O?V?E?\s+([A-Z0-9.@-]+)\s+.+\s+[0-9]+\s*$',
	      '^\s*DISC?A?R?D?\s+([A-Z0-9.@-]+)\s+.+\s+[0-9]+\s*$',
	      '^\s*EDIT\s+([A-Z0-9.@-]+)\s+.+\s+[A-Z]+\s*$',
	      '^\s*GET\s+[A-Z0-9/.-]+.+',
	      '^\s*HELP\s*[A-Z0-9]*$',
	      '^\s*INDEX\s*[A-Z0-9/.-]*.*',
	      '^\s*INFO?R?M?A?T?I?O?N?\s+([A-Z0-9.@-]+)\s*$',
	      '^\s*LIST?S?\s*$',
	      '^\s*PUT\s+([A-Z0-9.@-]+)\s+.+',
	      '^\s*RECI?P?I?E?N?T?S?\s+([A-Z0-9.@-]+)\s*$',
	      '^\s*REVI?E?W?\s+([A-Z0-9.@-]+)\s*$',
	      '^\s*RELE?A?S?E?\s*$',
	      '^\s*REPO?R?T?S?\s+([A-Z0-9.@-]+)\s+.+$',
	      '^\s*RUN\s+([A-Z0-9.@-]+)',
	      '^\s*SET\s+([A-Z0-9.@-]+)',
	      '^\s*STAT?I?S?T?I?C?S?\s+([A-Z0-9.@-]+)',
	      '^\s*SUBS?C?R?I?B?E?\s+([A-Z0-9.@-]+).+',
	      '^\s*SYST?E?M?\s+([A-Z0-9.@-]+)\s+.+\s+#.+',
	      '^\s*UNSU?B?S?C?R?I?B?E?\s*([A-Z0-9.@-]*)',
	      '^\s*SIGN?O?F?F?\s*([A-Z0-9.@-]*)',
	      '^\s*REMOVE\sME',
	      '^\s*PLEASE\s+REMOVE\s+',
	      '^\s*PLEASE\s+UNSU?B?S?C?R?I?B?E?\s+',
	      '^\s*PLEASE\s+SIGN?O?F?F?\s+',
	      '^\s*PLEASE\s+SUBS?C?R?I?B?E?\s+',
	      '^\s*PLEASE\s+ADD\s+',
	      '^\s*WHIC?H?\s*$',
	      '^\s*SHUTDOWN\s+.+$',
	      '^\s*RESTART\s+.+$',
	      '^\s*EXEC?U?T?E?\s+.+#.+'
	      );
@avoid_msg = (
	      '^\s*(please\s+)?(add|unsub|remove|del|sub(\s|scribe)?|sign?o?f?f?)',
	      '^\s*APPR?O?V?E?\s+([A-Z0-9.@-]+)\s+.+\s+[0-9]+\s*$',
	      '^\s*DISC?A?R?D?\s+([A-Z0-9.@-]+)\s+.+\s+[0-9]+\s*$',
	      '^\s*EDIT\s+([A-Z0-9.@-]+)\s+.+\s+[A-Z]+\s*$',
	      '^\s*GET\s+[A-Z0-9/.-]+.+',
	      '^\s*HELP\s*[A-Z0-9]*$',
	      '^\s*INDEX\s*[A-Z0-9/.-]*',
	      '^\s*INFO?R?M?A?T?I?O?N?\s+([A-Z0-9.@-]+)\s*$',
	      '^\s*LIST?S?\s*$',
	      '^\s*PUT\s+([A-Z0-9.@-]+)\s+.+',
	      '^\s*RECI?P?I?E?N?T?S?\s+([A-Z0-9.@-]+)\s*$',
	      '^\s*REVI?E?W?\s+([A-Z0-9.@-]+)\s*$',
	      '^\s*RELE?A?S?E?\s*$',
	      '^\s*REPO?R?T?S?\s+([A-Z0-9.@-]+)\s+.+$',
	      '^\s*RUN\s+([A-Z0-9.@-]+)',
	      '^\s*SET\s+([A-Z0-9.@-]+)',
	      '^\s*STAT?I?S?T?I?C?S?\s+([A-Z0-9.@-]+)',
	      '^\s*SUBS?C?R?I?B?E?\s+([A-Z0-9.@-]+).+',
	      '^\s*SYST?E?M?\s+([A-Z0-9.@-]+)\s+.+\s+#.+',
	      '^\s*UNSU?B?S?C?R?I?B?E?\s*([A-Z0-9.@-]*)',
	      '^\s*SIGN?O?F?F?\s*([A-Z0-9.@-]*)',
	      '^\s*REMOVE\sME',
	      '^\s*PLEASE\s+REMOVE\s+',
	      '^\s*PLEASE\s+UNSU?B?S?C?R?I?B?E?\s+',
	      '^\s*PLEASE\s+SIGN?O?F?F?\s+',
	      '^\s*PLEASE\s+SUBS?C?R?I?B?E?\s+',
	      '^\s*PLEASE\s+ADD\s+',
	      '^\s*WHIC?H?\s*$',
	      '^\s*SHUTDOWN\s+.+$',
	      '^\s*RESTART\s+.+$',
	      '^\s*EXEC?U?T?E?\s+.+#.+'
	      );

$arg = $ARGV[0];
@ARGV = ();

## Paragraph mode
$/ = ""; 
$* =  1;

## Get the header.
$hdr = <>;
$hdr =~ s/^From\s+.+\n//i if ($nofrom == 1);

## Get the entire message
$* = 0;
$/ = "\n";
while (<>) {
   push(@line, $_);
}

## If more than 10 lines or to listserv or *-request then it should be okay.
&putMsg() if ($arg =~ /^listserv$/i);
&putMsg() if ($arg =~ /^.*-request$/i);
&putMsg() if ($#line > 10);

$nhdr = $hdr;

$/ = ""; 
$* =  1;

$nhdr =~ s/\n\s+/ /g;

$from = $1 if ($nhdr =~ /^From:\s+(.+)\s*$/i);
$subject = $1 if ($nhdr =~ /^Subject:\s+(.+)\s*$/i);

if ($subject) {
   foreach $avoid (@avoid_hdr) {
      if ($subject =~ /($avoid)/i) {  ## We have a suspicious header
	 $line = "Subject: $subject";
         &mailMsg();
      }
   }
}

$* = 0;
$/ = "\n";

foreach $line (@line) {
   foreach $avoid (@avoid_msg) {
      if ($line =~ /($avoid)/i) {  ## We have a suspicious line
         &mailMsg();
      }
   }
}


&putMsg();

exit(0);

sub putMsg {
   open(STDOUT, "|-") || exec $tulpenqueue, $arg;
   print $hdr;
   print @line;
   close(STDOUT);
   exit(0);
}

### original french message body text:
#
# Le message suivant a ete adresse a la liste $arg alors qu'il semble
# contenir des commandes telles subscribe, signoff, help, index, get...
# 
# Si effectivement votre message contenait une commande, sachez
# que les commandes ne doivent en aucun cas etre adresses aux listes
# (en vous abonnant a cette liste vous aviez recu les instructions
# d'utilisation, qu'en avez-vous fait ?).
# Sachez que les commandes doivent etre envoyees a l'adresse
# listserv@grasp.insa-lyon.fr uniquement.
# 
# Si votre message etait effectivement destine a la liste, celui-ci
# a malheureusement ete interprete par le logiciel comme une
# commande. Veuillez contacter le gestionnaire du service:
# $arg-request@grasp.insa-lyon.fr afin qu'il s'occupe de votre
# message.     Merci de votre attention.
#
sub mailMsg {
   $from = "postmaster" if (!$from);
   open(STDOUT, "|-") || exec $sendmail, '-f', 'owner-listserv', '-t';
   print "To: $from\n";
   print "Subject: [listserv]: usage error ($arg)?\n";
   print "Bcc: postmaster, owner-$arg\n\n";
   print "
The list server has detected what appears to be a server command in a
message directed to the list '$arg'.

The line tht looked suspicious was:
   $line

The pattern it matched was:
   '$avoid'

If you have any questions regarding this specific list, please contact
the following address: <owner-$arg@$mailserver>.

If you have any questions regarding this mail server, please contact
the following address: <postmaster@$mailserver>.

------ Begin message --------
X-Listserv-To: $arg\n";
   print $hdr;
   print @line;
   print "------- End message ---------\n";
   close(STDOUT);
   exit(0);
}
