#ifndef lint
static char rcsid[] = "daemon.c,v 1.1 1997/07/02 18:22:13 woods Exp";
#endif

#include <fcntl.h>
#include "conf.h"

#if !defined(NEED_DAEMON)
int __tulp_compat_daemon;		/* a global to keep the linker happy */
#else

#ifdef HAVE_ARGV0
# include <stdio.h>
#endif
#include <sys/param.h>
#if defined(HAVE_UNISTD_H)
# include <unistd.h>
#endif
#if defined(HAVE_LIMITS_H)
# include <limits.h>
#endif
#ifndef PATH_MAX
# ifdef MAXPATHLEN
#  define PATH_MAX	MAXPATHLEN
# else
#  define PATH_MAX	1024		/* should use pathconf() */
# endif
#endif
#if defined(HAVE_PATHS_H)
# include <paths.h>
#endif

#ifndef STDIN_FILENO
# define STDIN_FILENO	0
#endif
#ifndef STDOUT_FILENO
# define STDOUT_FILENO	1
#endif
#ifndef STDERR_FILENO
# define STDERR_FILENO	2
#endif

#ifndef _PATH_DEVNULL
# define _PATH_DEVNULL	"/dev/null"
#endif
#ifndef _PATH_ROOT
# define _PATH_ROOT	"/"
#endif
#ifndef _PATH_VARRUN
# define _PATH_VARRUN	"/var/run/"
#endif

int
daemon(nochdir, noclose)
	int nochdir;
	int noclose;
{
	int fd;
#ifdef HAVE_ARGV0
	FILE *pidfile = NULL;
	char pidfn[PATH_MAX];
	extern char *argv0;
#endif

	switch (fork()) {
	case -1:
		return(-1);
		/* NOTREACHED */
	case 0:
		/* child */
		break;
	default:
		/* parent */
		_exit(0);
		/* NOTREACHED */
	}
	if (!nochdir) {
		if (chdir("/") == -1)
			return(-1);
	}
# ifdef USE_SETSID
	if (setsid() == -1)
		return(-1);
# else
#  if defined(SYSV) || defined(hpux)
	if (setpgrp() == -1)
		return(-1);
#  else
	{
		struct itimerval ival;
		/*
		 * The open below may hang on pseudo ttys if the person
		 * who starts named logs out before this point.
		 */
		bzero((char *)&ival, sizeof(ival));
		ival.it_value.tv_sec = 120;
		(void) setitimer(ITIMER_REAL, &ival,
			    (struct itimerval *)NULL);
		if ((n = open(_PATH_TTY, O_RDWR)) == -1)
			panic(errno, "open(_PATH_TTY)");
		ival.it_value.tv_sec = 0;
		(void) setitimer(ITIMER_REAL, &ival,
			    (struct itimerval *)NULL);
		if (n > 0) {
			(void) ioctl(n, TIOCNOTTY, (char *)NULL);
			(void) my_close(n);
		}
	}
#  endif /* SYSV || hpux */
# endif /* USE_SETSID */
	if (!noclose && (fd = open(_PATH_DEVNULL, O_RDWR, 0)) != -1) {
		(void) dup2(fd, STDIN_FILENO);
		(void) dup2(fd, STDOUT_FILENO);
		(void) dup2(fd, STDERR_FILENO);
		if (fd > 2)
			(void) close (fd);
        }
#ifdef HAVE_ARGV0
	sprintf(pidfn, "%s%s.pid", _PATH_VARRUN, argv0);
        pidfile = fopen(pidfn, "w");
	if (pidfile) {
                fprintf(pidfile, "%d\n", getpid());
                fclose(pidfile);
        }
#endif

        return (0);
}

#endif /* NEED_DAEMON */
